/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNode;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNodeException;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCodeCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.BlockManager;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeManager;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FaverChipNodeCon
extends FaverChipNode {
    final int REAL_DATA_SIZE = 16384;
    final int MANAGEMENT_SIZE = 6144;
    final int BEGIN_EDIT_AREA = 128;
    final int END_EDIT_AREA = 15615;
    NodeCodeManager manager;

    @Override
    public void create(File file) throws IOException {
        this.realDataSize = 16384;
        this.managementSize = 6144;
        this.beginEditArea = 128;
        this.endEditArea = 15615;
        if (!file.canRead()) {
            throw new IOException(Resource.getString("FC_READ_ERR"));
        }
        int n = (int)file.length();
        if (n < this.realDataSize + this.managementSize) {
            throw new IOException(Resource.getString("FC_DIFFERENT_VERSION"));
        }
        if (n > this.realDataSize + this.managementSize) {
            throw new IOException(Resource.getString("FC_FILE_BREAKS"));
        }
        this.originData = new byte[16384];
        this.originManagementInfo = new byte[6144];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(this.originData, 0, 16384);
        fileInputStream.read(this.originManagementInfo, 0, 6144);
        fileInputStream.close();
        BlockManager blockManager = new BlockManager(this.originData, this.originManagementInfo, 0);
        this.manager = blockManager.getNodeCodeManager();
        this.fcFile = file;
        this.editflag = false;
    }

    @Override
    public NodeCode getRootNodeCode() {
        return this.manager.getRootNodeCode();
    }

    @Override
    public NodeCode getNodeCodeByPath(Object[] objectArray) throws FaverChipNodeException {
        return this.manager.getNodeCodeByPath(objectArray);
    }

    @Override
    public void update() {
        this.savedata = this.manager.update(0);
        System.arraycopy(this.savedata, 0, this.originData, 0, 16384);
        System.arraycopy(this.savedata, 16384, this.originManagementInfo, 0, 6144);
        BlockManager blockManager = new BlockManager(this.originData, this.originManagementInfo, 0);
        this.manager = blockManager.getNodeCodeManager();
    }

    @Override
    public NodeCodeCheck getNodeCodeCheck() {
        return this.manager.getNodeCodeCheck();
    }

    @Override
    public void addPINNodeCode(NodeCode nodeCode, int n) throws FaverChipNodeException {
        this.manager.makeNewPINNode(nodeCode, n);
    }

    @Override
    public void deleteNodeCode(NodeCode nodeCode) {
        this.manager.deleteNodeCode(nodeCode);
    }

    @Override
    public void changeNodeCode(NodeCode nodeCode, String string) {
        this.manager.changeNodeCode(nodeCode, string);
    }

    @Override
    public void changeUserData(NodeCode nodeCode, String[] stringArray) throws FaverChipNodeException {
        this.manager.changeUserData((NodeCodeService)nodeCode, stringArray);
    }

    @Override
    public void changePINNode(NodeCode nodeCode) {
        this.manager.changePINNode(nodeCode);
    }

    @Override
    public void reorganization(NodeCode nodeCode) {
        this.manager.reorganization(nodeCode);
    }

    @Override
    public NodeCode getInitialNode(int n) {
        return this.manager.getInitialNode(n);
    }

    @Override
    public void removeNode(NodeCode nodeCode, String string) throws FaverChipNodeException {
        this.manager.removeNode(nodeCode, string);
    }

    @Override
    public void checkFreeBlock(NodeCode nodeCode, int n) throws FaverChipNodeException {
        this.manager.checkFreeBlock(nodeCode, n);
    }

    @Override
    public void setSystemBlocks(NodeCode nodeCode) throws FaverChipNodeException {
        this.manager.setSystemBlocks((NodeCodeSystem)nodeCode);
    }

    @Override
    public void compareUnusedBlock(NodeCode nodeCode, String string) throws FaverChipNodeException {
        this.manager.compareUnusedBlock((NodeCodeArea)nodeCode, string);
    }
}

