/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNodeException;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCodeCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.DefaultNodeCodeCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlockContainerID;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipIssue;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipManufacture;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipSystem;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipUnuse;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipUserData;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeCard;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeSystem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class NodeCodeManager {
    static final int AREA_TYPE_COMMON = 1;
    static final int AREA_TYPE_FREE = 2;
    static final int AREA_TYPE_DIVIDED = 3;
    private final String PRE_KEY_COMMON = "C_";
    private final String PRE_KEY_FREE = "F_";
    private final String PRE_KEY_DIVIDED = "D_";
    private final String KEY_ADD = "XXXX";
    private String preKey;
    private int areaType;
    private Hashtable hash = new Hashtable();
    private NodeCodeCard ncCard = new NodeCodeCard();
    private int pospos = 0;

    NodeCode getRootNodeCode() {
        return this.ncCard;
    }

    public NodeCodeCheck getNodeCodeCheck() {
        return new DefaultNodeCodeCheck(this.hash, this.ncCard);
    }

    public NodeCode getInitialNode(int n) {
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            FaverChipBlock faverChipBlock;
            NodeCode nodeCode;
            NodeCode nodeCode2 = (NodeCode)enumeration.nextElement();
            int n2 = nodeCode2.getNodeCodeType();
            if (n2 == 1) {
                nodeCode = (NodeCodeCard)nodeCode2;
                faverChipBlock = ((NodeCodeCard)nodeCode).getContainerIdBlock();
                if (faverChipBlock != null && faverChipBlock.position == n) {
                    return nodeCode2;
                }
                faverChipBlock = ((NodeCodeCard)nodeCode).getContainerIssueBlock();
                if (faverChipBlock == null || faverChipBlock.position != n) continue;
                return nodeCode2;
            }
            if (n2 == 2) {
                nodeCode = (NodeCodeSystem)nodeCode2;
                faverChipBlock = ((NodeCodeSystem)nodeCode).getManufactureBlock();
                if (faverChipBlock != null && faverChipBlock.position == n) {
                    return nodeCode2;
                }
                faverChipBlock = ((NodeCodeSystem)nodeCode).getIssueBlock();
                if (faverChipBlock != null && faverChipBlock.position == n) {
                    return nodeCode2;
                }
                faverChipBlock = ((NodeCodeSystem)nodeCode).getSystemBlock();
                if (faverChipBlock == null || faverChipBlock.position != n) continue;
                return nodeCode2;
            }
            if (n2 == 3) {
                nodeCode = (NodeCodeArea)nodeCode2;
                if (((NodeCodeArea)nodeCode).getAreaBlock().position != n) continue;
                return nodeCode2;
            }
            if (n2 != 4) continue;
            nodeCode = (NodeCodeService)nodeCode2;
            if (((NodeCodeService)nodeCode).getServiceBlock().position == n) {
                return nodeCode2;
            }
            Vector vector = nodeCode.getChildren();
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof FaverChipUserData) || ((FaverChipUserData)e).position != n) continue;
                return nodeCode2;
            }
        }
        return this.ncCard;
    }

    public void changeNodeCode(NodeCode nodeCode, String string) {
        int n = nodeCode.getAreaType();
        String string2 = "C_";
        if (n == 2) {
            string2 = "F_";
        } else if (n == 3) {
            string2 = "D_";
        }
        if (nodeCode.getAreaType() == 3 && nodeCode.getNodeCodeType() != 2) {
            if (this.hash.remove(string2 + this.getSystemNo(nodeCode) + "_" + string) == null && this.hash.remove("XXXX") == null) {
                return;
            }
            this.hash.put(string2 + this.getSystemNo(nodeCode) + "_" + nodeCode.getNodeCodeString(), nodeCode);
        } else {
            if (this.hash.remove(string2 + string) == null && this.hash.remove("XXXX") == null) {
                return;
            }
            this.hash.put(string2 + nodeCode.getNodeCodeString(), nodeCode);
        }
    }

    NodeCode getNodeCodeByPath(Object[] objectArray) throws FaverChipNodeException {
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null && !objectArray[i].toString().equals("")) continue;
            return null;
        }
        if (objectArray.length == 1) {
            return this.ncCard;
        }
        if (objectArray.length > 1) {
            string = this.hash.get("C_" + objectArray[1].toString()) != null ? "C_" : (this.hash.get("F_" + objectArray[1].toString()) != null ? "F_" : "D_");
            NodeCode nodeCode = null;
            NodeCodeSystem nodeCodeSystem = (NodeCodeSystem)this.hash.get(string + objectArray[1].toString());
            nodeCode = string.equals("D_") ? (nodeCodeSystem != null && objectArray.length > 2 ? (NodeCode)this.hash.get(string + this.getSystemNo(nodeCodeSystem) + "_" + objectArray[objectArray.length - 1].toString()) : (NodeCode)this.hash.get(string + objectArray[objectArray.length - 1].toString())) : (NodeCode)this.hash.get(string + objectArray[objectArray.length - 1].toString());
            if (nodeCode == null) {
                NodeCode nodeCode2 = null;
                if (objectArray[objectArray.length - 1].toString().equals(Resource.getString("FCH_NODE_NEW_AREA"))) {
                    nodeCode2 = nodeCodeSystem != null && string.equals("D_") ? (NodeCode)this.hash.get(string + this.getSystemNo(nodeCodeSystem) + "_" + objectArray[objectArray.length - 2].toString()) : (NodeCode)this.hash.get(string + objectArray[objectArray.length - 2].toString());
                    if (nodeCode2 != null) {
                        nodeCode = this.makeNewNode(nodeCode2, 0);
                    }
                } else if (objectArray[objectArray.length - 1].toString().equals(Resource.getString("FCH_NODE_NEW_SERVICE"))) {
                    nodeCode2 = nodeCodeSystem != null && string.equals("D_") ? (NodeCode)this.hash.get(string + this.getSystemNo(nodeCodeSystem) + "_" + objectArray[objectArray.length - 2].toString()) : (NodeCode)this.hash.get(string + objectArray[objectArray.length - 2].toString());
                    if (nodeCode2 != null) {
                        nodeCode = this.makeNewNode(nodeCode2, 1);
                    }
                } else if (objectArray[objectArray.length - 1].toString().equals(Resource.getString("FCH_NODE_DIV_SYSTEM"))) {
                    nodeCode = this.makeNewNodeSystem(this.ncCard);
                }
            }
            return nodeCode;
        }
        return null;
    }

    public void reorganization(NodeCode nodeCode) {
        if (nodeCode.getAreaType() == 2) {
            return;
        }
        if (nodeCode instanceof NodeCodeArea) {
            this.reorganizationInArea((NodeCodeArea)nodeCode);
        } else {
            this.reorganizationInService((NodeCodeService)nodeCode);
        }
        byte by = this.getSystemNo(nodeCode);
        NodeCodeArea nodeCodeArea = null;
        if (by == 0) {
            nodeCodeArea = (NodeCodeArea)this.hash.get("C_00000000");
            FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
            faverChipArea.getDataBytes();
        } else {
            nodeCodeArea = (NodeCodeArea)this.hash.get("D_" + by + "_00000000");
            FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
            faverChipArea.freeNum = faverChipArea.blockNum - this.getUseBlock(nodeCodeArea);
            faverChipArea.getDataBytes();
        }
        this.calcAssignedBlockNum(nodeCodeArea);
    }

    private void calcAssignedBlockNum(NodeCodeArea nodeCodeArea) {
        Vector vector = nodeCodeArea.getChildren();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof NodeCodeArea)) continue;
            this.calcAssignedBlockNum((NodeCodeArea)e);
            int n = this.getUseBlock((NodeCode)e);
            String string = Integer.toHexString(n).toUpperCase();
            ((NodeCodeArea)e).setUsedBlockNum(this.addZero(string, 4));
        }
    }

    private int getUseBlock(NodeCode nodeCode) {
        int n = 0;
        Vector vector = nodeCode.getChildren();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof NodeCodeSystem) {
                n += this.getUseBlock((NodeCode)e);
                continue;
            }
            if (e instanceof NodeCodeArea) {
                ++n;
                n += this.getUseBlock((NodeCode)e);
                continue;
            }
            if (!(e instanceof NodeCodeService)) continue;
            ++n;
            NodeCodeService nodeCodeService = (NodeCodeService)e;
            Vector vector2 = nodeCodeService.getChildren();
            for (int j = 0; j < vector2.size(); ++j) {
                hashtable.put(vector2.elementAt(j), new Object());
            }
        }
        return n += hashtable.size();
    }

    private void reorganizationInService(NodeCodeService nodeCodeService) {
        this.henseiService(nodeCodeService);
        NodeCodeArea nodeCodeArea = (NodeCodeArea)nodeCodeService.getParent();
        Vector vector = nodeCodeArea.getChildren();
        Object[] objectArray = nodeCodeArea.getChildren().toArray();
        Arrays.sort(objectArray, new NodeComparator(nodeCodeArea));
        vector.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
    }

    private void reorganizationInArea(NodeCodeArea nodeCodeArea) {
        int n;
        Object object;
        if (nodeCodeArea.getNodeCodeString().equals("00000000")) {
            return;
        }
        FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
        NodeCodeArea nodeCodeArea2 = (NodeCodeArea)nodeCodeArea.getParent();
        Vector vector = nodeCodeArea2.getChildren();
        Vector<NodeCode> vector2 = new Vector<NodeCode>();
        Vector vector3 = nodeCodeArea.getChildren();
        int n2 = vector3.size();
        for (int i = 0; i < n2; ++i) {
            FaverChipBlock faverChipBlock;
            NodeCode nodeCode = (NodeCode)vector3.elementAt(i);
            int n3 = nodeCode.getNodeCodeType();
            if (n3 == 3) {
                faverChipBlock = ((NodeCodeArea)nodeCode).getAreaBlock();
                if (((FaverChipArea)faverChipBlock).code >= faverChipArea.code && faverChipArea.endService >= ((FaverChipArea)faverChipBlock).code && nodeCodeArea.canCreateArea()) continue;
                object = nodeCode.getBytes(nodeCodeArea2.getNodeCodeString());
                ((FaverChipArea)faverChipBlock).setInfoBytes((byte[])object, 0, 1, 4);
                ((NodeCodeArea)nodeCode).setArea(faverChipBlock);
                nodeCode.setParent(nodeCodeArea2);
                nodeCodeArea2.setChild(nodeCode);
                vector2.addElement(nodeCode);
                continue;
            }
            if (n3 != 4) continue;
            faverChipBlock = ((NodeCodeService)nodeCode).getServiceBlock();
            if (((FaverChipService)faverChipBlock).code >= faverChipArea.code && faverChipArea.endService >= ((FaverChipService)faverChipBlock).code) continue;
            object = nodeCode.getBytes(nodeCodeArea2.getNodeCodeString());
            ((FaverChipService)faverChipBlock).setInfoBytes((byte[])object, 0, 1, 4);
            ((NodeCodeService)nodeCode).setService(faverChipBlock);
            nodeCode.setParent(nodeCodeArea2);
            nodeCodeArea2.setChild(nodeCode);
            vector2.addElement(nodeCode);
        }
        if (vector2.size() > 0) {
            block1: while (vector2.size() > 0) {
                Vector vector4 = vector3;
                int n4 = vector4.size();
                NodeCode nodeCode = (NodeCode)vector2.elementAt(0);
                for (int i = 0; i < n4; ++i) {
                    object = (NodeCode)vector4.elementAt(i);
                    if (!object.equals(nodeCode)) continue;
                    vector3.remove(object);
                    vector2.remove(nodeCode);
                    continue block1;
                }
            }
        }
        this.henseiArea(nodeCodeArea);
        Object[] objectArray = nodeCodeArea2.getChildren().toArray();
        Arrays.sort(objectArray, new NodeComparator(nodeCodeArea2));
        vector.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        Vector vector5 = nodeCodeArea.getChildren();
        Object[] objectArray2 = vector5.toArray();
        Arrays.sort(objectArray2, new NodeComparator(nodeCodeArea));
        vector5.clear();
        for (n = 0; n < objectArray2.length; ++n) {
            vector5.addElement(objectArray2[n]);
        }
        n = 0;
        object = nodeCodeArea.getChildren();
        Vector vector6 = new Vector();
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof NodeCodeArea) {
                n += ((NodeCodeArea)e).getChildren().size();
            } else if (e instanceof NodeCodeService) {
                Enumeration enumeration2 = ((NodeCodeService)e).getChildren().elements();
                while (enumeration2.hasMoreElements()) {
                    Object e2 = enumeration2.nextElement();
                    if (!(e2 instanceof FaverChipUserData) || vector6.contains(e2)) continue;
                    vector6.addElement(e2);
                }
            }
            ++n;
        }
        faverChipArea.blockNum = n + vector6.size();
        faverChipArea.getDataBytes();
    }

    private void henseiArea(NodeCodeArea nodeCodeArea) {
        Object object;
        Object object2;
        if (nodeCodeArea.getNodeCodeString().equals("00000000")) {
            return;
        }
        FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector;
            byte[] byArray;
            FaverChipArea faverChipArea2;
            NodeCodeArea nodeCodeArea2;
            FaverChipBlock faverChipBlock;
            object2 = enumeration.nextElement();
            if (object2.equals(nodeCodeArea)) continue;
            if (object2 instanceof NodeCodeService) {
                object = (NodeCodeService)object2;
                if (((NodeCode)object).getNodeCodeString().equals("00000020") || ((NodeCode)object).getAreaType() != nodeCodeArea.getAreaType() || nodeCodeArea.getAreaType() == 3 && this.getSystemNo((NodeCode)object) != this.getSystemNo(nodeCodeArea)) continue;
                faverChipBlock = ((NodeCodeService)object).getServiceBlock();
                if (faverChipArea.code >= ((FaverChipService)faverChipBlock).code || ((FaverChipService)faverChipBlock).code >= faverChipArea.endService) continue;
                nodeCodeArea2 = (NodeCodeArea)((NodeCode)object).getParent();
                faverChipArea2 = nodeCodeArea2.getAreaBlock();
                if (faverChipArea.code < faverChipArea2.code && faverChipArea2.code < faverChipArea.endService) continue;
                byArray = nodeCodeArea.getBytes(nodeCodeArea.getNodeCodeString());
                vector = nodeCodeArea2.getChildren();
                vector.remove(object);
                ((FaverChipService)faverChipBlock).setInfoBytes(byArray, 0, 1, 4);
                ((NodeCodeService)object).setService(faverChipBlock);
                ((NodeCode)object).setParent(nodeCodeArea);
                nodeCodeArea.setChild(object);
                continue;
            }
            if (!(object2 instanceof NodeCodeArea) || ((NodeCode)(object = (NodeCodeArea)object2)).getAreaType() != nodeCodeArea.getAreaType() || nodeCodeArea.getAreaType() == 3 && this.getSystemNo((NodeCode)object) != this.getSystemNo(nodeCodeArea)) continue;
            faverChipBlock = ((NodeCodeArea)object).getAreaBlock();
            if (faverChipArea.code >= ((FaverChipArea)faverChipBlock).code || ((FaverChipArea)faverChipBlock).code >= faverChipArea.endService || !nodeCodeArea.canCreateArea()) continue;
            nodeCodeArea2 = (NodeCodeArea)((NodeCode)object).getParent();
            faverChipArea2 = nodeCodeArea2.getAreaBlock();
            if (faverChipArea.code < faverChipArea2.code && faverChipArea2.code < faverChipArea.endService) continue;
            byArray = nodeCodeArea.getBytes(nodeCodeArea.getNodeCodeString());
            vector = nodeCodeArea2.getChildren();
            vector.remove(object);
            ((FaverChipArea)faverChipBlock).setInfoBytes(byArray, 0, 1, 4);
            ((NodeCodeArea)object).setArea(faverChipBlock);
            ((NodeCode)object).setParent(nodeCodeArea);
            nodeCodeArea.setChild(object);
        }
        object2 = nodeCodeArea.getChildren();
        object = ((Vector)object2).toArray();
        Arrays.sort(object, new NodeComparator(nodeCodeArea));
        ((Vector)object2).clear();
        for (int i = 0; i < ((Object)object).length; ++i) {
            ((Vector)object2).addElement(object[i]);
        }
    }

    private void henseiService(NodeCodeService nodeCodeService) {
        Object object;
        NodeCodeArea nodeCodeArea;
        Object object2;
        NodeCode nodeCode = null;
        int n = Integer.MAX_VALUE;
        if (nodeCodeService.getAreaType() == 2) {
            return;
        }
        if (nodeCodeService.getNodeCodeString().equals("00000000")) {
            return;
        }
        NodeCodeArea nodeCodeArea2 = (NodeCodeArea)nodeCodeService.getParent();
        if (!nodeCodeArea2.getChildren().contains(nodeCodeService)) {
            return;
        }
        if (nodeCodeService.isPINService()) {
            return;
        }
        FaverChipService faverChipService = nodeCodeService.getServiceBlock();
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            if (!(object2 instanceof NodeCodeArea) || (nodeCodeArea = (NodeCodeArea)object2).getAreaType() != nodeCodeService.getAreaType() || nodeCodeService.getAreaType() == 3 && this.getSystemNo(nodeCodeArea) != this.getSystemNo(nodeCodeService)) continue;
            object = nodeCodeArea.getAreaBlock();
            if (((FaverChipArea)object).code >= faverChipService.code || faverChipService.code >= ((FaverChipArea)object).endService || (long)n <= ((FaverChipArea)object).endService - ((FaverChipArea)object).code) continue;
            nodeCode = nodeCodeArea;
            n = (int)(((FaverChipArea)object).endService - ((FaverChipArea)object).code);
        }
        if (nodeCode != null) {
            object2 = nodeCode.getBytes(nodeCode.getNodeCodeString());
            nodeCodeArea = (NodeCodeArea)nodeCodeService.getParent();
            object = (NodeCodeService)nodeCodeService.getPinNode();
            Vector vector = nodeCodeArea.getChildren();
            vector.remove(nodeCodeService);
            vector.remove(object);
            faverChipService.setInfoBytes((byte[])object2, 0, 1, 4);
            FaverChipService faverChipService2 = ((NodeCodeService)object).getServiceBlock();
            faverChipService2.setInfoBytes((byte[])object2, 0, 1, 4);
            nodeCodeService.setParent(nodeCode);
            ((NodeCode)object).setParent(nodeCode);
            nodeCode.setChild(nodeCodeService);
            nodeCode.setChild(object);
            Vector vector2 = nodeCode.getChildren();
            Object[] objectArray = vector2.toArray();
            Arrays.sort(objectArray, new NodeComparator((NodeCodeArea)nodeCode));
            vector2.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                vector2.addElement(objectArray[i]);
            }
        }
    }

    private NodeCode makeNewNode(NodeCode nodeCode, int n) throws FaverChipNodeException {
        Object object;
        Object object2;
        NodeCode nodeCode2 = n == 0 ? new NodeCodeArea(nodeCode.getAreaType()) : new NodeCodeService(nodeCode.getAreaType());
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[6];
        int n2 = 0;
        if (nodeCode instanceof NodeCodeArea) {
            if (nodeCode.getNodeCodeString().equals("00000000")) {
                object2 = ((NodeCodeArea)nodeCode).getAreaBlock();
                n2 = ((FaverChipArea)object2).blockNum - this.getUseBlock(nodeCode);
            } else {
                object2 = null;
                object2 = nodeCode.getAreaType() == 3 ? (NodeCodeArea)this.hash.get("D_" + this.getSystemNo(nodeCode) + "_00000000") : (NodeCodeArea)this.hash.get("C_00000000");
                object = ((NodeCodeArea)object2).getAreaBlock();
                n2 = ((FaverChipArea)object).blockNum - this.getUseBlock((NodeCode)object2);
            }
        }
        object2 = "";
        if (n == 1) {
            if (this.getUnuseBlockNum() < 4 || n2 < 4) {
                object = Resource.getString("FC_ERR_NO_FREE_BLOCK");
                throw new FaverChipNodeException((String)object);
            }
            object = new FaverChipService(this.releaseUnuseBlock((NodeCodeArea)nodeCode), byArray, byArray2);
            String string = nodeCode.getNodeCodeString();
            byte[] byArray3 = nodeCode.getBytes(string);
            ((FaverChipService)object).setInfoBytes(byArray3, 0, 1, 4);
            ((NodeCodeService)nodeCode2).setService((FaverChipBlock)object);
        } else {
            if (this.getUnuseBlockNum() < 3 || n2 < 3) {
                object = Resource.getString("FC_ERR_NO_FREE_BLOCK");
                throw new FaverChipNodeException((String)object);
            }
            byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0};
            byArray2 = new byte[]{4, 0, 0, 0, 0, 0};
            object = new FaverChipArea(this.releaseUnuseBlock((NodeCodeArea)nodeCode), byArray, byArray2);
            String string = nodeCode.getNodeCodeString();
            byte[] byArray4 = nodeCode.getBytes(string);
            ((FaverChipArea)object).setInfoBytes(byArray4, 0, 1, 4);
            object2 = this.getCodeString(((FaverChipArea)object).code, 8);
            ((NodeCodeArea)nodeCode2).setArea((FaverChipBlock)object);
        }
        this.hash.put("XXXX", nodeCode2);
        nodeCode2.setParent(nodeCode);
        nodeCode.setChild(nodeCode2);
        return nodeCode2;
    }

    private NodeCode makeNewNodeSystem(NodeCode nodeCode) throws FaverChipNodeException {
        NodeCodeSystem nodeCodeSystem = new NodeCodeSystem(3);
        byte[] byArray = new byte[16];
        byte[] byArray2 = null;
        byte by = this.getSystemNo();
        if (by == 255) {
            String string = Resource.getString("FC_ERR_NO_MORE_DIVIDE_SYSTEM");
            throw new FaverChipNodeException(string);
        }
        byArray2 = new byte[]{3, by, 0, 0, 0, 0};
        String string = "";
        if (this.getUnuseBlockNum() < 6) {
            String string2 = Resource.getString("FC_ERR_NO_FREE_BLOCK");
            throw new FaverChipNodeException(string2);
        }
        FaverChipSystem faverChipSystem = new FaverChipSystem(this.releaseUnuseBlock(), byArray, byArray2);
        nodeCodeSystem.setSystem(faverChipSystem);
        this.hash.put("D_" + Resource.getString("FCH_NODE_DIV_SYSTEM"), nodeCodeSystem);
        nodeCodeSystem.setParent(nodeCode);
        nodeCode.setChild(nodeCodeSystem);
        return nodeCodeSystem;
    }

    private int getUnuseBlockNum() {
        int n = 0;
        NodeCode nodeCode = (NodeCode)this.hash.get("C_00000000");
        Vector vector = nodeCode.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof FaverChipUnuse)) continue;
            ++n;
        }
        return n;
    }

    private int releaseUnuseBlock() throws FaverChipNodeException {
        Object object;
        int n = -1;
        NodeCode nodeCode = (NodeCode)this.hash.get("C_00000000");
        Vector vector = nodeCode.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.elementAt(i);
            if (!(object instanceof FaverChipUnuse)) continue;
            FaverChipUnuse faverChipUnuse = (FaverChipUnuse)object;
            vector.remove(object);
            n = faverChipUnuse.position;
            break;
        }
        if (n == -1) {
            String string = Resource.getString("FC_ERR_NO_FREE_BLOCK");
            throw new FaverChipNodeException(string);
        }
        NodeCodeArea nodeCodeArea = (NodeCodeArea)this.hash.get("C_00000000");
        object = nodeCodeArea.getUnusedBlockNum();
        int n2 = Integer.parseInt(object, 16);
        object = Integer.toHexString(--n2);
        nodeCodeArea.setUnusedBlockNum(this.addZero((String)object, 4));
        return n;
    }

    private int releaseUnuseBlock(NodeCodeArea nodeCodeArea) throws FaverChipNodeException {
        Object object;
        int n = -1;
        NodeCode nodeCode = (NodeCode)this.hash.get("C_00000000");
        Vector vector = nodeCode.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.elementAt(i);
            if (!(object instanceof FaverChipUnuse)) continue;
            FaverChipUnuse faverChipUnuse = (FaverChipUnuse)object;
            vector.remove(object);
            n = faverChipUnuse.position;
            break;
        }
        if (n == -1) {
            String string = Resource.getString("FC_ERR_NO_FREE_BLOCK");
            throw new FaverChipNodeException(string);
        }
        NodeCodeArea nodeCodeArea2 = null;
        nodeCodeArea2 = nodeCodeArea.getAreaType() == 3 ? (NodeCodeArea)this.hash.get("D_" + this.getSystemNo(nodeCodeArea) + "_00000000") : (NodeCodeArea)this.hash.get("C_00000000");
        object = nodeCodeArea2.getUnusedBlockNum();
        int n2 = Integer.parseInt(object, 16);
        object = Integer.toHexString(--n2);
        nodeCodeArea2.setUnusedBlockNum(this.addZero((String)object, 4));
        return n;
    }

    public void changeUserData(NodeCodeService nodeCodeService, String[] stringArray) throws FaverChipNodeException {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        byte by = 0;
        try {
            l = Long.parseLong(nodeCodeService.getNodeCodeString(), 16) & 0x1FL;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (8L <= l && l <= 11L) {
            by = 1;
        } else if (12L <= l && l <= 15L) {
            by = 2;
        } else if (16L <= l && l <= 23L) {
            by = 3;
        }
        try {
            n = Integer.parseInt(nodeCodeService.getDataNum(), 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector vector = nodeCodeService.getChildren();
        n2 = vector == null ? 0 : vector.size();
        if (n != n2) {
            if (n < n2) {
                int n3 = n2 - n;
                for (int i = n2 - 1; i > n - 1; --i) {
                    FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(i);
                    this.overlap(nodeCodeService, faverChipUserData, 1);
                    this.registArea000(faverChipUserData.position, (NodeCode)nodeCodeService.getParent());
                    vector.remove(faverChipUserData);
                }
            } else if (n > n2) {
                FaverChipBlock faverChipBlock;
                Object object;
                int n4 = n - n2;
                int n5 = 0;
                NodeCode nodeCode = (NodeCode)nodeCodeService.getParent();
                if (nodeCode instanceof NodeCodeArea) {
                    if (nodeCode.getNodeCodeString().equals("00000000")) {
                        object = ((NodeCodeArea)nodeCode).getAreaBlock();
                        n5 = ((FaverChipArea)object).blockNum - this.getUseBlock(nodeCode);
                    } else {
                        object = null;
                        object = nodeCode.getAreaType() == 3 ? (NodeCodeArea)this.hash.get("D_" + this.getSystemNo(nodeCode) + "_00000000") : (NodeCodeArea)this.hash.get("C_00000000");
                        faverChipBlock = ((NodeCodeArea)object).getAreaBlock();
                        n5 = ((FaverChipArea)faverChipBlock).blockNum - this.getUseBlock((NodeCode)object);
                    }
                }
                if (this.getUnuseBlockNum() < n4 || n5 < n4) {
                    object = Resource.getString("FC_ERR_NO_FREE_BLOCK");
                    throw new FaverChipNodeException((String)object);
                }
                for (int i = 0; i < n4; ++i) {
                    faverChipBlock = nodeCodeService.getServiceBlock();
                    byte[] byArray = new byte[]{6, 0, 0, 0, 0, by};
                    FaverChipUserData faverChipUserData = new FaverChipUserData(this.releaseUnuseBlock((NodeCodeArea)nodeCodeService.getParent()), new byte[16], byArray);
                    byte[] byArray2 = ((FaverChipService)faverChipBlock).getDataBytes();
                    byArray2[3] = (byte)(byArray2[3] & 0xC0);
                    faverChipUserData.setInfoBytes(byArray2, 0, 1, 4);
                    nodeCodeService.setChild(faverChipUserData);
                    this.overlap(nodeCodeService, faverChipUserData, 0);
                }
            }
        }
        nodeCodeService.setChildData(stringArray);
    }

    public void removeNode(NodeCode nodeCode, String string) throws FaverChipNodeException {
        if (nodeCode instanceof NodeCodeService) {
            this.removeService((NodeCodeService)nodeCode, string);
        }
    }

    private void removeService(NodeCodeService nodeCodeService, String string) throws FaverChipNodeException {
        boolean bl = false;
        if (string == null || string.equals("00000000")) {
            bl = true;
        }
        if (this.overlapCheck(nodeCodeService)) {
            long l = -1L;
            try {
                l = Long.parseLong(nodeCodeService.getNodeCodeString(), 16) & 0xFFFFFFC0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Enumeration enumeration = this.hash.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof NodeCodeService)) continue;
                NodeCodeService nodeCodeService2 = (NodeCodeService)v;
                long l2 = -1L;
                try {
                    l2 = Long.parseLong(nodeCodeService2.getNodeCodeString(), 16) & 0xFFFFFFC0L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nodeCodeService.equals(nodeCodeService2) || nodeCodeService2.isPINService() || l != l2 || nodeCodeService2.getAreaType() != 1 && (nodeCodeService2.getAreaType() != 3 || this.getSystemNo(nodeCodeService2) != this.getSystemNo(nodeCodeService)) || this.getAccessType(nodeCodeService) != this.getAccessType(nodeCodeService2)) continue;
                if (!bl && this.overlapCheck(string)) {
                    Vector vector = nodeCodeService.getChildren();
                    vector.clear();
                    Vector vector2 = nodeCodeService2.getChildren();
                    vector.addAll(vector2);
                    nodeCodeService.setDataNum(this.addZero(Integer.toHexString(vector2.size()).toUpperCase(), 4));
                } else {
                    Vector vector = nodeCodeService.getChildren();
                    for (int i = 0; i < vector.size(); ++i) {
                        FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(i);
                        this.registArea000(faverChipUserData.position, (NodeCode)nodeCodeService.getParent());
                    }
                    vector.clear();
                    Vector vector3 = nodeCodeService2.getChildren();
                    vector.addAll(vector3);
                    nodeCodeService.setDataNum(this.addZero(Integer.toHexString(vector3.size()).toUpperCase(), 4));
                }
                break;
            }
        } else {
            int n = 0;
            long l = 0L;
            byte by = 0;
            try {
                l = Long.parseLong(nodeCodeService.getNodeCodeString(), 16) & 0x1FL;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (8L <= l && l <= 11L) {
                by = 1;
            } else if (12L <= l && l <= 15L) {
                by = 2;
            } else if (16L <= l && l <= 23L) {
                by = 3;
            }
            FaverChipService faverChipService = nodeCodeService.getServiceBlock();
            byte[] byArray = faverChipService.getDataBytes();
            byArray[3] = (byte)(byArray[3] & 0xC0);
            byte[] byArray2 = new byte[]{6, 0, 0, 0, 0, by};
            try {
                n = Integer.parseInt(nodeCodeService.getDataNum(), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Vector vector = nodeCodeService.getChildren();
            Vector<Object> vector4 = new Vector<Object>();
            for (int i = 0; i < vector.size(); ++i) {
                FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(i);
                if (!bl && this.overlapCheck(string)) {
                    Object object;
                    if (this.getUnuseBlockNum() < n) {
                        object = Resource.getString("FC_ERR_NO_FREE_BLOCK");
                        throw new FaverChipNodeException((String)object);
                    }
                    object = new FaverChipUserData(this.releaseUnuseBlock((NodeCodeArea)nodeCodeService.getParent()), new byte[16], byArray2);
                    ((FaverChipUserData)object).setInfoBytes(byArray, 0, 1, 4);
                    ((FaverChipBlock)object).setDataBytes(((FaverChipUserData)object).getDataBytes(), 0, 0, 16);
                    vector4.addElement(object);
                    continue;
                }
                faverChipUserData.setInfoBytes(byArray, 0, 1, 4);
            }
            if (!bl && this.overlapCheck(string)) {
                vector.clear();
                vector.addAll(vector4);
            }
        }
    }

    private void overlap(NodeCodeService nodeCodeService, FaverChipUserData faverChipUserData, int n) {
        NodeCodeArea nodeCodeArea = (NodeCodeArea)nodeCodeService.getParent();
        Vector vector = nodeCodeArea.getChildren();
        long l = -1L;
        try {
            l = Long.parseLong(nodeCodeService.getNodeCodeString(), 16) & 0xFFFFFFC0L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Object e = enumeration.nextElement();
            if (!(e instanceof NodeCodeService)) continue;
            NodeCodeService nodeCodeService2 = (NodeCodeService)e;
            long l2 = -1L;
            try {
                l2 = Long.parseLong(nodeCodeService2.getNodeCodeString(), 16) & 0xFFFFFFC0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nodeCodeService.equals(nodeCodeService2) || nodeCodeService2.isPINService() || l != l2 || this.getAccessType(nodeCodeService) != this.getAccessType(nodeCodeService2)) continue;
            if (n == 0) {
                vector2 = nodeCodeService2.getChildren();
                if (!vector2.contains(faverChipUserData)) {
                    vector2.addElement(faverChipUserData);
                }
                nodeCodeService2.setDataNum(this.addZero(Integer.toHexString(vector2.size()).toUpperCase(), 4));
                continue;
            }
            vector2 = nodeCodeService2.getChildren();
            if (vector2.contains(faverChipUserData)) {
                vector2.remove(faverChipUserData);
            }
            nodeCodeService2.setDataNum(this.addZero(Integer.toHexString(vector2.size()).toUpperCase(), 4));
        }
    }

    private boolean overlapCheck(NodeCodeService nodeCodeService) {
        NodeCodeArea nodeCodeArea = (NodeCodeArea)nodeCodeService.getParent();
        long l = -1L;
        try {
            l = Long.parseLong(nodeCodeService.getNodeCodeString(), 16) & 0xFFFFFFC0L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof NodeCodeService) || ((NodeCodeService)v).getAreaType() != nodeCodeService.getAreaType()) continue;
            NodeCodeService nodeCodeService2 = (NodeCodeService)v;
            long l2 = -1L;
            try {
                l2 = Long.parseLong(nodeCodeService2.getNodeCodeString(), 16) & 0xFFFFFFC0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nodeCodeService.equals(nodeCodeService2) || nodeCodeService2.isPINService() || l != l2 || this.getAccessType(nodeCodeService) != this.getAccessType(nodeCodeService2)) continue;
            return true;
        }
        return false;
    }

    private boolean overlapCheck(String string) {
        long l = -1L;
        int n = 0;
        long l2 = 0L;
        if (string == null) {
            return false;
        }
        try {
            l = Long.parseLong(string, 16) & 0xFFFFFFC0L;
            l2 = Long.parseLong(string, 16) & 0x1FL;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (8L <= l2 && l2 <= 11L) {
            n = 1;
        } else if (12L <= l2 && l2 <= 15L) {
            n = 2;
        } else if (16L <= l2 && l2 <= 23L) {
            n = 3;
        }
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            NodeCodeService nodeCodeService;
            Object v = enumeration.nextElement();
            if (!(v instanceof NodeCodeService) || (nodeCodeService = (NodeCodeService)v).getAreaType() != 1 && (nodeCodeService.getAreaType() != 3 || this.getSystemNo(nodeCodeService) != this.getSystemNo((NodeCode)v))) continue;
            long l3 = -1L;
            try {
                l3 = Long.parseLong(nodeCodeService.getNodeCodeString(), 16) & 0xFFFFFFC0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nodeCodeService.isPINService() || l != l3 || n != this.getAccessType(nodeCodeService)) continue;
            return true;
        }
        return false;
    }

    private int getAccessType(NodeCodeService nodeCodeService) {
        int n = 0;
        int n2 = nodeCodeService.getAccessAtrribute();
        switch (n2) {
            case 1: 
            case 2: {
                n = 1;
                break;
            }
            case 3: 
            case 4: {
                n = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n = 3;
                break;
            }
        }
        return n;
    }

    protected String addZero(String string, int n) {
        String string2 = string;
        string2 = string == null ? "" : string;
        for (int i = n - string.length(); i > 0; --i) {
            string2 = "0" + string2;
        }
        return string2;
    }

    public void changePINNode(NodeCode nodeCode) {
        int n = nodeCode.getNodeCodeType();
        if (n == 3) {
            NodeCodeService nodeCodeService = (NodeCodeService)((NodeCodeArea)nodeCode).getPinNode();
            String string = nodeCodeService.getNodeCodeString();
            String string2 = ((NodeCodeArea)nodeCode).getNodeCodeString();
            try {
                long l = Long.parseLong(string2, 16) & 0xFFFFFFFFL;
                string2 = Long.toHexString((l |= 0x20L) & 0xFFFFFFFFL);
                string2 = this.addZero(string2.toUpperCase(), 8);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nodeCodeService.setNodeCode(string2);
            Vector vector = nodeCodeService.getChildren();
            if (vector.size() > 0) {
                FaverChipService faverChipService = nodeCodeService.getServiceBlock();
                FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(0);
                faverChipUserData.setInfoBytes(faverChipService.getDataBytes(), 0, 1, 4);
                FaverChipArea faverChipArea = ((NodeCodeArea)nodeCode).getAreaBlock();
                byte[] byArray = faverChipArea.getDataBytes();
                faverChipService.setInfoBytes(byArray, 0, 1, 4);
            }
            if (nodeCodeService.getAreaType() == 3) {
                this.hash.remove("D_" + this.getSystemNo(nodeCodeService) + "_" + string);
                this.hash.put("D_" + this.getSystemNo(nodeCodeService) + "_" + nodeCodeService.getNodeCodeString(), nodeCodeService);
            } else {
                this.hash.remove("C_" + string);
                this.hash.put("C_" + nodeCodeService.getNodeCodeString(), nodeCodeService);
            }
        } else if (n == 4) {
            NodeCodeService nodeCodeService = (NodeCodeService)((NodeCodeService)nodeCode).getPinNode();
            String string = nodeCodeService.getNodeCodeString();
            String string3 = ((NodeCodeService)nodeCode).getNodeCodeString();
            try {
                long l = Long.parseLong(string3, 16) & 0xFFFFFFFFL;
                string3 = Long.toHexString((l |= 0x20L) & 0xFFFFFFFFL);
                string3 = this.addZero(string3.toUpperCase(), 8);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nodeCodeService.setNodeCode(string3);
            Vector vector = nodeCodeService.getChildren();
            if (vector.size() > 0) {
                FaverChipService faverChipService = nodeCodeService.getServiceBlock();
                FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(0);
                faverChipUserData.setInfoBytes(faverChipService.getDataBytes(), 0, 1, 4);
            }
            if (nodeCodeService.getAreaType() == 3) {
                if (this.hash.remove("D_" + this.getSystemNo(nodeCodeService) + "_" + string) == null) {
                    return;
                }
                this.hash.put("D_" + this.getSystemNo(nodeCodeService) + "_" + nodeCodeService.getNodeCodeString(), nodeCodeService);
            } else {
                if (this.hash.remove("C_" + string) == null) {
                    return;
                }
                this.hash.put("C_" + nodeCodeService.getNodeCodeString(), nodeCodeService);
            }
        } else {
            return;
        }
    }

    public void makeNewPINNode(NodeCode nodeCode, int n) throws FaverChipNodeException {
        if (n == 0) {
            this.addPINinArea((NodeCodeArea)nodeCode);
        } else {
            this.addPINinService((NodeCodeService)nodeCode);
        }
        Object v = this.hash.remove("XXXX");
        if (nodeCode.getAreaType() == 3) {
            this.hash.put("D_" + this.getSystemNo(nodeCode) + "_" + nodeCode.getNodeCodeString(), nodeCode);
        } else {
            this.hash.put("C_" + nodeCode.getNodeCodeString(), nodeCode);
        }
    }

    private void addPINinArea(NodeCodeArea nodeCodeArea) throws FaverChipNodeException {
        if (nodeCodeArea.getNodeCodeString().equals("00000000")) {
            return;
        }
        if (this.getUnuseBlockNum() < 2) {
            String string = Resource.getString("FC_ERR_NO_FREE_BLOCK");
            throw new FaverChipNodeException(string);
        }
        FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
        String string = nodeCodeArea.getNodeCodeString();
        byte[] byArray = nodeCodeArea.getBytes(string);
        long l = faverChipArea.code | 0x20L;
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};
        byte[] byArray3 = new byte[]{5, 0, 0, 0, 0, 0};
        FaverChipService faverChipService = new FaverChipService(0, byArray2, byArray3);
        faverChipService.setCode(l);
        faverChipService.setInfoBytes(byArray, 0, 1, 4);
        faverChipService.position = this.releaseUnuseBlock(nodeCodeArea);
        byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, -4, 0, 0, 0};
        byArray3 = new byte[]{6, 0, 0, 0, 0, 0};
        FaverChipUserData faverChipUserData = new FaverChipUserData(0, byArray2, byArray3);
        faverChipUserData.setInfoBytes(faverChipService.getDataBytes(), 0, 1, 4);
        faverChipUserData.position = this.releaseUnuseBlock(nodeCodeArea);
        NodeCodeService nodeCodeService = new NodeCodeService(nodeCodeArea.getAreaType());
        nodeCodeService.setService(faverChipService);
        nodeCodeService.setPinNode(null);
        nodeCodeService.setParent(nodeCodeArea);
        nodeCodeService.setChild(faverChipUserData);
        nodeCodeArea.setPinNode(nodeCodeService);
        nodeCodeArea.setChild(nodeCodeService);
        if (nodeCodeService.getAreaType() == 3) {
            this.hash.put("D_" + this.getSystemNo(nodeCodeService) + "_" + nodeCodeService.getNodeCodeString(), nodeCodeService);
        } else {
            this.hash.put("C_" + nodeCodeService.getNodeCodeString(), nodeCodeService);
        }
    }

    private void addPINinService(NodeCodeService nodeCodeService) throws FaverChipNodeException {
        if (this.getUnuseBlockNum() < 2) {
            String string = Resource.getString("FC_ERR_NO_FREE_BLOCK");
            throw new FaverChipNodeException(string);
        }
        FaverChipService faverChipService = nodeCodeService.getServiceBlock();
        String string = nodeCodeService.getNodeCodeString();
        byte[] byArray = nodeCodeService.getBytes(string);
        long l = faverChipService.code | 0x20L;
        NodeCodeArea nodeCodeArea = (NodeCodeArea)nodeCodeService.getParent();
        String string2 = nodeCodeArea.getNodeCodeString();
        byte[] byArray2 = nodeCodeArea.getBytes(string2);
        byte[] byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};
        byte[] byArray4 = new byte[]{5, 0, 0, 0, 0, 0};
        FaverChipService faverChipService2 = new FaverChipService(this.releaseUnuseBlock(nodeCodeArea), byArray3, byArray4);
        faverChipService2.setCode(l);
        faverChipService2.setInfoBytes(byArray2, 0, 1, 4);
        byArray3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, -4, 0, 0, 0};
        byArray4 = new byte[]{6, 0, 0, 0, 0, 0};
        FaverChipUserData faverChipUserData = new FaverChipUserData(this.releaseUnuseBlock(nodeCodeArea), byArray3, byArray4);
        faverChipUserData.setInfoBytes(faverChipService2.getDataBytes(), 0, 1, 4);
        NodeCodeService nodeCodeService2 = new NodeCodeService(nodeCodeService.getAreaType());
        nodeCodeService2.setService(faverChipService2);
        nodeCodeService2.setPinNode(null);
        nodeCodeService2.setParent(nodeCodeArea);
        nodeCodeService2.setChild(faverChipUserData);
        nodeCodeService.setPinNode(nodeCodeService2);
        nodeCodeArea.setChild(nodeCodeService2);
        if (nodeCodeService2.getAreaType() == 3) {
            this.hash.put("D_" + this.getSystemNo(nodeCodeService2) + "_" + nodeCodeService2.getNodeCodeString(), nodeCodeService2);
        } else {
            this.hash.put("C_" + nodeCodeService2.getNodeCodeString(), nodeCodeService2);
        }
    }

    NodeCodeManager() {
        this.hash.put(this.ncCard.getNodeCodeString(), this.ncCard);
    }

    void makeNodeCode(Vector vector, int n) {
        Vector<FaverChipBlock> vector2 = new Vector<FaverChipBlock>();
        Vector<FaverChipBlock> vector3 = new Vector<FaverChipBlock>();
        this.areaType = n;
        if (n == 2) {
            this.preKey = "F_";
        } else if (n == 1) {
            this.preKey = "C_";
        } else if (n == 3) {
            this.preKey = "D_";
        }
        NodeCodeSystem nodeCodeSystem = new NodeCodeSystem(n);
        this.hash.put(this.preKey + 1, nodeCodeSystem);
        for (int i = 0; i < vector.size(); ++i) {
            FaverChipBlock faverChipBlock = (FaverChipBlock)vector.elementAt(i);
            if (faverChipBlock.division == 4) {
                this.setNodeCodeArea(faverChipBlock, 1);
                continue;
            }
            if (faverChipBlock.division == 5) {
                this.setNodeCodeService(faverChipBlock, 1);
                if ((((FaverChipService)faverChipBlock).code & 0x20L) == 0L) continue;
                vector3.addElement(faverChipBlock);
                continue;
            }
            if (faverChipBlock.division == 6) {
                vector2.addElement(faverChipBlock);
                continue;
            }
            if (faverChipBlock.division == 1 || faverChipBlock.division == 2 || faverChipBlock.division == 3) {
                this.setNodeCodeSystem(faverChipBlock, 1);
                continue;
            }
            if (faverChipBlock.division == 7 || faverChipBlock.division == 8) {
                this.setNodeCodeCard(faverChipBlock);
                continue;
            }
            this.setUnuseNode(faverChipBlock);
        }
        this.setNodeCodeData(vector2, 1);
        this.setPinService(vector3, 1);
        this.hash.remove(this.preKey + 1);
        if (nodeCodeSystem.getAreaType() == 3) {
            this.hash.put(this.preKey + this.getSystemNo(nodeCodeSystem) + "_" + nodeCodeSystem.getNodeCodeString(), nodeCodeSystem);
        } else {
            this.hash.put(this.preKey + nodeCodeSystem.getNodeCodeString(), nodeCodeSystem);
        }
    }

    void makeNodeCodeCommon(Vector vector) {
        Vector<FaverChipBlock> vector2 = new Vector<FaverChipBlock>();
        Vector<FaverChipBlock> vector3 = new Vector<FaverChipBlock>();
        NodeCode nodeCode = null;
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            FaverChipBlock faverChipBlock = (FaverChipBlock)vector.elementAt(i);
            if (faverChipBlock.division == 4) {
                this.setNodeCodeArea(faverChipBlock, n2);
                continue;
            }
            if (faverChipBlock.division == 5) {
                this.setNodeCodeService(faverChipBlock, n2);
                if ((((FaverChipService)faverChipBlock).code & 0x20L) == 0L) continue;
                vector3.addElement(faverChipBlock);
                continue;
            }
            if (faverChipBlock.division == 6) {
                vector2.addElement(faverChipBlock);
                continue;
            }
            if (faverChipBlock.division == 1 || faverChipBlock.division == 2 || faverChipBlock.division == 3) {
                byte[] byArray = faverChipBlock.getInfoBytes();
                n2 = byArray[1];
                if (n != n2) {
                    if (nodeCode != null) {
                        this.setNodeCodeData(vector2, n);
                        this.setPinService(vector3, n);
                        this.hash.remove(this.preKey + n);
                        this.hash.put(this.preKey + nodeCode.getNodeCodeString(), nodeCode);
                        vector2 = new Vector();
                        vector3 = new Vector();
                    }
                    if (n2 == 0) {
                        this.areaType = 1;
                        this.preKey = "C_";
                        nodeCode = new NodeCodeSystem(1);
                    } else {
                        this.areaType = 3;
                        this.preKey = "D_";
                        nodeCode = new NodeCodeSystem(3);
                    }
                    this.hash.put(this.preKey + n2, nodeCode);
                    n = n2;
                }
                this.setNodeCodeSystem(faverChipBlock, n2);
                continue;
            }
            if (faverChipBlock.division == 7 || faverChipBlock.division == 8) {
                this.setNodeCodeCard(faverChipBlock);
                continue;
            }
            this.setUnuseNode(faverChipBlock);
        }
        this.setNodeCodeData(vector2, n2);
        this.setPinService(vector3, n2);
        this.hash.remove(this.preKey + n2);
        this.hash.put(this.preKey + nodeCode.getNodeCodeString(), nodeCode);
    }

    private void setNodeCodeCard(FaverChipBlock faverChipBlock) {
        NodeCodeCard nodeCodeCard = (NodeCodeCard)this.hash.get("card");
        if (nodeCodeCard == null) {
            nodeCodeCard = new NodeCodeCard();
        }
        if (faverChipBlock.division == 7) {
            nodeCodeCard.setContainerId(faverChipBlock);
        } else if (faverChipBlock.division == 8) {
            nodeCodeCard.setContainerIssue(faverChipBlock);
        }
    }

    private void setNodeCodeSystem(FaverChipBlock faverChipBlock, int n) {
        Object object;
        NodeCodeSystem nodeCodeSystem = (NodeCodeSystem)this.hash.get(this.preKey + n);
        if (nodeCodeSystem != null || (nodeCodeSystem = (NodeCodeSystem)this.hash.get(object = this.getCodeString(((FaverChipSystem)faverChipBlock).code, 4))) == null) {
            // empty if block
        }
        if (faverChipBlock.division == 1) {
            nodeCodeSystem.setManufacture(faverChipBlock);
        } else if (faverChipBlock.division == 2) {
            nodeCodeSystem.setIssue(faverChipBlock);
        } else if (faverChipBlock.division == 3) {
            nodeCodeSystem.setSystem(faverChipBlock);
            object = (NodeCode)this.hash.get("card");
            nodeCodeSystem.setParent(object);
            ((NodeCode)object).setChild(nodeCodeSystem);
        }
    }

    private void setNodeCodeArea(FaverChipBlock faverChipBlock, int n) {
        if (faverChipBlock.division == 4) {
            String string = this.getCodeString(((FaverChipArea)faverChipBlock).code, 8);
            NodeCodeArea nodeCodeArea = null;
            nodeCodeArea = this.preKey.equals("D_") ? (NodeCodeArea)this.hash.get(this.preKey + n + "_" + string) : (NodeCodeArea)this.hash.get(this.preKey + string);
            if (nodeCodeArea == null) {
                nodeCodeArea = new NodeCodeArea(this.areaType);
                nodeCodeArea.setArea(faverChipBlock);
                if (nodeCodeArea.getAreaType() == 3) {
                    this.hash.put(this.preKey + n + "_" + string, nodeCodeArea);
                } else {
                    this.hash.put(this.preKey + string, nodeCodeArea);
                }
            } else {
                nodeCodeArea.setArea(faverChipBlock);
            }
            if (((FaverChipArea)faverChipBlock).code == 0L) {
                NodeCodeSystem nodeCodeSystem = null;
                nodeCodeSystem = this.preKey.equals("D_") ? (NodeCodeSystem)this.hash.get(this.preKey + n) : (NodeCodeSystem)this.hash.get(this.preKey + n);
                nodeCodeArea.setParent(nodeCodeSystem);
                nodeCodeSystem.setChild(nodeCodeArea);
            } else {
                String string2 = this.getCodeString(faverChipBlock.parentCode, 8);
                NodeCodeArea nodeCodeArea2 = null;
                nodeCodeArea2 = this.preKey.equals("D_") ? (NodeCodeArea)this.hash.get(this.preKey + n + "_" + string2) : (NodeCodeArea)this.hash.get(this.preKey + string2);
                nodeCodeArea.setParent(nodeCodeArea2);
                nodeCodeArea2.setChild(nodeCodeArea);
            }
        }
    }

    private void setNodeCodeService(FaverChipBlock faverChipBlock, int n) {
        if (faverChipBlock.division == 5) {
            String string = this.getCodeString(((FaverChipService)faverChipBlock).code, 8);
            NodeCodeService nodeCodeService = null;
            nodeCodeService = this.preKey.equals("D_") ? (NodeCodeService)this.hash.get(this.preKey + n + "_" + string) : (NodeCodeService)this.hash.get(this.preKey + string);
            if (nodeCodeService == null) {
                nodeCodeService = new NodeCodeService(this.areaType);
                nodeCodeService.setService(faverChipBlock);
                if (nodeCodeService.getAreaType() == 3) {
                    this.hash.put(this.preKey + n + "_" + string, nodeCodeService);
                } else {
                    this.hash.put(this.preKey + string, nodeCodeService);
                }
            }
            String string2 = this.getCodeString(faverChipBlock.parentCode, 8);
            NodeCode nodeCode = null;
            nodeCode = this.preKey.equals("D_") ? (NodeCode)this.hash.get(this.preKey + n + "_" + string2) : (NodeCode)this.hash.get(this.preKey + string2);
            if (nodeCode == null) {
                nodeCode = new NodeCodeArea(this.areaType);
                if (nodeCode.getAreaType() == 3) {
                    this.hash.put(this.preKey + n + "_" + string2, nodeCode);
                } else {
                    this.hash.put(this.preKey + string2, nodeCode);
                }
            }
            nodeCodeService.setParent(nodeCode);
            nodeCode.setChild(nodeCodeService);
        }
    }

    private void setNodeCodeData(FaverChipBlock faverChipBlock, int n) {
        if (faverChipBlock.division == 6) {
            String string = this.getCodeString(faverChipBlock.parentCode, 8);
            NodeCode nodeCode = null;
            nodeCode = this.preKey.equals("D_") ? (NodeCode)this.hash.get(this.preKey + n + "_" + string) : (NodeCode)this.hash.get(this.preKey + string);
            if (nodeCode == null) {
                nodeCode = new NodeCodeService(this.areaType);
                if (nodeCode.getAreaType() == 3) {
                    this.hash.put(this.preKey + this.getSystemNo(nodeCode) + "_" + string, nodeCode);
                } else {
                    this.hash.put(this.preKey + string, nodeCode);
                }
            }
            nodeCode.setChild(faverChipBlock);
        }
    }

    private void setNodeCodeData(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(i);
            int n2 = faverChipUserData.getAccessMethod();
            if ((faverChipUserData.parentCode & 0x20L) != 0L) {
                String string = this.getCodeString(faverChipUserData.parentCode, 8);
                NodeCode nodeCode = null;
                nodeCode = this.preKey.equals("D_") ? (NodeCode)this.hash.get(this.preKey + n + "_" + string) : (NodeCode)this.hash.get(this.preKey + string);
                if (nodeCode == null) continue;
                nodeCode.setChild(faverChipUserData);
                continue;
            }
            int n3 = 0;
            int n4 = 0;
            if (n2 == 1) {
                n3 = 8;
                n4 = 11;
            } else if (n2 == 2) {
                n3 = 12;
                n4 = 15;
            } else {
                if (n2 != 3) continue;
                n3 = 16;
                n4 = 23;
            }
            for (int j = n3; j <= n4; ++j) {
                int n5 = (int)((faverChipUserData.parentCode | (long)j) & 0xFFFFFFFFL);
                String string = this.getCodeString(n5, 8);
                NodeCode nodeCode = null;
                nodeCode = this.preKey.equals("D_") ? (NodeCode)this.hash.get(this.preKey + n + "_" + string) : (NodeCode)this.hash.get(this.preKey + string);
                if (nodeCode == null) continue;
                nodeCode.setChild(faverChipUserData);
            }
        }
    }

    private void setPinService(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            FaverChipService faverChipService = (FaverChipService)vector.elementAt(i);
            String string = this.getCodeString(faverChipService.code, 8);
            NodeCode nodeCode = null;
            nodeCode = this.preKey.equals("D_") ? (NodeCode)this.hash.get(this.preKey + n + "_" + string) : (NodeCode)this.hash.get(this.preKey + string);
            long l = faverChipService.code & 0xFFFFFFDFL;
            String string2 = this.getCodeString(l, 8);
            NodeCode nodeCode2 = null;
            nodeCode2 = this.preKey.equals("D_") ? (NodeCode)this.hash.get(this.preKey + n + "_" + string2) : (NodeCode)this.hash.get(this.preKey + string2);
            if (nodeCode2.getNodeCodeType() == 3) {
                ((NodeCodeArea)nodeCode2).setPinNode(nodeCode);
                continue;
            }
            ((NodeCodeService)nodeCode2).setPinNode(nodeCode);
        }
    }

    private void setUnuseNode(FaverChipBlock faverChipBlock) {
        if (faverChipBlock.division == 0) {
            String string = "00000000";
            NodeCodeArea nodeCodeArea = (NodeCodeArea)this.hash.get("C_" + string);
            if (nodeCodeArea != null) {
                nodeCodeArea.setChild(faverChipBlock);
            }
        }
    }

    private String getCodeString(long l, int n) {
        int n2;
        String string = null;
        long l2 = 0L;
        int n3 = n / 2;
        for (n2 = 0; n2 < n3; ++n2) {
            l2 |= 255L << 8 * (n3 - 1 - n2);
        }
        try {
            string = Long.toHexString(l & l2);
            string = string.toUpperCase();
        }
        catch (Exception exception) {
            return null;
        }
        for (n2 = n - string.length(); n2 > 0; --n2) {
            string = "0" + string;
        }
        return string;
    }

    public byte[] update(int n) {
        Object object;
        int n2;
        byte[][] byArray = new byte[1024][16];
        byte[][] byArray2 = new byte[1024][6];
        if (n == 0) {
            FaverChipBlock faverChipBlock = this.ncCard.getContainerIdBlock();
            byte[] byArray3 = faverChipBlock.getDataBytes();
            byte[] byArray4 = faverChipBlock.getInfoBytes();
            System.arraycopy(byArray3, 0, byArray[faverChipBlock.position], 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2[faverChipBlock.position], 0, byArray4.length);
            faverChipBlock = this.ncCard.getContainerIssueBlock();
            byArray3 = faverChipBlock.getDataBytes();
            byArray4 = faverChipBlock.getInfoBytes();
            System.arraycopy(byArray3, 0, byArray[faverChipBlock.position], 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2[faverChipBlock.position], 0, byArray4.length);
        }
        Vector vector = this.ncCard.getChildren();
        this.sortBlockPosition(this.ncCard, 2, new Vector(), new Vector());
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (NodeCodeSystem)vector.elementAt(n2);
            this.makeSystemBytes(byArray, byArray2, (NodeCodeSystem)object, n);
        }
        n2 = 22528;
        object = new byte[n2];
        for (int i = 0; i < 1024; ++i) {
            System.arraycopy(byArray[i], 0, object, i * 16, 16);
            System.arraycopy(byArray2[i], 0, object, 16384 + i * 6, 6);
        }
        return object;
    }

    private void makeSystemBytes(byte[][] byArray, byte[][] byArray2, NodeCodeSystem nodeCodeSystem, int n) {
        byte[] byArray3;
        byte[] byArray4;
        FaverChipBlock faverChipBlock;
        if (n == 0) {
            faverChipBlock = nodeCodeSystem.getManufactureBlock();
            byArray4 = faverChipBlock.getDataBytes();
            byArray3 = faverChipBlock.getInfoBytes();
            System.arraycopy(byArray4, 0, byArray[faverChipBlock.position], 0, byArray4.length);
            System.arraycopy(byArray3, 0, byArray2[faverChipBlock.position], 0, byArray3.length);
            faverChipBlock = nodeCodeSystem.getIssueBlock();
            byArray4 = faverChipBlock.getDataBytes();
            byArray3 = faverChipBlock.getInfoBytes();
            System.arraycopy(byArray4, 0, byArray[faverChipBlock.position], 0, byArray4.length);
            System.arraycopy(byArray3, 0, byArray2[faverChipBlock.position], 0, byArray3.length);
        }
        faverChipBlock = nodeCodeSystem.getSystemBlock();
        byArray4 = faverChipBlock.getDataBytes();
        byArray3 = faverChipBlock.getInfoBytes();
        System.arraycopy(byArray4, 0, byArray[faverChipBlock.position], 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray2[faverChipBlock.position], 0, byArray3.length);
        Vector vector = nodeCodeSystem.getChildren();
        if (vector.size() != 1) {
            // empty if block
        }
        NodeCodeArea nodeCodeArea = (NodeCodeArea)vector.elementAt(0);
        faverChipBlock = nodeCodeArea.getAreaBlock();
        byArray4 = faverChipBlock.getDataBytes();
        byArray3 = faverChipBlock.getInfoBytes();
        System.arraycopy(byArray4, 0, byArray[faverChipBlock.position], 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray2[faverChipBlock.position], 0, byArray3.length);
        this.pospos = faverChipBlock.position + 1;
        this.makeAreaBlock(byArray, byArray2, nodeCodeArea, faverChipBlock.position + 1);
    }

    private int sortBlockPosition(NodeCode nodeCode, int n, Vector vector, Vector vector2) {
        Vector vector3 = nodeCode.getChildren();
        Enumeration enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            FaverChipBlock faverChipBlock;
            Object e = enumeration.nextElement();
            if (e instanceof NodeCodeSystem) {
                FaverChipBlock faverChipBlock2;
                if (((NodeCodeSystem)e).getSystemNo() == 1) {
                    for (int i = 0; i < vector.size(); ++i) {
                        faverChipBlock2 = (FaverChipUnuse)vector.elementAt(i);
                        faverChipBlock2.position = n++;
                    }
                    return n;
                }
                faverChipBlock = ((NodeCodeSystem)e).getManufactureBlock();
                faverChipBlock.position = n++;
                faverChipBlock2 = ((NodeCodeSystem)e).getIssueBlock();
                faverChipBlock2.position = n++;
                FaverChipBlock faverChipBlock3 = ((NodeCodeSystem)e).getSystemBlock();
                faverChipBlock3.position = n++;
                n = this.sortBlockPosition((NodeCode)e, n, vector, vector2);
                continue;
            }
            if (e instanceof NodeCodeArea) {
                faverChipBlock = ((NodeCodeArea)e).getAreaBlock();
                faverChipBlock.position = n++;
                n = this.sortBlockPosition((NodeCode)e, n, vector, vector2);
                continue;
            }
            if (e instanceof NodeCodeService) {
                faverChipBlock = ((NodeCodeService)e).getServiceBlock();
                ((FaverChipService)faverChipBlock).position = n++;
                n = this.sortBlockPosition((NodeCode)e, n, vector, vector2);
                continue;
            }
            if (e instanceof FaverChipUserData) {
                if (vector2.contains(e)) continue;
                faverChipBlock = (FaverChipUserData)e;
                ((FaverChipUserData)faverChipBlock).position = n++;
                vector2.addElement(e);
                continue;
            }
            if (!(e instanceof FaverChipUnuse)) continue;
            vector.addElement(e);
        }
        return n;
    }

    private void putUserData(Hashtable hashtable, byte[][] byArray, byte[][] byArray2) {
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                for (int i = 0; i < vector.size(); ++i) {
                    FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(i);
                    byte[] byArray3 = faverChipUserData.getDataBytes();
                    byte[] byArray4 = faverChipUserData.getInfoBytes();
                    System.arraycopy(byArray3, 0, byArray[this.pospos], 0, byArray3.length);
                    System.arraycopy(byArray4, 0, byArray2[this.pospos++], 0, byArray4.length);
                }
            }
            hashtable.clear();
        }
    }

    private void makeAreaBlock(byte[][] byArray, byte[][] byArray2, NodeCodeArea nodeCodeArea, int n) {
        Vector vector = nodeCodeArea.getChildren();
        Hashtable<String, Vector> hashtable = null;
        int n2 = n;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            FaverChipService faverChipService;
            Object object2;
            Object object3;
            byte[] byArray3;
            Object object4;
            NodeCode nodeCode;
            Object e = vector.elementAt(i);
            if (e instanceof FaverChipUnuse) {
                this.putUserData(hashtable, byArray, byArray2);
                continue;
            }
            int n3 = ((NodeCode)e).getNodeCodeType();
            if (n3 == 3) {
                this.putUserData(hashtable, byArray, byArray2);
                nodeCode = (NodeCodeArea)e;
                object4 = ((NodeCodeArea)nodeCode).getAreaBlock();
                byArray3 = ((FaverChipBlock)object4).getDataBytes();
                object3 = ((FaverChipBlock)object4).getInfoBytes();
                System.arraycopy(byArray3, 0, byArray[this.pospos], 0, byArray3.length);
                System.arraycopy(object3, 0, byArray2[this.pospos++], 0, ((Object)object3).length);
                this.makeAreaBlock(byArray, byArray2, (NodeCodeArea)e, this.pospos);
                continue;
            }
            if (n3 != 4) continue;
            nodeCode = (NodeCodeService)e;
            if (((NodeCodeService)nodeCode).isPINService()) {
                if (!nodeCodeArea.getPinNode().equals(nodeCode)) continue;
                object2 = nodeCode;
                faverChipService = ((NodeCodeService)object2).getServiceBlock();
                object4 = ((FaverChipBlock)faverChipService).getDataBytes();
                byArray3 = ((FaverChipBlock)faverChipService).getInfoBytes();
                System.arraycopy(object4, 0, byArray[this.pospos], 0, ((Object)object4).length);
                System.arraycopy(byArray3, 0, byArray2[this.pospos++], 0, byArray3.length);
                object = ((NodeCode)object2).getChildren();
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    FaverChipUserData faverChipUserData = (FaverChipUserData)((Vector)object).elementAt(j);
                    object4 = faverChipUserData.getDataBytes();
                    byArray3 = faverChipUserData.getInfoBytes();
                    System.arraycopy(object4, 0, byArray[this.pospos], 0, ((Object)object4).length);
                    System.arraycopy(byArray3, 0, byArray2[this.pospos++], 0, byArray3.length);
                }
                continue;
            }
            object3 = ((NodeCodeService)nodeCode).getServiceBlock();
            object2 = "";
            try {
                object2 = Integer.toHexString((int)(((FaverChipService)object3).code & 0xFFFFFFC0L));
                object2 = this.addZero(((String)object2).toUpperCase(), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (hashtable == null) {
                hashtable = new Hashtable<String, Vector>();
                hashtable.put((String)object2 + this.getAccessType((NodeCodeService)nodeCode), nodeCode.getChildren());
            } else {
                faverChipService = hashtable.get((String)object2 + this.getAccessType((NodeCodeService)nodeCode));
                if (faverChipService == null) {
                    object = hashtable.elements();
                    while (object.hasMoreElements()) {
                        Vector vector2 = (Vector)object.nextElement();
                        for (int j = 0; j < vector2.size(); ++j) {
                            FaverChipUserData faverChipUserData = (FaverChipUserData)vector2.elementAt(j);
                            object4 = faverChipUserData.getDataBytes();
                            byArray3 = faverChipUserData.getInfoBytes();
                            System.arraycopy(object4, 0, byArray[this.pospos], 0, ((Object)object4).length);
                            System.arraycopy(byArray3, 0, byArray2[this.pospos++], 0, byArray3.length);
                        }
                    }
                    hashtable.clear();
                    hashtable.put((String)object2 + this.getAccessType((NodeCodeService)nodeCode), nodeCode.getChildren());
                }
            }
            object4 = ((FaverChipBlock)object3).getDataBytes();
            byArray3 = ((FaverChipBlock)object3).getInfoBytes();
            System.arraycopy(object4, 0, byArray[this.pospos], 0, ((Object)object4).length);
            System.arraycopy(byArray3, 0, byArray2[this.pospos++], 0, byArray3.length);
            object2 = (NodeCodeService)((NodeCodeService)nodeCode).getPinNode();
            if (object2 == null) continue;
            faverChipService = ((NodeCodeService)object2).getServiceBlock();
            object4 = ((FaverChipBlock)faverChipService).getDataBytes();
            byArray3 = ((FaverChipBlock)faverChipService).getInfoBytes();
            System.arraycopy(object4, 0, byArray[this.pospos], 0, ((Object)object4).length);
            System.arraycopy(byArray3, 0, byArray2[this.pospos++], 0, byArray3.length);
            object = ((NodeCode)object2).getChildren();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                FaverChipUserData faverChipUserData = (FaverChipUserData)((Vector)object).elementAt(j);
                object4 = faverChipUserData.getDataBytes();
                byArray3 = faverChipUserData.getInfoBytes();
                System.arraycopy(object4, 0, byArray[this.pospos], 0, ((Object)object4).length);
                System.arraycopy(byArray3, 0, byArray2[this.pospos++], 0, byArray3.length);
            }
        }
        this.putUserData(hashtable, byArray, byArray2);
    }

    public void deleteNodeCode(NodeCode nodeCode) {
        if (nodeCode == null) {
            return;
        }
        if (nodeCode instanceof NodeCodeArea) {
            this.deleteArea((NodeCodeArea)nodeCode);
        } else if (nodeCode instanceof NodeCodeService) {
            this.deleteService((NodeCodeService)nodeCode);
        } else if (nodeCode instanceof NodeCodeSystem) {
            this.deleteSystem((NodeCodeSystem)nodeCode);
        }
    }

    private void deleteSystem(NodeCodeSystem nodeCodeSystem) {
        Object object;
        if (this.getSystemNo(nodeCodeSystem) == 0 || this.getSystemNo(nodeCodeSystem) == 1) {
            return;
        }
        Vector vector = this.ncCard.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.elementAt(i);
            if (!object.equals(nodeCodeSystem)) continue;
            vector.remove(nodeCodeSystem);
        }
        Vector vector2 = nodeCodeSystem.getChildren();
        object = (NodeCodeArea)vector2.elementAt(0);
        NodeCodeArea nodeCodeArea = (NodeCodeArea)this.hash.get("C_00000000");
        String string = ((NodeCodeArea)object).getUnusedBlockNum();
        int n = Integer.parseInt(string, 16);
        String string2 = nodeCodeArea.getUnusedBlockNum();
        int n2 = Integer.parseInt(string2, 16);
        string2 = Integer.toHexString(n2 += n).toUpperCase();
        nodeCodeArea.setUnusedBlockNum(this.addZero(string2, 4));
        this.deleteArea((NodeCodeArea)object);
        FaverChipManufacture faverChipManufacture = (FaverChipManufacture)nodeCodeSystem.getManufactureBlock();
        this.registArea000(faverChipManufacture.position, true);
        FaverChipIssue faverChipIssue = (FaverChipIssue)nodeCodeSystem.getIssueBlock();
        this.registArea000(faverChipIssue.position, true);
        FaverChipSystem faverChipSystem = (FaverChipSystem)nodeCodeSystem.getSystemBlock();
        this.registArea000(faverChipSystem.position, true);
        FaverChipArea faverChipArea = ((NodeCodeArea)object).getAreaBlock();
        this.registArea000(faverChipArea.position, true);
        this.hash.remove("D_" + nodeCodeSystem.getSystemNo() + "_" + ((NodeCode)object).getNodeCodeString());
        this.hash.remove("D_" + nodeCodeSystem.getNodeCodeString());
    }

    private void deleteService(NodeCodeService nodeCodeService) {
        Object object;
        Object object2;
        Object object3;
        NodeCodeArea nodeCodeArea = (NodeCodeArea)nodeCodeService.getParent();
        NodeCodeService nodeCodeService2 = (NodeCodeService)nodeCodeService.getPinNode();
        Vector vector = nodeCodeArea.getChildren();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            if (!object3.equals(nodeCodeService)) continue;
            vector.remove(nodeCodeService);
            break;
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            if (!object3.equals(nodeCodeService2)) continue;
            vector.remove(nodeCodeService2);
            break;
        }
        object3 = null;
        if (!this.overlapCheck(nodeCodeService)) {
            object3 = nodeCodeService.getChildren();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (FaverChipUserData)object2.nextElement();
                if (((FaverChipUserData)object).getDeleted()) continue;
                this.registArea000(((FaverChipUserData)object).position, nodeCodeArea);
                ((FaverChipUserData)object).setDeleted(true);
            }
            ((Vector)object3).removeAllElements();
        }
        object2 = nodeCodeService.getServiceBlock();
        this.registArea000(((FaverChipService)object2).position, nodeCodeArea);
        if (nodeCodeService.getAreaType() == 3) {
            this.hash.remove("D_" + this.getSystemNo(nodeCodeService) + "_" + nodeCodeService.getNodeCodeString());
        } else {
            this.hash.remove("C_" + nodeCodeService.getNodeCodeString());
        }
        if (nodeCodeService2 != null) {
            object3 = nodeCodeService2.getChildren();
            object = ((Vector)object3).elements();
            while (object.hasMoreElements()) {
                FaverChipUserData faverChipUserData = (FaverChipUserData)object.nextElement();
                this.registArea000(faverChipUserData.position, nodeCodeArea);
            }
            ((Vector)object3).removeAllElements();
            object2 = nodeCodeService2.getServiceBlock();
            this.registArea000(((FaverChipService)object2).position, nodeCodeArea);
            if (nodeCodeService2.getAreaType() == 3) {
                this.hash.remove("D_" + this.getSystemNo(nodeCodeService2) + "_" + nodeCodeService2.getNodeCodeString());
            } else {
                this.hash.remove("C_" + nodeCodeService2.getNodeCodeString());
            }
        }
    }

    private void deleteArea(NodeCodeArea nodeCodeArea) {
        if (nodeCodeArea.getNodeCodeString().equals("00000000")) {
            this.deleteAreaBlock(nodeCodeArea);
        } else {
            NodeCodeArea nodeCodeArea2 = (NodeCodeArea)nodeCodeArea.getParent();
            Vector vector = nodeCodeArea2.getChildren();
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!e.equals(nodeCodeArea)) continue;
                vector.remove(nodeCodeArea);
            }
            this.deleteAreaBlock(nodeCodeArea);
            FaverChipArea faverChipArea = nodeCodeArea.getAreaBlock();
            this.registArea000(faverChipArea.position, nodeCodeArea2);
            if (nodeCodeArea.getAreaType() == 3) {
                this.hash.remove("D_" + this.getSystemNo(nodeCodeArea) + "_" + nodeCodeArea.getNodeCodeString());
            } else {
                this.hash.remove("C_" + nodeCodeArea.getNodeCodeString());
            }
        }
    }

    private void deleteAreaBlock(NodeCodeArea nodeCodeArea) {
        Vector vector = nodeCodeArea.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            NodeCode nodeCode;
            Object e = vector.elementAt(i);
            if (e instanceof NodeCodeArea) {
                nodeCode = (NodeCodeArea)e;
                this.deleteAreaBlock((NodeCodeArea)nodeCode);
                object = ((NodeCodeArea)nodeCode).getAreaBlock();
                this.registArea000(((FaverChipArea)object).position, nodeCodeArea);
                if (nodeCode.getAreaType() == 3) {
                    this.hash.remove("D_" + this.getSystemNo(nodeCode) + "_" + nodeCode.getNodeCodeString());
                    continue;
                }
                this.hash.remove("C_" + nodeCode.getNodeCodeString());
                continue;
            }
            if (!(e instanceof NodeCodeService)) continue;
            nodeCode = (NodeCodeService)e;
            if (nodeCodeArea.getNodeCodeString().equals("00000020")) continue;
            object = nodeCode.getChildren();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                FaverChipUserData faverChipUserData = (FaverChipUserData)((Vector)object).elementAt(j);
                if (faverChipUserData.getDeleted()) continue;
                this.registArea000(faverChipUserData.position, (NodeCode)nodeCodeArea.getParent());
                faverChipUserData.setDeleted(true);
            }
            ((Vector)object).removeAllElements();
            FaverChipService faverChipService = ((NodeCodeService)nodeCode).getServiceBlock();
            this.registArea000(faverChipService.position, (NodeCode)nodeCodeArea.getParent());
            if (nodeCode.getAreaType() == 3) {
                this.hash.remove("D_" + this.getSystemNo(nodeCode) + "_" + nodeCode.getNodeCodeString());
                continue;
            }
            this.hash.remove("C_" + nodeCode.getNodeCodeString());
        }
    }

    private void registArea000(int n, boolean bl) {
        FaverChipUnuse faverChipUnuse = new FaverChipUnuse(n, new byte[16], new byte[6]);
        NodeCode nodeCode = (NodeCode)this.hash.get("C_00000000");
        Vector vector = nodeCode.getChildren();
        vector.addElement(faverChipUnuse);
        if (bl) {
            NodeCodeArea nodeCodeArea = (NodeCodeArea)nodeCode;
            String string = nodeCodeArea.getUnusedBlockNum();
            int n2 = Integer.parseInt(string, 16);
            string = Integer.toHexString(++n2);
            nodeCodeArea.setUnusedBlockNum(this.addZero(string, 4));
        }
    }

    private void registArea000(int n, NodeCode nodeCode) {
        if (nodeCode.getAreaType() == 3) {
            NodeCode nodeCode2 = nodeCode;
            while (nodeCode2 instanceof NodeCodeArea) {
                String string = ((NodeCodeArea)nodeCode2).getUnusedBlockNum();
                int n2 = Integer.parseInt(string, 16);
                string = Integer.toHexString(++n2).toUpperCase();
                ((NodeCodeArea)nodeCode2).setUnusedBlockNum(this.addZero(string, 4));
                nodeCode2 = (NodeCode)nodeCode2.getParent();
            }
            this.registArea000(n, false);
        } else {
            this.registArea000(n, true);
        }
    }

    public void checkFreeBlock(int n) throws FaverChipNodeException {
        if (this.getUnuseBlockNum() < n) {
            String string = Resource.getString("FC_ERR_NO_FREE_BLOCK");
            throw new FaverChipNodeException(string);
        }
    }

    public void checkFreeBlock(NodeCode nodeCode, int n) throws FaverChipNodeException {
        if (this.getUnuseBlockNum() < n) {
            String string = Resource.getString("FC_ERR_NO_FREE_BLOCK");
            throw new FaverChipNodeException(string);
        }
        if (nodeCode instanceof NodeCodeSystem) {
            return;
        }
        if (nodeCode instanceof NodeCodeArea && nodeCode.getNodeCodeString().equals("00000000")) {
            return;
        }
        NodeCodeArea nodeCodeArea = (NodeCodeArea)nodeCode.getParent();
        while (!nodeCodeArea.getNodeCodeString().equals("00000000")) {
            nodeCodeArea = (NodeCodeArea)nodeCodeArea.getParent();
        }
        int n2 = Integer.parseInt(nodeCodeArea.getUnusedBlockNum(), 16);
        if (n > n2) {
            String string = Resource.getString("FC_ERR_NO_FREE_BLOCK");
            throw new FaverChipNodeException(string);
        }
    }

    public void setSystemBlocks(NodeCodeSystem nodeCodeSystem) throws FaverChipNodeException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte by = (byte)nodeCodeSystem.getSystemNo();
        if (by == 255) {
            String string = Resource.getString("FC_ERR_NO_MORE_DIVIDE_SYSTEM");
            throw new FaverChipNodeException(string);
        }
        byArray = new byte[16];
        byArray2 = new byte[]{1, by, 0, 0, 0, 0};
        FaverChipManufacture faverChipManufacture = new FaverChipManufacture(this.releaseUnuseBlock(), byArray, byArray2);
        nodeCodeSystem.setManufacture(faverChipManufacture);
        byArray = new byte[16];
        byArray2 = new byte[]{2, by, 0, 0, 0, 0};
        FaverChipIssue faverChipIssue = new FaverChipIssue(this.releaseUnuseBlock(), byArray, byArray2);
        nodeCodeSystem.setIssue(faverChipIssue);
        FaverChipSystem faverChipSystem = (FaverChipSystem)nodeCodeSystem.getSystemBlock();
        int n = faverChipSystem.position;
        faverChipSystem.position = faverChipIssue.position;
        faverChipIssue.position = faverChipManufacture.position;
        faverChipManufacture.position = n;
        byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, -1, -2, 0, 2, 0, 0, 0, 0};
        byArray2 = new byte[]{4, 0, 0, 0, 0, 0};
        FaverChipArea faverChipArea = new FaverChipArea(this.releaseUnuseBlock(), byArray, byArray2);
        byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0};
        byArray2 = new byte[]{5, 0, 0, 0, 0, 0};
        FaverChipService faverChipService = new FaverChipService(this.releaseUnuseBlock(), byArray, byArray2);
        faverChipService.setCode(32L);
        byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, -4, 0, 0, 0};
        byArray2 = new byte[]{6, 0, 0, 0, 32, 0};
        FaverChipUserData faverChipUserData = new FaverChipUserData(this.releaseUnuseBlock(), byArray, byArray2);
        NodeCodeArea nodeCodeArea = new NodeCodeArea(3);
        nodeCodeArea.setArea(faverChipArea);
        nodeCodeArea.setParent(nodeCodeSystem);
        nodeCodeSystem.setChild(nodeCodeArea);
        NodeCodeService nodeCodeService = new NodeCodeService(3);
        nodeCodeService.setService(faverChipService);
        nodeCodeService.setPinNode(null);
        nodeCodeService.setParent(nodeCodeArea);
        nodeCodeService.setChild(faverChipUserData);
        nodeCodeArea.setPinNode(nodeCodeService);
        nodeCodeArea.setChild(nodeCodeService);
        this.hash.put("D_" + by + "_" + nodeCodeArea.getNodeCodeString(), nodeCodeArea);
        this.hash.put("D_" + by + "_" + nodeCodeService.getNodeCodeString(), nodeCodeService);
        FaverChipBlockContainerID faverChipBlockContainerID = (FaverChipBlockContainerID)this.ncCard.getContainerIdBlock();
        byte[] byArray3 = faverChipBlockContainerID.getInfoBytes();
        byArray3[1] = (byte)(byArray3[1] + 1);
    }

    private byte getSystemNo() {
        int n;
        Vector vector = this.ncCard.getChildren();
        boolean[] blArray = new boolean[15];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < vector.size() && n < 15; ++n) {
            NodeCodeSystem nodeCodeSystem = (NodeCodeSystem)vector.elementAt(n);
            int n2 = nodeCodeSystem.getSystemNo();
            if (0 > n2 || n2 >= 15) continue;
            blArray[n2] = true;
        }
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n]) continue;
            return (byte)(n & 0xFF);
        }
        return -1;
    }

    private byte getSystemNo(NodeCode nodeCode) {
        if (nodeCode instanceof NodeCodeSystem) {
            return (byte)(((NodeCodeSystem)nodeCode).getSystemNo() & 0xFF);
        }
        int n = 0;
        do {
            NodeCode nodeCode2;
            if ((nodeCode2 = (NodeCode)nodeCode.getParent()) instanceof NodeCodeSystem) {
                return (byte)(((NodeCodeSystem)nodeCode2).getSystemNo() & 0xFF);
            }
            nodeCode = nodeCode2;
        } while (n++ <= 100);
        return -1;
    }

    public void compareUnusedBlock(NodeCodeArea nodeCodeArea, String string) throws FaverChipNodeException {
        NodeCodeArea nodeCodeArea2;
        String string2;
        int n;
        int n2;
        String string3 = nodeCodeArea.getUsedBlockNum();
        int n3 = Integer.parseInt(string3, 16);
        int n4 = n3 - (n2 = Integer.parseInt(string, 16));
        if (n4 > (n = Integer.parseInt(string2 = (nodeCodeArea2 = (NodeCodeArea)this.hash.get("C_00000000")).getUnusedBlockNum(), 16))) {
            String string4 = Resource.getString("FC_ERR_INVALID_ASSIGN_BLOCK");
            throw new FaverChipNodeException(string4);
        }
        int n5 = this.getUseBlock(nodeCodeArea);
        int n6 = n3 - n5;
        if (n6 < 0) {
            String string5 = Resource.getString("FC_ERR_INVALID_ASSIGN_BLOCK");
            throw new FaverChipNodeException(string5);
        }
        String string6 = Integer.toHexString(n6).toUpperCase();
        nodeCodeArea.setUnusedBlockNum(this.addZero(string6, 4));
        String string7 = nodeCodeArea2.getUnusedBlockNum();
        int n7 = Integer.parseInt(string7, 16);
        string7 = Integer.toHexString(n7 -= n4).toUpperCase();
        nodeCodeArea2.setUnusedBlockNum(this.addZero(string7, 4));
    }

    private void DGB_HASH_KEYS() {
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println("     :=: " + (String)enumeration.nextElement());
        }
    }

    class NodeComparator
    implements Comparator {
        private NodeCodeArea target;
        private long targetPin;

        public NodeComparator(NodeCodeArea nodeCodeArea) {
            this.target = nodeCodeArea;
            if (this.target != null) {
                FaverChipArea faverChipArea = this.target.getAreaBlock();
                this.targetPin = faverChipArea.code | 0x20L;
            } else {
                this.targetPin = -1L;
            }
        }

        public int compare(Object object, Object object2) {
            long l = 0L;
            long l2 = 0L;
            int n = 0;
            int n2 = 0;
            if (!(object instanceof NodeCode)) {
                return 1;
            }
            NodeCode nodeCode = (NodeCode)object;
            if (!(object2 instanceof NodeCode)) {
                return -1;
            }
            NodeCode nodeCode2 = (NodeCode)object2;
            try {
                l = Long.parseLong(nodeCode.getNodeCodeString(), 16);
                l2 = Long.parseLong(nodeCode2.getNodeCodeString(), 16);
                n = nodeCode.getNodeCodeType();
                n2 = nodeCode2.getNodeCodeType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (l == this.targetPin) {
                return -1;
            }
            if (l2 == this.targetPin) {
                return 1;
            }
            if (n == 4 && n2 == 4) {
                if (((NodeCodeService)nodeCode).isPINService() && ((NodeCodeService)nodeCode2).isPINService() || !((NodeCodeService)nodeCode).isPINService() && !((NodeCodeService)nodeCode2).isPINService()) {
                    if (l < l2) {
                        return -1;
                    }
                    if (l > l2) {
                        return 1;
                    }
                    return 0;
                }
                if (((NodeCodeService)nodeCode).isPINService()) {
                    l &= 0xFFFFFFFFFFFFFFDFL;
                } else {
                    l2 &= 0xFFFFFFFFFFFFFFDFL;
                }
                if (l < l2) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                if (((NodeCodeService)nodeCode).isPINService()) {
                    return 1;
                }
                return -1;
            }
            if (l < l2) {
                return -1;
            }
            if (l > l2) {
                return 1;
            }
            return 0;
        }
    }
}

