/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipUserData;
import java.util.Vector;

class NodeCodeService
extends NodeCode {
    static final int ACCESS_TYPE_UNKNOWN = 0;
    static final int ACCESS_TYPE_RONDOM_RW = 1;
    static final int ACCESS_TYPE_RONDOM_RO = 2;
    static final int ACCESS_TYPE_CYCLIC_RW = 3;
    static final int ACCESS_TYPE_CYCLIC_RO = 4;
    static final int ACCESS_TYPE_PARSE_RDIW = 6;
    static final int ACCESS_TYPE_PARSE_RCWDEW = 7;
    static final int ACCESS_TYPE_PARSE_RDEW = 8;
    static final int ACCESS_TYPE_PARSE_RO = 9;
    private String keyVer;
    private String dataNum;
    private boolean certification;
    private boolean comparison;
    private int typeAccess;
    private boolean pinService;
    private FaverChipService fcvService;
    private NodeCode pinNode;

    NodeCodeService() {
        this.nodeType = 4;
        this.nodeCode = "0";
        this.keyVer = "0";
        this.dataNum = "0";
        this.typeAccess = 0;
        this.certification = false;
        this.comparison = false;
        this.pinService = false;
        this.pinNode = null;
    }

    NodeCodeService(int n) {
        this();
        this.areaType = n;
    }

    public NodeCode getPinNode() {
        return this.pinNode;
    }

    public FaverChipService getServiceBlock() {
        return this.fcvService;
    }

    public void setService(FaverChipBlock faverChipBlock) {
        this.fcvService = (FaverChipService)faverChipBlock;
        this.nodeCode = this.getHexString(faverChipBlock.getDataBytes(), 0, 4);
        this.keyVer = this.getHexString(faverChipBlock.getDataBytes(), 4, 2);
        this.dataNum = this.getHexString(faverChipBlock.getDataBytes(), 10, 2);
        this.certification = (((FaverChipService)faverChipBlock).code & 1L) == 0L;
        this.comparison = (((FaverChipService)faverChipBlock).code & 0x20L) != 0L;
        this.typeAccess = this.getAccessAtrribute(faverChipBlock);
        if ((this.fcvService.code & 0x20L) != 0L) {
            this.pinService = true;
        }
    }

    public void setPinNode(NodeCode nodeCode) {
        this.pinNode = nodeCode;
    }

    private int getAccessAtrribute(FaverChipBlock faverChipBlock) {
        int n = (int)(((FaverChipService)faverChipBlock).code & 0x1FL);
        int n2 = 0;
        if (8 <= n && n <= 9) {
            n2 = 1;
        } else if (10 <= n && n <= 11) {
            n2 = 2;
        } else if (12 <= n && n <= 13) {
            n2 = 3;
        } else if (14 <= n && n <= 15) {
            n2 = 4;
        } else if (16 <= n && n <= 17) {
            n2 = 6;
        } else if (18 <= n && n <= 19) {
            n2 = 7;
        } else if (20 <= n && n <= 21) {
            n2 = 8;
        } else if (22 <= n && n <= 23) {
            n2 = 9;
        }
        return n2;
    }

    public String getKeyVersion() {
        return this.keyVer;
    }

    public String getDataNum() {
        return this.dataNum;
    }

    public boolean getCertification() {
        return this.certification;
    }

    public boolean getComparison() {
        this.comparison = false;
        if (this.pinNode != null) {
            Vector vector = this.pinNode.getChildren();
            if (vector.size() != 1) {
                return false;
            }
            FaverChipUserData faverChipUserData = (FaverChipUserData)vector.elementAt(0);
            byte by = faverChipUserData.getDataBytes()[8];
            this.comparison = (by & 0xC0) != 0;
        }
        return this.comparison;
    }

    public int getAccessAtrribute() {
        return this.typeAccess;
    }

    public boolean isPINService() {
        return this.pinService;
    }

    public void setKeyVersion(String string) {
        this.keyVer = string.trim();
        byte[] byArray = this.getBytes(this.keyVer);
        this.fcvService.setDataBytes(byArray, 0, 4, byArray.length);
    }

    public void setNodeCode(String string) {
        this.nodeCode = string.trim();
        byte[] byArray = this.getBytes(this.nodeCode);
        this.fcvService.setDataBytes(byArray, 0, 0, byArray.length);
        this.typeAccess = this.getAccessAtrribute(this.fcvService);
    }

    public void setDataNum(String string) {
        this.dataNum = string.trim();
        byte[] byArray = this.getBytes(this.dataNum);
        this.fcvService.setDataBytes(byArray, 0, 10, byArray.length);
    }

    public void setChildData(String[] stringArray) {
        for (int i = 0; i < this.children.size() && i < stringArray.length; ++i) {
            FaverChipUserData faverChipUserData = (FaverChipUserData)this.children.elementAt(i);
            byte[] byArray = this.getBytes(stringArray[i].trim());
            faverChipUserData.setDataBytes(byArray, 0, 0, byArray.length);
        }
    }
}

