/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipIssue;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipManufacture;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.FaverChipSystem;

class NodeCodeSystem
extends NodeCode {
    private String idm;
    private String idi;
    private String pmi;
    private String keyVer;
    private FaverChipManufacture fcvIdm;
    private FaverChipIssue fcvIssue;
    private FaverChipSystem fcvSystem;
    private int systemNo;

    NodeCodeSystem() {
        this.nodeType = 2;
        this.idm = "0";
        this.idi = "0";
        this.pmi = "0";
        this.nodeCode = "0";
        this.keyVer = "0";
        this.systemNo = -1;
    }

    NodeCodeSystem(int n) {
        this();
        this.areaType = n;
    }

    public void setManufacture(FaverChipBlock faverChipBlock) {
        this.fcvIdm = (FaverChipManufacture)faverChipBlock;
        this.idm = this.getHexString(faverChipBlock.getDataBytes(), 0, 8);
    }

    public void setIssue(FaverChipBlock faverChipBlock) {
        this.fcvIssue = (FaverChipIssue)faverChipBlock;
        this.idi = this.getHexString(faverChipBlock.getDataBytes(), 0, 8);
        this.pmi = this.getHexString(faverChipBlock.getDataBytes(), 8, 8);
    }

    public void setSystem(FaverChipBlock faverChipBlock) {
        this.fcvSystem = (FaverChipSystem)faverChipBlock;
        this.nodeCode = this.getHexString(faverChipBlock.getDataBytes(), 0, 2);
        this.keyVer = this.getHexString(faverChipBlock.getDataBytes(), 4, 2);
        byte[] byArray = this.fcvSystem.getInfoBytes();
        this.systemNo = byArray[1];
    }

    public FaverChipBlock getManufactureBlock() {
        return this.fcvIdm;
    }

    public FaverChipBlock getIssueBlock() {
        return this.fcvIssue;
    }

    public FaverChipBlock getSystemBlock() {
        return this.fcvSystem;
    }

    public int getSystemNo() {
        return this.systemNo;
    }

    public String getIDm() {
        return this.idm;
    }

    public String getIDi() {
        return this.idi;
    }

    public String getPMi() {
        return this.pmi;
    }

    public String getKeyVersion() {
        return this.keyVer;
    }

    public void setIDm(String string) {
        this.idm = string.trim();
        byte[] byArray = this.getBytes(this.idm);
        this.fcvIdm.setDataBytes(byArray, 0, 0, byArray.length);
    }

    public void setIDi(String string) {
        this.idi = string.trim();
        byte[] byArray = this.getBytes(this.idi);
        this.fcvIssue.setDataBytes(byArray, 0, 0, byArray.length);
    }

    public void setPMi(String string) {
        this.pmi = string.trim();
        byte[] byArray = this.getBytes(this.pmi);
        this.fcvIssue.setDataBytes(byArray, 0, 8, byArray.length);
    }

    public void setKeyVersion(String string) {
        this.keyVer = string.trim();
        byte[] byArray = this.getBytes(this.keyVer);
        this.fcvSystem.setDataBytes(byArray, 0, 4, byArray.length);
    }

    public void setNodeCode(String string) {
        this.nodeCode = string.trim();
        byte[] byArray = this.getBytes(this.nodeCode);
        this.fcvSystem.setDataBytes(byArray, 0, 0, byArray.length);
    }
}

