/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.scratchpad;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SPManager {
    protected static final int SP_NUM_MAX = 16;
    protected static final int MINIAPP_SP_NUM_MAX = 1;
    protected static final int INT_BYTE_LENGTH = 4;
    protected static final int MAX_FULLAPP_SP_SIZE = 0x200000;
    protected static final int MAX_MINIAPP_SP_SIZE = 204800;
    private static final int HEADER_SIZE = 64;
    private String projectHome;
    private String projectName;
    private String SPFilePath;
    private String SPFileDir;
    private static final String STORE_DIR = "sp";
    private static final String SPFILE_SUFFIX = ".sp";
    private int[] spSize = new int[16];
    private int[] loadedSpSize = new int[16];
    private int totalSize;
    private int lastChannel;
    private byte[] headerByteArray = new byte[64];
    private Object[] dataByteArrays = new Object[16];

    protected void setDataByteArray(int n, byte[] byArray) {
        this.dataByteArrays[n] = byArray;
    }

    protected byte[] getDataByteArray(int n) {
        return (byte[])this.dataByteArrays[n];
    }

    private String getSPFilePath() {
        return this.SPFilePath;
    }

    public SPManager(String string, String string2) {
        this.projectHome = string;
        this.projectName = string2;
        String string3 = System.getProperty("file.separator");
        this.SPFileDir = string + string3 + string2 + string3 + STORE_DIR;
        this.SPFilePath = this.SPFileDir + string3 + string2 + SPFILE_SUFFIX;
        for (int i = 0; i < this.spSize.length; ++i) {
            this.spSize[i] = -1;
            this.loadedSpSize[i] = -1;
        }
    }

    public SPManager(File file) throws IOException, FileNotFoundException {
        this.SPFilePath = file.getAbsolutePath();
        if (!this.getReadAttribute()) {
            throw new IOException("Illegal Data");
        }
        for (int i = 0; i < this.spSize.length; ++i) {
            this.spSize[i] = -1;
            this.loadedSpSize[i] = -1;
        }
        if (!this.analyzeSPFile()) {
            throw new IOException();
        }
        this.spSize = this.loadedSpSize;
    }

    public boolean getReadAttribute() {
        boolean bl = false;
        File file = new File(this.getSPFilePath());
        bl = file.canRead();
        return bl;
    }

    public boolean valiateSPSize(int n, String string) {
        Object[] objectArray = null;
        StringTokenizer stringTokenizer = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        int n2 = 0;
        if (string != null && !"".equals(this.spSize)) {
            int n3;
            int n4 = 0;
            char[] cArray = string.toCharArray();
            for (n3 = 0; n3 < cArray.length; ++n3) {
                if (cArray[n3] != ',') continue;
                ++n4;
            }
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            objectArray = arrayList.toArray();
            if (string.length() > 0 && objectArray.length == 0 || n4 + 1 != objectArray.length) {
                bl = false;
            } else if (n == 4 && objectArray.length > 1) {
                bl = false;
            } else if (objectArray.length > 16) {
                bl = false;
            } else {
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    try {
                        int n5 = Integer.parseInt((String)objectArray[n3]);
                        if (n5 < 0) {
                            bl = false;
                            break;
                        }
                        if ((n != 4 || (n2 += n5) <= 204800) && n2 < 0x200000) continue;
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean existSPFile() {
        boolean bl = false;
        File file = new File(this.getSPFilePath());
        bl = file.exists();
        return bl;
    }

    private boolean existSPFileDir() {
        boolean bl = false;
        File file = new File(this.SPFileDir);
        bl = file.exists();
        return bl;
    }

    public void processScratchPad(String string) throws FileNotFoundException, IOException {
        int n;
        Object[] objectArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        objectArray = arrayList.toArray();
        for (n = 0; n < objectArray.length; ++n) {
            String string2 = (String)objectArray[n];
            this.spSize[n] = Integer.parseInt(string2);
        }
        if (this.existSPFile()) {
            n = this.analyzeSPFile() ? 1 : 0;
            if (n == 0) {
                throw new IOException();
            }
            if (!this.compareNewSPSize()) {
                this.resize();
                this.createSPFile();
            }
        } else if (this.existSPFileDir() && objectArray.length != 0) {
            this.createSPData();
            this.createSPFile();
        } else if (!this.existSPFileDir() && objectArray.length != 0) {
            throw new FileNotFoundException();
        }
    }

    public void deleteScratchPad() throws IOException {
        if (this.existSPFile()) {
            File file = new File(this.getSPFilePath());
            file.delete();
        }
    }

    private boolean analyzeSPFile() throws IOException, FileNotFoundException {
        int n;
        Object object;
        boolean bl = true;
        File file = new File(this.getSPFilePath());
        byte[] byArray = new byte[(int)file.length()];
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[4];
        int n2 = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            object = new BufferedInputStream(fileInputStream);
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            ((BufferedInputStream)object).close();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        byArray2 = this.getHeader(byArray);
        for (n = 0; n < this.spSize.length; ++n) {
            int n3 = n * 4;
            System.arraycopy(byArray2, n3, byArray3, 0, 4);
            this.loadedSpSize[n] = this.getInt(byArray3);
            if (this.loadedSpSize[n] != -1) {
                n2 += this.loadedSpSize[n];
                this.lastChannel = n;
                continue;
            }
            if (this.loadedSpSize[n] >= -1) continue;
            return false;
        }
        if (byArray.length != n2 + 64) {
            return false;
        }
        this.headerByteArray = byArray2;
        for (n = 0; n < this.lastChannel + 1; ++n) {
            this.dataByteArrays[n] = object = (Object)this.getData(n, byArray, this.loadedSpSize);
        }
        return bl;
    }

    protected int findLastChannel(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length && nArray[n2] != -1) {
            n = n2++;
        }
        return n;
    }

    private int getInt(byte[] byArray) {
        int n = (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | (byArray[0] & 0xFF) << 0;
        return n;
    }

    private byte[] getHeader(byte[] byArray) {
        byte[] byArray2 = new byte[64];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private int getAddressByChannel(int n, int[] nArray) {
        int n2 = 64;
        for (int i = 0; i < nArray.length && i != n; ++i) {
            n2 += nArray[i];
        }
        return n2;
    }

    private byte[] getData(int n, byte[] byArray, int[] nArray) {
        byte[] byArray2 = new byte[nArray[n]];
        System.arraycopy(byArray, this.getAddressByChannel(n, nArray), byArray2, 0, byArray2.length);
        return byArray2;
    }

    private boolean compareNewSPSize() {
        boolean bl = false;
        for (int i = 0; i < 16; ++i) {
            if (this.spSize[i] != this.loadedSpSize[i]) {
                bl = false;
                break;
            }
            bl = true;
        }
        return bl;
    }

    private void resize() {
        byte[] byArray = null;
        byte[] byArray2 = this.createHeaderByteArray(this.spSize);
        this.headerByteArray = byArray2;
        for (int i = 0; i < 16; ++i) {
            int n = this.spSize[i];
            if (n == this.loadedSpSize[i]) continue;
            if (n != -1) {
                byArray = new byte[n];
                for (int j = 0; j < byArray.length; ++j) {
                    byArray[j] = 0;
                }
                byte[] byArray3 = (byte[])this.dataByteArrays[i];
                if (byArray3 != null) {
                    if (this.spSize[i] > this.loadedSpSize[i]) {
                        System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                    }
                    if (this.spSize[i] < this.loadedSpSize[i]) {
                        System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
                    }
                }
                this.dataByteArrays[i] = byArray;
                continue;
            }
            this.dataByteArrays[i] = null;
        }
    }

    protected void createSPData() {
        byte[] byArray = null;
        int n = this.findLastChannel(this.spSize) + 1;
        byte[] byArray2 = this.createHeaderByteArray(this.spSize);
        this.headerByteArray = byArray2;
        for (int i = 0; i < n; ++i) {
            byArray = new byte[this.spSize[i]];
            for (int j = 0; j < byArray.length; ++j) {
                byArray[j] = 0;
            }
            this.dataByteArrays[i] = byArray;
        }
    }

    protected void createSPFile() throws FileNotFoundException, IOException {
        try {
            byte[] byArray;
            FileOutputStream fileOutputStream = new FileOutputStream(this.getSPFilePath());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(this.headerByteArray);
            for (int i = 0; i < this.spSize.length && (byArray = (byte[])this.dataByteArrays[i]) != null; ++i) {
                bufferedOutputStream.write(byArray);
            }
            bufferedOutputStream.close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private byte[] createHeaderByteArray(int[] nArray) {
        int n = 0;
        byte[] byArray = new byte[64];
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            System.arraycopy(this.getIntBytes(n), 0, byArray, 4 * i, 4);
            if (n < 0) continue;
            this.totalSize += n;
        }
        return byArray;
    }

    private byte[] getIntBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 0), (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)};
        return byArray;
    }

    protected void replace(int n, byte[] byArray) {
        this.spSize[n] = byArray.length;
        this.dataByteArrays[n] = byArray;
    }

    protected int[] getLoadedSpSize() {
        return this.loadedSpSize;
    }
}

