/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.BookmarkEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class BookmarkEntryWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private JTextField nameField;
    private JTextField urlField;
    private static final File bookmarkDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "bookmark");
    private BookmarkEntry entry;

    BookmarkEntryWindow(MainWindow mainWindow, BookmarkEntry bookmarkEntry) {
        super(mainWindow, Resource.getString("BOOKMARK_ENTRY_WINDOW_TITLE"));
        this.entry = bookmarkEntry;
        this.addWindowListener();
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("BOOKMARK_NAME"));
        JLabel jLabel2 = new JLabel(Resource.getString("BOOKMARK_URL"));
        this.nameField = new JTextField(16);
        this.urlField = new JTextField(16);
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel.add(jLabel);
        jPanel.add(this.nameField);
        jPanel2.add(jLabel2);
        jPanel2.add(this.urlField);
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jPanel3);
        container.add("Center", jPanel4);
        container.add("South", jPanel5);
        this.setResizable(true);
        this.pack();
    }

    void set() {
        if (this.nameField.getText().length() == 0) {
            System.out.println(Resource.format("INPUT_EMPTY_ERR", Resource.getString("BOOKMARK_NAME")));
        } else if (this.urlField.getText().length() == 0) {
            System.out.println(Resource.format("INPUT_EMPTY_ERR", Resource.getString("BOOKMARK_NAME")));
        } else {
            this.entry.setBookmarkName(this.nameField.getText());
            this.entry.setUrl(this.urlField.getText());
            String string = bookmarkDir + File.separator + this.entry.getNo() + "_" + this.entry.getBookmarkName() + ".bmk";
            try {
                try {
                    this.entry.save(string);
                }
                catch (IOException iOException) {
                    System.err.println(Resource.format("WRITE_ERR", string));
                    Object var4_3 = null;
                    this.parent.closeWindow(this);
                }
                Object var4_2 = null;
                this.parent.closeWindow(this);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.parent.closeWindow(this);
                throw throwable;
            }
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }
}

