/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.BookmarkEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class BookmarkWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private static String[] bookmarkFiles;
    private JTable bookmarkTable;
    private Hashtable bookmarkHash;
    private MainWindow parent;
    private int next;
    private JScrollPane scrollpane;
    private Container cp;
    private static final File bookmarkDir;
    static /* synthetic */ Class class$java$lang$Object;

    BookmarkWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("BOOKMARK_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.cp = this.getContentPane();
        this.cp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(Resource.getString("ADD"));
        JButton jButton2 = new JButton(Resource.getString("CLOSE"));
        jButton.setActionCommand("add");
        jButton2.setActionCommand("close");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.bookmarkTable = this.createBookmarkTable();
        this.scrollpane = new JScrollPane(this.bookmarkTable);
        this.cp.add("Center", this.scrollpane);
        this.cp.add("South", jPanel2);
        this.setResizable(true);
        ((Component)this).setSize(480, 200);
    }

    private JTable createBookmarkTable() {
        Object object;
        String[] stringArray;
        String string = "";
        bookmarkFiles = bookmarkDir.list(new BookmarkFilter());
        String[] stringArray2 = new String[bookmarkFiles.length];
        this.bookmarkHash = new Hashtable();
        int n = 0;
        while (n < bookmarkFiles.length) {
            block8: {
                int n2;
                stringArray = bookmarkDir.getPath() + File.separator + bookmarkFiles[n];
                int n3 = bookmarkFiles[n].indexOf(95);
                try {
                    n2 = Integer.parseInt(bookmarkFiles[n].substring(0, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    break block8;
                }
                if (n2 >= this.next) {
                    this.next = n2;
                }
                try {
                    object = new BookmarkEntry();
                    ((BookmarkEntry)object).load((String)stringArray);
                    this.bookmarkHash.put(((BookmarkEntry)object).getBookmarkName().toString(), object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(Resource.format("NOT_FOUND_ERR", (Object)stringArray));
                }
                catch (IOException iOException) {
                    System.err.println(Resource.format("READ_ERR", (Object)stringArray));
                }
            }
            ++n;
        }
        ++this.next;
        stringArray = new String[]{Resource.getString("BOOKMARK_NAME"), Resource.getString("BOOKMARK_URL")};
        BookmarkTableModel bookmarkTableModel = new BookmarkTableModel(stringArray, 0);
        object = this.bookmarkHash.elements();
        while (object.hasMoreElements()) {
            BookmarkEntry bookmarkEntry = null;
            Object v = object.nextElement();
            if (v == null || !(v instanceof BookmarkEntry)) continue;
            bookmarkEntry = (BookmarkEntry)v;
            Vector<String> vector = new Vector<String>();
            vector.addElement(bookmarkEntry.getBookmarkName());
            vector.addElement(bookmarkEntry.getUrl());
            bookmarkTableModel.addRow(vector);
        }
        JTable jTable = new JTable(bookmarkTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = BookmarkWindow.class$("java.lang.Object")) : class$java$lang$Object, new BookmarkTableCellRenderer());
        jTable.setSelectionMode(0);
        return jTable;
    }

    void add() {
        BookmarkEntry bookmarkEntry = new BookmarkEntry();
        bookmarkEntry.setNo(this.next);
        this.parent.bme(bookmarkEntry);
        ((Component)this).setVisible(false);
        this.cp.remove(this.scrollpane);
        this.scrollpane = null;
        this.bookmarkTable = null;
        this.bookmarkTable = this.createBookmarkTable();
        this.scrollpane = new JScrollPane(this.bookmarkTable);
        this.cp.add("Center", this.scrollpane);
        ((Component)this).setVisible(true);
    }

    void close() {
        this.parent.closeWindow(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        bookmarkDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "bookmark");
    }

    class BookmarkTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        BookmarkTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class BookmarkFilter
    implements FilenameFilter {
        BookmarkFilter() {
        }

        public boolean accept(File file, String string) {
            if (file.equals(bookmarkDir)) {
                return string.endsWith(".bmk");
            }
            return false;
        }
    }

    class BookmarkTableModel
    extends DefaultTableModel {
        BookmarkTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

