/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractFrame;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.InlineView;

class BrowserWindow
extends AbstractFrame {
    private static final int FRAME_WIDTH = 400;
    private static final int FRAME_HEIGHT = 400;
    private static final int MAX_PARAM_NUM = 16;
    private static final int MAX_PARAM_LEN = 255;
    private static final String TITLE = Resource.getString("BROWSER_WINDOW_TITLE");
    private static final String HTTP_HEAD = "http://";
    private static final String HTTPS_HEAD = "https://";
    private static final String FILE_HEAD = "file:/";
    private JTextField urlField;
    private JEditorPane editorPane;
    private String urlString;

    BrowserWindow(MainWindow mainWindow) {
        super(mainWindow, TITLE);
        this.addWindowListener();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("URL"));
        this.urlField = new JTextField(20);
        JSeparator jSeparator = new JSeparator(0);
        this.editorPane = new JEditorPane();
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        BrowserWindowHyperlinkListener browserWindowHyperlinkListener = new BrowserWindowHyperlinkListener(this);
        this.editorPane.addHyperlinkListener(browserWindowHyperlinkListener);
        this.editorPane.setEditorKit(new NewHTMLEditorKit());
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.urlField.setActionCommand("browse");
        this.urlField.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jLabel);
        jPanel2.add(this.urlField);
        jPanel.add("North", jSeparator);
        jPanel.add("Center", jScrollPane);
        container.add("North", jPanel2);
        container.add("Center", jPanel);
        ((Component)this).setSize(400, 400);
    }

    void browse() {
        block10: {
            this.urlString = this.urlField.getText().trim();
            if (this.urlString.length() == 0) {
                return;
            }
            this.setTitle(TITLE + Resource.getString("READING"));
            String string = Resource.getString("COMPLETE_READING");
            String string2 = this.urlString;
            try {
                try {
                    URL uRL = new URL(this.urlString);
                    if (this.urlString.startsWith("file") && !this.urlString.endsWith("/")) {
                        String string3 = uRL.getPath();
                        while (string3.startsWith("/")) {
                            string3 = string3.substring(1);
                        }
                        File file = new File(string3);
                        if (file.isDirectory()) {
                            this.urlString = this.urlString + "/";
                        }
                    }
                    this.editorPane.setPage(this.urlString);
                }
                catch (MalformedURLException malformedURLException) {
                    string = Resource.getString("PROTOCOL_ERR");
                    System.err.println(string);
                    Object var7_10 = null;
                    this.setTitle(TITLE + " - " + string);
                    break block10;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    string = Resource.format("NOT_FOUND_ERR2", string2);
                    System.err.println(string);
                    Object var7_11 = null;
                    this.setTitle(TITLE + " - " + string);
                    break block10;
                }
                catch (IOException iOException) {
                    string = Resource.getString("COM_ERR");
                    System.err.println(string);
                    System.err.println(iOException);
                    Object var7_12 = null;
                    this.setTitle(TITLE + " - " + string);
                }
                Object var7_9 = null;
                this.setTitle(TITLE + " - " + string);
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                this.setTitle(TITLE + " - " + string);
                throw throwable;
            }
        }
    }

    void setURL(String string) {
        this.urlField.setText(string);
    }

    private String getAdfUrl(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        try {
            string2 = this.editorPane.getText();
            int n = string2.indexOf(string);
            string2 = string2.substring(0, n);
            n = string2.toLowerCase().lastIndexOf("<object");
            string2 = string2.substring(n);
            n = string2.toLowerCase().indexOf("data");
            string2 = string2.substring(n);
            n = string2.toLowerCase().indexOf("\"") + 1;
            string2 = string2.substring(n);
            n = string2.toLowerCase().indexOf(".jam") + 4;
            string2 = string2.substring(0, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string2 = null;
        }
        return string2;
    }

    private Hashtable getParameter(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2 = this.editorPane.getText();
            int n = string2.indexOf(string);
            string2 = string2.substring(0, n);
            n = string2.toLowerCase().lastIndexOf("<object") + 8;
            string2 = string2.substring(n);
            n = string2.toLowerCase().indexOf(">");
            string2 = string2.substring(0, n);
            int n2 = 0;
            String string3 = string2;
            while (string3.trim().length() != 0) {
                n = string3.indexOf("=\"");
                int n3 = string3.indexOf("\"") + 1;
                int n4 = string3.indexOf("\"", n3);
                String string4 = string3.substring(0, n).trim();
                if (!(string4.toLowerCase().equals("declare") || string4.toLowerCase().equals("data") || string4.toLowerCase().equals("id") || string4.toLowerCase().equals("type"))) {
                    String string5 = string3.substring(0, n).trim();
                    String string6 = string3.substring(n3, n4).trim();
                    if (string5.length() != 0 && string6.length() != 0) {
                        hashtable.put(string5, string6);
                        n2 = n2 + string5.getBytes().length + string6.getBytes().length;
                    }
                }
                string3 = string3.substring(n4 + 1);
            }
            if (hashtable.size() > 16 || n2 > 255) {
                hashtable = null;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            hashtable = null;
        }
        return hashtable;
    }

    private String getUrl(String string) {
        String string2;
        if (string.toLowerCase().startsWith(HTTP_HEAD) || string.toLowerCase().startsWith(HTTPS_HEAD)) {
            string2 = string;
        } else {
            int n = 0;
            string2 = this.urlString;
            if (string.startsWith("/")) {
                String string3;
                if (string2.toLowerCase().startsWith(HTTP_HEAD)) {
                    n = HTTP_HEAD.length();
                    string3 = string2.substring(n);
                } else if (string2.toLowerCase().startsWith(FILE_HEAD)) {
                    n = FILE_HEAD.length();
                    string3 = string2.substring(n);
                } else {
                    string3 = string2;
                }
                int n2 = string3.indexOf("/");
                if (n2 == -1) {
                    string2 = string2 + "/";
                    n2 = string3.length();
                }
                string2 = string2.substring(0, n += n2) + string;
            } else if (string2.endsWith("/")) {
                string2 = string2 + string;
            } else {
                String string4;
                if (string2.toLowerCase().startsWith(HTTP_HEAD)) {
                    n = HTTP_HEAD.length();
                    string4 = string2.substring(n);
                } else if (string2.toLowerCase().startsWith(FILE_HEAD)) {
                    n = FILE_HEAD.length();
                    string4 = string2.substring(n);
                } else {
                    string4 = string2;
                }
                int n3 = string4.lastIndexOf("/");
                if (n3 == -1) {
                    string2 = string2 + "/" + string;
                    return string2;
                }
                String string5 = string4.substring(n3 + 1);
                string4 = string2.substring(n += n3 + 1);
                string2 = string5.toLowerCase().indexOf(".htm") != -1 || string5.toLowerCase().indexOf(".html") != -1 ? string2.substring(0, n) + string : string2 + "/" + string;
            }
        }
        return string2;
    }

    private int getType() {
        int n;
        try {
            String string = this.editorPane.getText();
            int n2 = string.toLowerCase().lastIndexOf("<a");
            string = string.substring(n2);
            n2 = string.toLowerCase().indexOf(">") + 1;
            string = string.substring(0, n2);
            n = string.toLowerCase().indexOf("ijam=") != -1 || string.toLowerCase().indexOf("ista=") != -1 ? 5 : (string.toLowerCase().indexOf("ilet=") != -1 ? 9 : -1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n = -1;
        }
        return n;
    }

    class NewHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        NewHTMLFactory() {
        }

        public View create(Element element) {
            if (element.getName().toLowerCase().equals("object")) {
                return new InlineView(element);
            }
            return super.create(element);
        }
    }

    class NewHTMLEditorKit
    extends HTMLEditorKit {
        NewHTMLEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return new NewHTMLFactory();
        }
    }

    class BrowserWindowHyperlinkListener
    implements HyperlinkListener {
        private BrowserWindow window;

        BrowserWindowHyperlinkListener(BrowserWindow browserWindow2) {
            this.window = browserWindow2;
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = BrowserWindow.this.getAdfUrl(hyperlinkEvent.getDescription());
                if (string == null) {
                    if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                        HTMLDocument hTMLDocument = (HTMLDocument)BrowserWindow.this.editorPane.getDocument();
                        hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                    } else if (hyperlinkEvent.getURL() != null) {
                        BrowserWindow.this.urlField.setText(hyperlinkEvent.getURL().toString());
                        BrowserWindow.this.browse();
                    }
                } else {
                    Hashtable hashtable = null;
                    int n = -1;
                    StringBuffer stringBuffer = new StringBuffer("");
                    if (JAMManager.check(1, string, BrowserWindow.this.urlString, stringBuffer) && (hashtable = BrowserWindow.this.getParameter(hyperlinkEvent.getDescription())) != null && (n = BrowserWindow.this.getType()) != -1) {
                        String string2 = null;
                        string2 = JAMManager.getGpsState() && JAMManager.isGPSAppli(string) ? Resource.getString("LOCATION_SECURITY_WNG") : Resource.getString("LAUNCH_APPLICATION");
                        JOptionPane jOptionPane = new JOptionPane(string2, 3, 0);
                        JDialog jDialog = jOptionPane.createDialog(this.window, Resource.getString("CONFIRM"));
                        jDialog.setResizable(false);
                        ((Component)jDialog).setVisible(true);
                        Object object = jOptionPane.getValue();
                        if (object instanceof Integer) {
                            if ((Integer)object != 0) {
                                return;
                            }
                        } else {
                            return;
                        }
                        try {
                            BrowserWindow.this.parent.setVisibleInvoker(1, false);
                            JAMManager.invokeApplication(JAMManager.getAdfPath(), JAMManager.getJarPath(), n, JAMManager.getParams(hashtable), BrowserWindow.this.parent.getDeviceName(), BrowserWindow.this.parent.getAdfUrl(), JAMManager.getProjectName(), DebugTraceWindow.getDebugParam());
                        }
                        catch (Exception exception) {
                            BrowserWindow.this.parent.setVisibleInvoker(1, true);
                            BrowserWindow.this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this.window, 0);
                            return;
                        }
                        BrowserWindow.this.parent.setEnabledDeviceMenu(false);
                    } else if (stringBuffer.toString().equals(Resource.getString("NOT_APPLICATION_WNG"))) {
                        String string3 = BrowserWindow.this.getUrl(hyperlinkEvent.getDescription().trim());
                        String string4 = stringBuffer.toString();
                        BrowserWindow.this.parent.showDialog(string4, this.window, 2);
                        BrowserWindow.this.urlField.setText(string3);
                        BrowserWindow.this.browse();
                    } else {
                        String string5 = Resource.getString("NOT_LAUNCH_APPLICATION_WNG2");
                        BrowserWindow.this.parent.showDialog(string5, this.window, 2);
                    }
                }
            }
        }
    }
}

