/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.BuildException;
import com.nttdocomo.dojaemu.ktoolbar.Environment;
import com.nttdocomo.dojaemu.ktoolbar.ExecuteProcess;
import com.nttdocomo.dojaemu.ktoolbar.JavaFileSelector;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SourceChecker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

class BuildProject
implements Runnable {
    private ADF adf;
    private String classpath;
    private File srcDir;
    private File resDir;
    private File binDir;
    private File jamFile;
    private File jarFile;
    private File verifiedClassDir;
    private File unverifiedClassDir;
    private MainWindow parent;

    BuildProject(File file, String string, MainWindow mainWindow) throws BuildException {
        this.jamFile = file;
        this.classpath = string;
        this.parent = mainWindow;
        try {
            this.adf = new ADF(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", file.getPath()));
        }
        catch (IOException iOException) {
            throw new BuildException(Resource.format("READ_ERR", file.getPath()));
        }
        File file2 = file.getParentFile().getParentFile();
        this.srcDir = new File(file2, "src");
        this.resDir = new File(file2, "res");
        this.binDir = new File(file2, "bin");
        try {
            this.verifiedClassDir = File.createTempFile("class", "verified");
            this.unverifiedClassDir = File.createTempFile("class", "unverified");
        }
        catch (IOException iOException) {
            throw new BuildException(Resource.getString("MAKE_TMP_FILE_ERR"));
        }
        this.verifiedClassDir.delete();
        this.verifiedClassDir.mkdir();
        this.unverifiedClassDir.delete();
        this.unverifiedClassDir.mkdir();
        String string2 = file.getPath();
        String string3 = string2.substring(0, string2.lastIndexOf(".")) + ".jar";
        this.jarFile = new File(string3);
    }

    private boolean deleteTmpDir(File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                this.deleteTmpDir(fileArray[n]);
            } else {
                fileArray[n].delete();
            }
            ++n;
        }
        return file.delete();
    }

    private String[] makeJarCommand(String string, String string2) throws BuildException {
        String string3 = Resource.JAR;
        if (!new File(string3).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add(string3);
        vector.add(string);
        vector.add(this.jarFile.getPath());
        vector.add("-C");
        vector.add(string2);
        vector.add(".");
        return vector.toArray(new String[0]);
    }

    private String getDate() {
        int n = 60000;
        int n2 = 60 * n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Environment.getLocale());
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    public void run() {
        try {
            try {
                this.doJavac();
                this.doPreverify();
                this.doJar();
                this.updateJam();
                System.out.println(Resource.getString("FINISH_BUILD"));
            }
            catch (BuildException buildException) {
                System.err.println(buildException.getMessage());
                Object var3_2 = null;
                this.parent.setOperatable(true);
            }
            Object var3_1 = null;
            this.parent.setOperatable(true);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.parent.setOperatable(true);
            throw throwable;
        }
    }

    void doJavac() throws BuildException {
        String string = Resource.JAVA;
        String string2 = Resource.DOJA_CONV;
        String string3 = Resource.TOOLS_JAR;
        if (!new File(string).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        if (!new File(string3).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        if (!new File(string2).exists()) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", string2));
        }
        Vector vector = JavaFileSelector.get(this.srcDir);
        if (vector == null || vector.size() == 0) {
            throw new BuildException(Resource.getString("SRC_NOT_FOUND_ERR"));
        }
        Vector<String> vector2 = new Vector<String>();
        vector2.add(string);
        vector2.add("-Xbootclasspath/a:" + string2);
        vector2.add("-classpath");
        vector2.add(string3);
        vector2.add(Environment.getJavaCompilerClassName(this.parent.getJavacType()));
        vector2.add("-target");
        vector2.add("1.1");
        vector2.add("-encoding");
        vector2.add("SJIS_i");
        vector2.add("-bootclasspath");
        vector2.add(this.classpath);
        vector2.add("-d");
        vector2.add(this.unverifiedClassDir.getPath());
        vector2.add("-classpath");
        vector2.add(this.unverifiedClassDir.getPath());
        vector2.add("-g:none");
        vector2.addAll(vector);
        String[] stringArray = vector2.toArray(new String[0]);
        try {
            ExecuteProcess executeProcess = new ExecuteProcess(stringArray);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("JAVAC_ERR"));
            }
        }
        catch (Exception exception) {
            throw new BuildException(Resource.getString("JAVAC_ERR"));
        }
    }

    void doPreverify() throws BuildException {
        String string = Resource.PREVERIFY;
        if (!new File(string).exists()) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", string));
        }
        String[] stringArray = new String[]{string, "-classpath", this.classpath, "-d", this.verifiedClassDir.getPath(), this.unverifiedClassDir.getPath()};
        try {
            try {
                ExecuteProcess executeProcess = new ExecuteProcess(stringArray);
                if (executeProcess.execute() != 0) {
                    throw new BuildException(Resource.getString("PREVERIFY_ERR"));
                }
                Object var5_5 = null;
                this.deleteTmpDir(this.unverifiedClassDir);
            }
            catch (Exception exception) {
                throw new BuildException(Resource.getString("PREVERIFY_ERR"));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteTmpDir(this.unverifiedClassDir);
            throw throwable;
        }
    }

    void doJar() throws BuildException {
        this.jarFile.delete();
        try {
            try {
                String[] stringArray = this.makeJarCommand("cfM", this.verifiedClassDir.getPath());
                ExecuteProcess executeProcess = new ExecuteProcess(stringArray);
                if (executeProcess.execute() != 0) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
                stringArray = this.makeJarCommand("ufM", this.resDir.getPath());
                executeProcess = new ExecuteProcess(stringArray);
                if (executeProcess.execute() != 0) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
                Object var4_5 = null;
                this.deleteTmpDir(this.verifiedClassDir);
            }
            catch (BuildException buildException) {
                throw buildException;
            }
            catch (Exception exception) {
                throw new BuildException(Resource.format("MAKE_JAR_ERR", this.jarFile.getPath()));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.deleteTmpDir(this.verifiedClassDir);
            throw throwable;
        }
        System.out.println(Resource.format("MAKE_FILE", this.jarFile.getPath()));
    }

    void updateJam() throws BuildException {
        String string = this.adf.getProperty("AppName");
        String string2 = this.adf.getProperty("AppClass");
        this.adf.setProperty("AppSize", String.valueOf(this.jarFile.length()));
        this.adf.setProperty("LastModified", this.getDate());
        try {
            if (string == null || string2 == null) {
                SourceChecker sourceChecker = new SourceChecker();
                ArrayList arrayList = sourceChecker.getSourceList(this.srcDir.getPath());
                int n = 0;
                while (n < arrayList.size()) {
                    System.out.println(arrayList.get(n));
                    ++n;
                }
                if (sourceChecker.checkMainClass(arrayList)) {
                    if (string == null) {
                        this.adf.setProperty("AppName", sourceChecker.getClassName());
                        System.out.println(Resource.format("UPDATE_ADFKEY", "AppName"));
                    }
                    if (string2 == null) {
                        if (sourceChecker.getPackageName().length() == 0) {
                            this.adf.setProperty("AppClass", sourceChecker.getClassName());
                        } else {
                            this.adf.setProperty("AppClass", sourceChecker.getPackageName() + "." + sourceChecker.getClassName());
                        }
                        System.out.println(Resource.format("UPDATE_ADFKEY", "AppClass"));
                    }
                    if (sourceChecker.getAppliType() == 1) {
                        this.adf.setProperty("MyConcierge", "yes");
                        this.parent.setLaunchConcierge();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parent.saveProject(this.adf) == 0) {
            System.out.println(Resource.format("UPDATE_FILE", this.jamFile.getPath()));
        }
    }
}

