/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.EditorFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class EditorWindow
extends AbstractWindow {
    private static String projectHome;
    public static final String NOTEPAD = "NOTEPAD.EXE";
    private MainWindow parent;
    private JTextField editorField;

    EditorWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("EDITOR_WINDOW_TITLE"), true);
        this.addWindowListener();
        this.parent = mainWindow;
        JLabel jLabel = new JLabel(Resource.getString("EDITOR"));
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        JButton jButton3 = new JButton(Resource.getString("FILE_SELECT"));
        jButton3.setMnemonic(82);
        this.editorField = new JTextField(24);
        this.editorField.setText(mainWindow.getSourceEditor());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.editorField);
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        container.add("North", jPanel);
        container.add("Center", jPanel2);
        container.add("South", jPanel3);
        jButton3.setActionCommand("select");
        jButton2.setActionCommand("cancel");
        jButton.setActionCommand("save");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton3.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        projectHome = mainWindow.getProjectHome();
        this.pack();
    }

    void save() {
        String string = this.editorField.getText();
        if (string.trim().length() == 0) {
            try {
                this.parent.showDialog(Resource.format("SPECIFIED_VAL_WNG", Resource.getString("EDITOR")), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        if (!new File(string).isFile()) {
            try {
                this.parent.showDialog(Resource.getString("NOT_EDITOR_WNG"), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        this.parent.setSourceEditor(string);
        this.parent.closeWindow(this);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    void select() {
        JFileChooser jFileChooser = new JFileChooser(new File(this.editorField.getText()).getAbsolutePath());
        jFileChooser.setDialogTitle(Resource.getString("EDITOR_DIALOG"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(new EditorFileFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.editorField.setText(jFileChooser.getSelectedFile().toString());
        }
    }
}

