/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AttrWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.security.MessageDigest;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FeliCaCPIDWindow
extends AbstractWindow {
    private static final int HASH_BYTE_LENGTH = 16;
    private static final int TEXT_FIELD_WIDTH = 40;
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String JAM_EXT = ".jam";
    private JTextField urlField = null;
    private AttrWindow adfWindow = null;
    private Setting projectSetting = null;

    FeliCaCPIDWindow(MainWindow mainWindow, AttrWindow attrWindow, Setting setting) {
        super(mainWindow, Resource.getString("FELICACPID_WINDOW_TITLE"));
        Object object;
        this.adfWindow = attrWindow;
        this.addWindowListener();
        this.projectSetting = setting;
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        JLabel jLabel = new JLabel(Resource.getString("ADF_URL"));
        JButton jButton = new JButton(Resource.getString("SET"));
        jButton.setActionCommand("set");
        jButton.addActionListener(actionDispatcher);
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(actionDispatcher);
        this.urlField = new JTextField(40);
        if (setting != null && (object = setting.getProperty("adfUrl")) != null) {
            this.urlField.setText((String)object);
        }
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(1));
        ((Container)object).add(jLabel);
        ((Container)object).add(this.urlField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)object, "Center");
        container.add((Component)jPanel, "South");
        this.pack();
        this.setResizable(false);
    }

    void set() {
        String string = this.urlField.getText();
        char[] cArray = null;
        String string2 = null;
        if (string == null || string.trim().length() == 0) {
            this.parent.showDialog(Resource.format("EMP_VAL_WNG", Resource.getString("ADF_URL")), this, 2);
            return;
        }
        if (!string.trim().startsWith(HTTP) && !string.trim().startsWith(HTTPS)) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("ADF_URL")), this, 2);
            return;
        }
        if (!string.trim().endsWith(JAM_EXT)) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("ADF_URL")), this, 2);
            return;
        }
        cArray = this.urlField.getText().toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] < ' ' || cArray[n] > '~') {
                this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("ADF_URL")), this, 2);
                return;
            }
            ++n;
        }
        string2 = this.getHash(string.getBytes(), 16);
        if (string2 != null) {
            this.projectSetting.setProperty("adfUrl", string);
            if (this.parent.saveProjectSetting(this.projectSetting) != 0) {
                this.parent.showDialog(Resource.format("WRITE_ERR", this.parent.getProjectSettingPath(this.parent.getProjectName())), this, 2);
                return;
            }
            this.adfWindow.setFeliCaCPID(string2);
            this.parent.closeWindow(this);
        }
    }

    private String getHash(byte[] byArray, int n) {
        MessageDigest messageDigest = null;
        String string = new String();
        if (byArray == null) {
            return null;
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        int n2 = 0;
        while (n2 < n) {
            try {
                String string2 = Integer.toHexString(byArray2[n2] & 0xFF);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                string = string.concat(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            ++n2;
        }
        return string;
    }

    void cancel() {
        this.parent.closeWindow(this);
    }
}

