/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.ScheduleDate;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

class LimitWindow
extends AbstractWindow {
    private int maxPhoneBook = 10;
    private int maxGroup = 10;
    private Setting projectSetting;
    private final int MAX_ENTRY = 6;
    private final int MAX_PARAM = 36;
    private final int MAX_INT_LEN = 10;
    private int LAUNCH_TIME_MAX = 4;
    private JTextField maxSentMail;
    private JTextField maxReceivedMail;
    private JTextField maxPhoneBookEntry;
    private JTextField maxGroupEntry;
    private JTextField fontBaseline;
    private JTextField launchTimeMax;
    private JButton launchTimeMaxButton;
    private JList launchTimes;
    private JComboBox dateType;
    private JTextField launchTimeY;
    private JComboBox launchTimeM;
    private JComboBox launchTimeW;
    private JTextField launchTimeD;
    private JTextField launchTimeH;
    private JTextField launchTimeMin;
    private String[] launchTimesStr;
    private String[] dispLaunchTimesStr;
    private int previousIndex;
    private String[] dateTypeStr = new String[]{"ONETIME", "DAILY", "WEEKLY", "MONTHLY", "YEARLY"};
    private String[] monthStr = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private String[] weekStr = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};

    LimitWindow(MainWindow mainWindow, Setting setting) {
        super(mainWindow, Resource.getString("LIMIT_WINDOW_TITLE"));
        this.addWindowListener();
        if (setting == null) {
            this.projectSetting = new Setting();
            this.projectSetting.setProperty("sentMailMax", "0");
            this.projectSetting.setProperty("receivedMailMax", "0");
            this.projectSetting.setProperty("phoneBookEntry", "0");
            this.projectSetting.setProperty("groupEntry", "0");
            this.projectSetting.setProperty("useChat", "false");
            this.projectSetting.setProperty("launchTime", "");
            this.projectSetting.setProperty("fontBaselinePos", "0");
            this.projectSetting.setProperty("launchTime", "");
        } else {
            this.projectSetting = setting;
            try {
                this.LAUNCH_TIME_MAX = Integer.parseInt(this.projectSetting.getProperty("launchTimeMax"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.maxSentMail = new JTextField(6);
        this.maxReceivedMail = new JTextField(6);
        this.maxPhoneBookEntry = new JTextField(6);
        this.maxGroupEntry = new JTextField(6);
        this.fontBaseline = new JTextField(10);
        this.launchTimeMax = new JTextField(3);
        this.launchTimes = new JList();
        this.launchTimes.setSelectionMode(0);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = LimitWindow.this.launchTimes.getSelectedIndex();
                LimitWindow.this.setLaunchTime(n);
                if (LimitWindow.this.previousIndex >= LimitWindow.this.launchTimesStr.length) {
                    LimitWindow.this.previousIndex = -1;
                } else {
                    LimitWindow.this.previousIndex = n;
                }
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.launchTimes);
        this.dateType = new JComboBox<String>(this.dateTypeStr);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                switch (LimitWindow.this.dateType.getSelectedIndex()) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 8;
                        break;
                    }
                    case 4: {
                        n = 16;
                    }
                }
                LimitWindow.this.setEnabled(n);
            }
        };
        this.launchTimeY = new JTextField(5);
        this.launchTimeM = new JComboBox<String>(this.monthStr);
        this.launchTimeW = new JComboBox<String>(this.weekStr);
        this.launchTimeD = new JTextField(3);
        this.launchTimeH = new JTextField(3);
        this.launchTimeMin = new JTextField(3);
        JLabel jLabel = new JLabel("YYYY:");
        JLabel jLabel2 = new JLabel("DD:");
        JLabel jLabel3 = new JLabel("HH:");
        JLabel jLabel4 = new JLabel("MM:");
        JLabel jLabel5 = new JLabel(Resource.getString("MAX_MAIL_SENT"));
        String string = this.projectSetting.getProperty("sentMailMax");
        ((JTextComponent)this.maxSentMail).setDocument(new HalfNumberDocument(6));
        if (string != null) {
            this.maxSentMail.setText(string);
        } else {
            this.maxSentMail.setText("0");
        }
        JLabel jLabel6 = new JLabel(Resource.getString("MAX_MAIL_RECEIVED"));
        String string2 = this.projectSetting.getProperty("receivedMailMax");
        ((JTextComponent)this.maxReceivedMail).setDocument(new HalfNumberDocument(6));
        if (string2 != null) {
            this.maxReceivedMail.setText(string2);
        } else {
            this.maxReceivedMail.setText("0");
        }
        JLabel jLabel7 = new JLabel(Resource.getString("MAX_PHONEBOOK"));
        String string3 = this.projectSetting.getProperty("phoneBookEntry");
        ((JTextComponent)this.maxPhoneBookEntry).setDocument(new HalfNumberDocument(6));
        if (string3 != null) {
            this.maxPhoneBookEntry.setText(string3);
        } else {
            this.maxPhoneBookEntry.setText("0");
        }
        JLabel jLabel8 = new JLabel(Resource.getString("MAX_GROUP"));
        String string4 = this.projectSetting.getProperty("groupEntry");
        ((JTextComponent)this.maxGroupEntry).setDocument(new HalfNumberDocument(6));
        if (string4 != null) {
            this.maxGroupEntry.setText(string4);
        } else {
            this.maxGroupEntry.setText("0");
        }
        JLabel jLabel9 = new JLabel(Resource.getString("FONT_BASELINE"));
        String string5 = this.projectSetting.getProperty("fontBaselinePos");
        ((JTextComponent)this.fontBaseline).setDocument(new HalfNumberDocument(10));
        if (string5 != null) {
            this.fontBaseline.setText(string5);
        } else {
            this.fontBaseline.setText("");
        }
        JLabel jLabel10 = new JLabel(Resource.getString("LAUNCH_TIME"));
        String string6 = this.projectSetting.getProperty("launchTimeMax");
        ((JTextComponent)this.launchTimeMax).setDocument(new HalfNumberDocument(3));
        if (string6 == null) {
            string6 = "4";
        }
        this.launchTimeMax.setText(string6);
        this.launchTimesStr = this.getStringsFromProperty(this.projectSetting.getProperty("launchTime"));
        this.dispLaunchTimesStr = this.getDispStringsFromProperties(this.launchTimesStr);
        this.launchTimes.setListData(this.dispLaunchTimesStr);
        this.launchTimes.setSelectedIndex(0);
        JButton jButton = new JButton(Resource.getString("SET_LAUNCH_TIME_ENTRY"));
        jButton.setActionCommand("setLaunchTimeMax");
        ((JTextComponent)this.launchTimeY).setDocument(new HalfNumberDocument(4));
        ((JTextComponent)this.launchTimeD).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.launchTimeH).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.launchTimeMin).setDocument(new HalfNumberDocument(2));
        if (this.launchTimesStr != null && this.launchTimesStr[0] != null) {
            this.insertLaunchTime(0);
        } else {
            this.launchTimeY.setText("");
            this.launchTimeM.setSelectedIndex(0);
            this.launchTimeW.setSelectedIndex(0);
            this.launchTimeD.setText("");
            this.launchTimeH.setText("");
            this.launchTimeMin.setText("");
            this.setEnabled(1);
        }
        JButton jButton2 = new JButton(Resource.getString("SET"));
        JButton jButton3 = new JButton(Resource.getString("CANCEL"));
        jButton2.setActionCommand("set");
        jButton3.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        jPanel.setLayout(new GridBagLayout());
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.maxSentMail, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.maxReceivedMail, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.maxPhoneBookEntry, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.maxGroupEntry, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.fontBaseline, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.launchTimeMax, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jButton, gridBagConstraints);
        jPanel3.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.dateType, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)this.launchTimeY, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel2.add((Component)this.launchTimeM, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel2.add((Component)this.launchTimeW, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        jPanel2.add((Component)this.launchTimeD, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 8;
        jPanel2.add((Component)this.launchTimeH, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 10;
        jPanel2.add((Component)this.launchTimeMin, gridBagConstraints);
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        container.add(jPanel3);
        container.add(jPanel2);
        container.add(jScrollPane);
        container.add(jPanel4);
        this.dateType.addActionListener(actionListener);
        this.launchTimes.addListSelectionListener(listSelectionListener);
        this.setResizable(false);
        this.pack();
    }

    void set() {
        int n = 0;
        String string = this.maxSentMail.getText();
        String string2 = this.maxReceivedMail.getText();
        String string3 = this.maxPhoneBookEntry.getText();
        String string4 = this.maxGroupEntry.getText();
        String string5 = this.fontBaseline.getText();
        if ((string = this.checkNumStr(string)) == null) {
            this.showDialog(Resource.getString("SET_LIMIT_WNG"));
            return;
        }
        if ((string2 = this.checkNumStr(string2)) == null) {
            this.showDialog(Resource.getString("SET_LIMIT_WNG"));
            return;
        }
        if ((string3 = this.checkNumStr(string3)) == null) {
            this.showDialog(Resource.getString("SET_LIMIT_WNG"));
            return;
        }
        if ((string4 = this.checkNumStr(string4)) == null) {
            this.showDialog(Resource.getString("SET_LIMIT_WNG"));
            return;
        }
        if ((string5 = this.checkNumStr(string5)) == null) {
            string5 = "";
        }
        this.projectSetting.setProperty("sentMailMax", string);
        this.projectSetting.setProperty("receivedMailMax", string2);
        this.projectSetting.setProperty("phoneBookEntry", string3);
        this.projectSetting.setProperty("groupEntry", string4);
        this.projectSetting.setProperty("fontBaselinePos", string5);
        this.projectSetting.setProperty("launchTimeMax", String.valueOf(this.LAUNCH_TIME_MAX));
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.launchTimes.getSelectedIndex();
        if (n2 >= 0) {
            this.setLaunchTime(n2);
        }
        int n3 = 0;
        while (n3 < this.launchTimesStr.length) {
            if (!this.launchTimesStr[n3].equals("null")) {
                stringBuffer.append(this.launchTimesStr[n3] + ";");
            } else {
                stringBuffer.append(";");
            }
            ++n3;
        }
        this.projectSetting.setProperty("launchTime", stringBuffer.toString());
        if ((n += this.parent.saveProjectSetting(this.projectSetting)) == 0) {
            System.out.println(Resource.getString("UPDATE_SETTING"));
        }
        this.parent.closeWindow(this);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private String checkNumStr(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
            if (n < 0) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return String.valueOf(n);
    }

    private void showDialog(String string) {
        Object[] objectArray = new Object[]{Resource.getString("OK")};
        JOptionPane jOptionPane = new JOptionPane(string, 2, 0, null, objectArray);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("WNG"));
        jDialog.setResizable(false);
        ((Component)jDialog).setVisible(true);
        Object object = jOptionPane.getValue();
    }

    void setLaunchTimeMax() {
        try {
            this.LAUNCH_TIME_MAX = Integer.parseInt(this.launchTimeMax.getText());
            if (this.LAUNCH_TIME_MAX < 4) {
                this.LAUNCH_TIME_MAX = 4;
                this.launchTimeMax.setText("4");
            }
            String[] stringArray = new String[this.LAUNCH_TIME_MAX];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = n < this.launchTimesStr.length ? this.launchTimesStr[n] : "null";
                ++n;
            }
            this.launchTimesStr = stringArray;
            String[] stringArray2 = this.getDispStringsFromProperties(this.launchTimesStr);
            this.dispLaunchTimesStr = stringArray2;
            this.launchTimes.setListData(this.dispLaunchTimesStr);
            this.launchTimes.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDispLaunchTimeStr(ScheduleDate scheduleDate) {
        StringBuffer stringBuffer = new StringBuffer();
        if (scheduleDate != null) {
            switch (scheduleDate.getType()) {
                case 1: {
                    stringBuffer.append("Onetime ");
                    stringBuffer.append(scheduleDate.get(1) + " ");
                    stringBuffer.append(this.getMonthStr(scheduleDate.get(2)) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(5), 2) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                case 2: {
                    stringBuffer.append("Everyday ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                case 4: {
                    stringBuffer.append("Every ");
                    stringBuffer.append(this.getWeekStr(scheduleDate.get(7)) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                case 8: {
                    stringBuffer.append("Every ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(5), 2) + " ");
                    stringBuffer.append("of month ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                case 16: {
                    stringBuffer.append("Every ");
                    stringBuffer.append(this.getMonthStr(scheduleDate.get(2)) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(5), 2) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                default: {
                    stringBuffer.append("null");
                    break;
                }
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    private String getWeekStr(int n) {
        switch (n) {
            case 1: {
                return "Sunday";
            }
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
        }
        return null;
    }

    private String getMonthStr(int n) {
        switch (n) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return null;
    }

    private String[] getStringsFromProperty(String string) {
        String[] stringArray = new String[this.LAUNCH_TIME_MAX];
        int n = 0;
        while (n < this.LAUNCH_TIME_MAX) {
            int n2;
            if (string != null && (n2 = string.indexOf(59)) != -1) {
                stringArray[n] = n2 == 0 ? "null" : string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                stringArray[n] = "null";
            }
            ++n;
        }
        return stringArray;
    }

    private String[] getDispStringsFromProperties(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = this.getDispLaunchTimeStr(this.getScheduleDateFromProperty(stringArray[n]));
            ++n;
        }
        return stringArray2;
    }

    private void insertLaunchTime(int n) {
        try {
            ScheduleDate scheduleDate = this.getScheduleDateFromProperty(this.launchTimesStr[n]);
            switch (scheduleDate.getType()) {
                case 1: {
                    this.dateType.setSelectedIndex(0);
                    break;
                }
                case 2: {
                    this.dateType.setSelectedIndex(1);
                    break;
                }
                case 4: {
                    this.dateType.setSelectedIndex(2);
                    break;
                }
                case 8: {
                    this.dateType.setSelectedIndex(3);
                    break;
                }
                case 16: {
                    this.dateType.setSelectedIndex(4);
                    break;
                }
                default: {
                    return;
                }
            }
            if (scheduleDate.getType() == 4) {
                switch (scheduleDate.get(7)) {
                    case 1: {
                        this.launchTimeW.setSelectedIndex(0);
                        break;
                    }
                    case 2: {
                        this.launchTimeW.setSelectedIndex(1);
                        break;
                    }
                    case 3: {
                        this.launchTimeW.setSelectedIndex(2);
                        break;
                    }
                    case 4: {
                        this.launchTimeW.setSelectedIndex(3);
                        break;
                    }
                    case 5: {
                        this.launchTimeW.setSelectedIndex(4);
                        break;
                    }
                    case 6: {
                        this.launchTimeW.setSelectedIndex(5);
                        break;
                    }
                    case 7: {
                        this.launchTimeW.setSelectedIndex(6);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (scheduleDate.getType() == 1) {
                this.launchTimeY.setText(String.valueOf(scheduleDate.get(1)));
            }
            if (scheduleDate.getType() == 1 || scheduleDate.getType() == 16) {
                this.launchTimeM.setSelectedIndex(scheduleDate.get(2));
            }
            if (scheduleDate.getType() == 1 || scheduleDate.getType() == 16 || scheduleDate.getType() == 8) {
                this.launchTimeD.setText(String.valueOf(scheduleDate.get(5)));
            }
            this.launchTimeH.setText(String.valueOf(scheduleDate.get(11)));
            this.launchTimeMin.setText(String.valueOf(scheduleDate.get(12)));
            this.setEnabled(scheduleDate.getType());
        }
        catch (Exception exception) {
            this.dateType.setSelectedIndex(0);
            this.launchTimeY.setText("");
            this.launchTimeM.setSelectedIndex(0);
            this.launchTimeW.setSelectedIndex(0);
            this.launchTimeD.setText("");
            this.launchTimeH.setText("");
            this.launchTimeMin.setText("");
            this.setEnabled(1);
            return;
        }
    }

    private void setEnabled(int n) {
        switch (n) {
            case 2: {
                this.launchTimeY.setEnabled(false);
                this.launchTimeM.setEnabled(false);
                this.launchTimeW.setEnabled(false);
                this.launchTimeD.setEnabled(false);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
            case 4: {
                this.launchTimeY.setEnabled(false);
                this.launchTimeM.setEnabled(false);
                this.launchTimeW.setEnabled(true);
                this.launchTimeD.setEnabled(false);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
            case 8: {
                this.launchTimeY.setEnabled(false);
                this.launchTimeM.setEnabled(false);
                this.launchTimeW.setEnabled(false);
                this.launchTimeD.setEnabled(true);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
            case 16: {
                this.launchTimeY.setEnabled(false);
                this.launchTimeM.setEnabled(true);
                this.launchTimeW.setEnabled(false);
                this.launchTimeD.setEnabled(true);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
            case 1: {
                this.launchTimeY.setEnabled(true);
                this.launchTimeM.setEnabled(true);
                this.launchTimeW.setEnabled(false);
                this.launchTimeD.setEnabled(true);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
        }
    }

    private void setLaunchTime(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            return;
        }
        switch (this.dateType.getSelectedIndex()) {
            case 0: {
                if (this.launchTimeY.getText().length() == 0 || this.launchTimeD.getText().length() == 0 || Integer.parseInt(this.launchTimeD.getText()) == 0 || this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(1) + "@");
                stringBuffer.append(this.launchTimeY.getText() + "/");
                stringBuffer.append(this.launchTimeM.getSelectedIndex() + "/");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeD.getText() + "/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            case 1: {
                if (this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(2) + "@");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            case 2: {
                if (this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(4) + "@");
                stringBuffer.append("/");
                stringBuffer.append("/");
                switch (this.launchTimeW.getSelectedIndex()) {
                    case 0: {
                        stringBuffer.append(String.valueOf(1) + "/");
                        break;
                    }
                    case 1: {
                        stringBuffer.append(String.valueOf(2) + "/");
                        break;
                    }
                    case 2: {
                        stringBuffer.append(String.valueOf(3) + "/");
                        break;
                    }
                    case 3: {
                        stringBuffer.append(String.valueOf(4) + "/");
                        break;
                    }
                    case 4: {
                        stringBuffer.append(String.valueOf(5) + "/");
                        break;
                    }
                    case 5: {
                        stringBuffer.append(String.valueOf(6) + "/");
                        break;
                    }
                    case 6: {
                        stringBuffer.append(String.valueOf(7) + "/");
                    }
                }
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            case 3: {
                if (this.launchTimeD.getText().length() == 0 || Integer.parseInt(this.launchTimeD.getText()) == 0 || this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(8) + "@");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeD.getText() + "/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            case 4: {
                if (this.launchTimeD.getText().length() == 0 || Integer.parseInt(this.launchTimeD.getText()) == 0 || this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(16) + "@");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeM.getSelectedIndex() + "/");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeD.getText() + "/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            default: {
                stringBuffer.append("null");
            }
        }
        if (this.previousIndex >= 0) {
            this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
            this.dispLaunchTimesStr[this.previousIndex] = this.getDispLaunchTimeStr(this.getScheduleDateFromProperty(stringBuffer.toString()));
        }
        this.launchTimes.repaint();
        this.insertLaunchTime(n);
    }

    private ScheduleDate getScheduleDateFromProperty(String string) {
        ScheduleDate scheduleDate;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            int n7 = string.indexOf(64);
            int n8 = Integer.parseInt(string.substring(0, n7));
            scheduleDate = new ScheduleDate(n8);
            int n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 1) {
                n = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 1 || n8 == 16) {
                n2 = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 4) {
                n3 = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 1 || n8 == 16 || n8 == 8) {
                n4 = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 1 || n8 == 16 || n8 == 8 || n8 == 4 || n8 == 2) {
                n5 = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            if (n8 == 1 || n8 == 16 || n8 == 8 || n8 == 4 || n8 == 2) {
                n6 = Integer.parseInt(string.substring(n9));
            }
            if (n8 == 1 || n8 == 16 || n8 == 8 || n8 == 4 || n8 == 2) {
                scheduleDate.set(12, n6);
                scheduleDate.set(11, n5);
            }
            if (n8 == 1 || n8 == 16 || n8 == 8) {
                scheduleDate.set(5, n4);
            }
            if (n8 == 4) {
                scheduleDate.set(7, n3);
            }
            if (n8 == 1 || n8 == 16) {
                scheduleDate.set(2, n2);
            }
            if (n8 == 1) {
                scheduleDate.set(1, n);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return scheduleDate;
    }

    private static String paddingZero(int n, int n2) {
        String string = "" + n;
        String string2 = "";
        if (string.length() >= n2) {
            return string;
        }
        int n3 = 0;
        while (n3 < n2 - string.length()) {
            string2 = string2.concat("0");
            ++n3;
        }
        return string2.concat(string);
    }
}

