/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.Environment;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

class LocationInfoWindow
extends AbstractWindow {
    private MainWindow parent;
    private JComboBox latitudeCombo;
    private JComboBox longitudeCombo;
    private JTextField titleEntryField;
    private JTextField latitudeDegreeField;
    private JTextField latitudeMinuteField;
    private JTextField latitudeSecondField;
    private JTextField latitudeCentiSecondField;
    private JTextField longitudeDegreeField;
    private JTextField longitudeMinuteField;
    private JTextField longitudeSecondField;
    private JTextField longitudeCentiSecondField;
    private JTextField timestampYearField;
    private JTextField timestampMonthField;
    private JTextField timestampDayField;
    private JTextField timestampHourField;
    private JTextField timestampMinuteField;
    private JTextField timestampSecondField;
    private JTextField timestampMilliSecondField;
    private ButtonGroup accuracyLevelButtonGroup;
    private JRadioButton accuracyCoarseRadioButton;
    private JRadioButton accuracyNormalRadioButton;
    private JRadioButton accuracyFineRadioButton;
    private JButton setButton;
    private JButton cancelButton;
    private String[] latitudePrefixItems = null;
    private String[] longitudePrefixItems = null;
    private String locationTitleId = null;
    private long locationInfoTimestamp = 0L;
    private int locationInfoLevel = 0;
    private String locationInfoLatitude = null;
    private String locationInfoLongitude = null;
    private int locationInfoDatum = 0;
    private int TITLE_NUM_MAX = 30;
    private String ILLEGAL_TITLE = "1";
    private String ILLEGAL_TIME = "2";
    private String ILLEGAL_LONGITUDE = "3";
    private String ILLEGAL_LATITUDE = "4";
    private String ILLEGAL_ID = "5";
    private boolean islocationImage = false;

    LocationInfoWindow(MainWindow mainWindow, int n) {
        super(mainWindow, null);
        this.parent = mainWindow;
        this.addWindowListener();
        if (n == 14) {
            this.islocationImage = true;
        }
        if (this.islocationImage) {
            this.setTitle(Resource.getString("LOCATION_IMAGE_WINDOW_TITLE"));
        } else {
            this.setTitle(Resource.getString("LOCATION_INFO_WINDOW_TITLE"));
        }
        this.init();
        this.loadLocationInfoFile();
        this.latitudePrefixItems = new String[2];
        this.latitudePrefixItems[0] = new String("N  ");
        this.latitudePrefixItems[1] = new String("S  ");
        this.longitudePrefixItems = new String[2];
        this.longitudePrefixItems[0] = new String("E  ");
        this.longitudePrefixItems[1] = new String("W ");
        this.latitudeCombo = new JComboBox<String>(this.latitudePrefixItems);
        this.longitudeCombo = new JComboBox<String>(this.longitudePrefixItems);
        if (this.getDmsPart(this.locationInfoLatitude, 0).equals("N  ")) {
            this.latitudeCombo.setSelectedIndex(0);
        } else {
            this.latitudeCombo.setSelectedIndex(1);
        }
        if (this.getDmsPart(this.locationInfoLongitude, 0).equals("E  ")) {
            this.longitudeCombo.setSelectedIndex(0);
        } else {
            this.longitudeCombo.setSelectedIndex(1);
        }
        JLabel jLabel = null;
        jLabel = this.islocationImage ? new JLabel(Resource.getString("LOCATION_IMAGE_ID")) : new JLabel(Resource.getString("LOCATION_INFO_TITLE"));
        JLabel jLabel2 = new JLabel(Resource.getString("LOCATION_INFO_TIMESTAMP"));
        JLabel jLabel3 = new JLabel(Resource.getString("GPS_ACCURACY_LEVEL"));
        JLabel jLabel4 = new JLabel(Resource.getString("GPS_LATITUDE"));
        JLabel jLabel5 = new JLabel(Resource.getString("GPS_LONGITUDE"));
        JLabel jLabel6 = new JLabel(Resource.getString("GPS_DATUM_TYPE"));
        JLabel jLabel7 = new JLabel(".");
        JLabel jLabel8 = new JLabel(".");
        JLabel jLabel9 = new JLabel(".");
        JLabel jLabel10 = new JLabel(".");
        JLabel jLabel11 = new JLabel(".");
        JLabel jLabel12 = new JLabel(".");
        JLabel jLabel13 = new JLabel(" " + Resource.getString("GPS_DATUM_WGS84"));
        JLabel jLabel14 = new JLabel("/");
        JLabel jLabel15 = new JLabel("/");
        JLabel jLabel16 = new JLabel(" ");
        JLabel jLabel17 = new JLabel(":");
        JLabel jLabel18 = new JLabel(":");
        JLabel jLabel19 = new JLabel(".");
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.accuracyCoarseRadioButton = new JRadioButton("1");
        this.accuracyNormalRadioButton = new JRadioButton("2");
        this.accuracyFineRadioButton = new JRadioButton("3");
        this.accuracyLevelButtonGroup = new ButtonGroup();
        this.accuracyLevelButtonGroup.add(this.accuracyCoarseRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyNormalRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyFineRadioButton);
        switch (this.locationInfoLevel) {
            case 1: {
                this.accuracyCoarseRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.accuracyNormalRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.accuracyFineRadioButton.setSelected(true);
            }
        }
        this.titleEntryField = new JTextField(this.TITLE_NUM_MAX);
        if (this.islocationImage) {
            ((JTextComponent)this.titleEntryField).setDocument(new HalfNumberDocument(this.TITLE_NUM_MAX));
        }
        this.titleEntryField.setText(this.locationTitleId);
        this.timestampYearField = new JTextField(4);
        this.timestampMonthField = new JTextField(3);
        this.timestampDayField = new JTextField(3);
        this.timestampHourField = new JTextField(3);
        this.timestampMinuteField = new JTextField(3);
        this.timestampSecondField = new JTextField(3);
        this.timestampMilliSecondField = new JTextField(4);
        ((JTextComponent)this.timestampYearField).setDocument(new HalfNumberDocument(4));
        ((JTextComponent)this.timestampMonthField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.timestampDayField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.timestampHourField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.timestampMinuteField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.timestampSecondField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.timestampMilliSecondField).setDocument(new HalfNumberDocument(3));
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Environment.getLocale());
        gregorianCalendar.setTime(new Date(this.locationInfoTimestamp));
        this.timestampYearField.setText(String.valueOf(gregorianCalendar.get(1)));
        this.timestampMonthField.setText(this.fillZero(String.valueOf(gregorianCalendar.get(2) + 1), 2));
        this.timestampDayField.setText(this.fillZero(String.valueOf(gregorianCalendar.get(5)), 2));
        this.timestampHourField.setText(this.fillZero(String.valueOf(gregorianCalendar.get(11)), 2));
        this.timestampMinuteField.setText(this.fillZero(String.valueOf(gregorianCalendar.get(12)), 2));
        this.timestampSecondField.setText(this.fillZero(String.valueOf(gregorianCalendar.get(13)), 2));
        this.timestampMilliSecondField.setText(this.fillZero(String.valueOf(gregorianCalendar.get(14)), 3));
        this.latitudeDegreeField = new JTextField(4);
        this.latitudeMinuteField = new JTextField(3);
        this.latitudeSecondField = new JTextField(3);
        this.latitudeCentiSecondField = new JTextField(3);
        ((JTextComponent)this.latitudeDegreeField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.latitudeMinuteField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.latitudeSecondField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.latitudeCentiSecondField).setDocument(new HalfNumberDocument(2));
        this.latitudeDegreeField.setHorizontalAlignment(4);
        this.latitudeMinuteField.setHorizontalAlignment(4);
        this.latitudeSecondField.setHorizontalAlignment(4);
        this.latitudeCentiSecondField.setHorizontalAlignment(4);
        this.latitudeDegreeField.setText(this.getDmsPart(this.locationInfoLatitude, 1));
        this.latitudeMinuteField.setText(this.getDmsPart(this.locationInfoLatitude, 2));
        this.latitudeSecondField.setText(this.getDmsPart(this.locationInfoLatitude, 3));
        this.latitudeCentiSecondField.setText(this.getDmsPart(this.locationInfoLatitude, 4));
        this.longitudeDegreeField = new JTextField(4);
        this.longitudeMinuteField = new JTextField(3);
        this.longitudeSecondField = new JTextField(3);
        this.longitudeCentiSecondField = new JTextField(3);
        ((JTextComponent)this.longitudeDegreeField).setDocument(new HalfNumberDocument(3));
        ((JTextComponent)this.longitudeMinuteField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.longitudeSecondField).setDocument(new HalfNumberDocument(2));
        ((JTextComponent)this.longitudeCentiSecondField).setDocument(new HalfNumberDocument(2));
        this.longitudeDegreeField.setHorizontalAlignment(4);
        this.longitudeMinuteField.setHorizontalAlignment(4);
        this.longitudeSecondField.setHorizontalAlignment(4);
        this.longitudeCentiSecondField.setHorizontalAlignment(4);
        this.longitudeDegreeField.setText(this.getDmsPart(this.locationInfoLongitude, 1));
        this.longitudeMinuteField.setText(this.getDmsPart(this.locationInfoLongitude, 2));
        this.longitudeSecondField.setText(this.getDmsPart(this.locationInfoLongitude, 3));
        this.longitudeCentiSecondField.setText(this.getDmsPart(this.locationInfoLongitude, 4));
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new GridLayout(6, 1));
        jPanel4.setLayout(new GridLayout(6, 1));
        jPanel6.setLayout(new FlowLayout(0));
        jPanel7.setLayout(new FlowLayout(0));
        jPanel8.setLayout(new FlowLayout(0));
        jPanel9.setLayout(new FlowLayout(0));
        jPanel6.add(this.timestampYearField);
        jPanel6.add(jLabel14);
        jPanel6.add(this.timestampMonthField);
        jPanel6.add(jLabel15);
        jPanel6.add(this.timestampDayField);
        jPanel6.add(jLabel16);
        jPanel6.add(this.timestampHourField);
        jPanel6.add(jLabel17);
        jPanel6.add(this.timestampMinuteField);
        jPanel6.add(jLabel18);
        jPanel6.add(this.timestampSecondField);
        jPanel6.add(jLabel19);
        jPanel6.add(this.timestampMilliSecondField);
        jPanel7.add(this.accuracyCoarseRadioButton);
        jPanel7.add(this.accuracyNormalRadioButton);
        jPanel7.add(this.accuracyFineRadioButton);
        jPanel8.add(this.latitudeCombo);
        jPanel8.add(this.latitudeDegreeField);
        jPanel8.add(jLabel7);
        jPanel8.add(this.latitudeMinuteField);
        jPanel8.add(jLabel8);
        jPanel8.add(this.latitudeSecondField);
        jPanel8.add(jLabel9);
        jPanel8.add(this.latitudeCentiSecondField);
        jPanel9.add(this.longitudeCombo);
        jPanel9.add(this.longitudeDegreeField);
        jPanel9.add(jLabel10);
        jPanel9.add(this.longitudeMinuteField);
        jPanel9.add(jLabel11);
        jPanel9.add(this.longitudeSecondField);
        jPanel9.add(jLabel12);
        jPanel9.add(this.longitudeCentiSecondField);
        jPanel3.add(this.getFlowPanel(jLabel, 2));
        jPanel3.add(this.getFlowPanel(jLabel2, 2));
        jPanel3.add(this.getFlowPanel(jLabel3, 2));
        jPanel3.add(this.getFlowPanel(jLabel4, 2));
        jPanel3.add(this.getFlowPanel(jLabel5, 2));
        jPanel3.add(this.getFlowPanel(jLabel6, 2));
        jPanel4.add(this.getFlowPanel(this.titleEntryField, 0));
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel4.add(jPanel9);
        jPanel4.add(this.getFlowPanel(jLabel13, 0));
        jPanel5.add(this.setButton);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add("North", jPanel2);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    private String fillZero(String string, int n) {
        String string2 = new String(string);
        while (string2.length() < n) {
            string2 = "0" + string2;
        }
        return string2;
    }

    private void init() {
        this.locationInfoTimestamp = System.currentTimeMillis();
        if (this.islocationImage) {
            this.locationTitleId = "0";
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Environment.getLocale());
            this.locationTitleId = simpleDateFormat.format(new Date(this.locationInfoTimestamp));
        }
        this.locationInfoLevel = 3;
        this.locationInfoLatitude = new String("N0.00.00.00");
        this.locationInfoLongitude = new String("E0.00.00.00");
        this.locationInfoDatum = 0;
    }

    private String getLocationInfoPath() {
        String string = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "location_information" + File.separator;
        string = this.islocationImage ? string + "location_image" : string + "location_information";
        return string;
    }

    private void loadLocationInfoFile() {
        File file = new File(this.getLocationInfoPath());
        BufferedReader bufferedReader = null;
        if (file.exists() && file.isFile()) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (string.startsWith("#") || (stringTokenizer = new StringTokenizer(string, ",")).countTokens() != 6) continue;
                    try {
                        this.locationTitleId = stringTokenizer.nextToken();
                        this.locationInfoTimestamp = Long.parseLong(stringTokenizer.nextToken());
                        this.locationInfoLevel = Integer.parseInt(stringTokenizer.nextToken());
                        if (this.locationInfoLevel < 1 || this.locationInfoLevel > 3) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        String string2 = stringTokenizer.nextToken();
                        if (!LocationInfoWindow.parseDmsLatitudeString(string2)) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        this.locationInfoLatitude = string2;
                        String string3 = stringTokenizer.nextToken();
                        if (!LocationInfoWindow.parseDmsLongitudeString(string3)) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        this.locationInfoLongitude = string3;
                        this.locationInfoDatum = Integer.parseInt(stringTokenizer.nextToken());
                        if (this.locationInfoDatum == 0) break;
                        throw new IllegalArgumentException("Illegal value.");
                    }
                    catch (Exception exception) {
                        this.init();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                this.init();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private boolean saveLocationInfoFile() {
        boolean bl;
        block46: {
            Object object;
            bl = true;
            int n = 1;
            long l = 0L;
            String string = null;
            String string2 = this.parseDmsLatitude();
            String string3 = this.parseDmsLongitude();
            String string4 = this.titleEntryField.getText();
            File file = new File(this.getLocationInfoPath());
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            String string5 = "";
            if (string2 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_LATITUDE);
            }
            if (string3 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_LONGITUDE);
            }
            if (this.islocationImage) {
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = "0";
                }
                try {
                    Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(this.ILLEGAL_ID);
                }
            } else {
                if (string4 == null || string4.trim().length() == 0) {
                    object = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Environment.getLocale());
                    string4 = ((DateFormat)object).format(new Date(this.locationInfoTimestamp));
                }
                if (string4.getBytes().length > this.TITLE_NUM_MAX) {
                    throw new IllegalArgumentException(this.ILLEGAL_TITLE);
                }
            }
            try {
                l = this.parseTimestamp();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(this.ILLEGAL_TIME);
            }
            if (this.accuracyCoarseRadioButton.isSelected()) {
                n = 1;
            } else if (this.accuracyNormalRadioButton.isSelected()) {
                n = 2;
            } else if (this.accuracyFineRadioButton.isSelected()) {
                n = 3;
            }
            string = string4 + "," + l + "," + n + "," + string2 + "," + string3 + "," + "0";
            object = "";
            if (file.exists() && file.isFile()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string6 = null;
                while ((string6 = bufferedReader.readLine()) != null) {
                    if (!string6.startsWith("#")) continue;
                    object = (String)object + string6 + '\n';
                }
                bufferedReader.close();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(this.getLocationInfoPath(), false));
            if (!((String)object).equals("")) {
                bufferedWriter.write((String)object);
            }
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
            Object var17_18 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block46;
            }
            catch (Exception exception) {}
            break block46;
            {
                catch (IOException iOException) {
                    this.parent.showDialog(Resource.format("WRITE_ERR", this.getLocationInfoPath()), this, 2);
                    bl = false;
                    Object var17_19 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block46;
                    }
                    catch (Exception exception) {}
                    break block46;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (illegalArgumentException.getMessage().equals(this.ILLEGAL_TITLE)) {
                        Object[] objectArray = new String[]{Resource.getString("LOCATION_INFO_TITLE"), new Integer(this.TITLE_NUM_MAX).toString()};
                        this.parent.showDialog(Resource.format("OVER_VAL_WNG", objectArray), this, 2);
                    } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_ID)) {
                        this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("LOCATION_IMAGE_ID")), this, 2);
                    } else {
                        if (illegalArgumentException.getMessage().equals(this.ILLEGAL_LATITUDE)) {
                            string5 = Resource.getString("GPS_LATITUDE");
                        } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_LONGITUDE)) {
                            string5 = Resource.getString("GPS_LONGITUDE");
                        } else if (illegalArgumentException.getMessage().equals(this.ILLEGAL_TIME)) {
                            string5 = Resource.getString("LOCATION_INFO_TIMESTAMP");
                        }
                        this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string5), this, 2);
                    }
                    bl = false;
                    Object var17_20 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block46;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    private long parseTimestamp() {
        String string = this.timestampYearField.getText();
        String string2 = this.timestampMonthField.getText();
        String string3 = this.timestampDayField.getText();
        String string4 = this.timestampHourField.getText();
        String string5 = this.timestampMinuteField.getText();
        String string6 = this.timestampSecondField.getText();
        String string7 = this.timestampMilliSecondField.getText();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
            n4 = Integer.parseInt(string4);
            n5 = Integer.parseInt(string5);
            n6 = Integer.parseInt(string6);
            n7 = Integer.parseInt(string7);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n < 1 || n > 9999) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException("Illegal params.");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Environment.getLocale());
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        if (n3 > gregorianCalendar.getActualMaximum(5)) {
            throw new IllegalArgumentException("Illegal params.");
        }
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, n7);
        return gregorianCalendar.getTime().getTime();
    }

    static boolean parseDmsLatitudeString(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        string4 = stringTokenizer.nextToken();
        string5 = stringTokenizer.nextToken();
        if (string2.length() < 1 || string2.length() > 3) {
            return false;
        }
        if (string3.length() != 2 || string4.length() != 2 || string5.length() != 2) {
            return false;
        }
        switch (string2.charAt(0)) {
            case 'N': {
                bl = false;
                break;
            }
            case 'S': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            n = Integer.parseInt(string2.substring(1));
            if (bl) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n4 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            return false;
        }
        if (n < -90 || n > 90) {
            return false;
        }
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        if (n3 < 0 || n3 > 59) {
            return false;
        }
        if (n4 < 0 || n4 > 99) {
            return false;
        }
        return Math.abs(n) != 90 || n2 == 0 && n3 == 0 && n4 == 0;
    }

    private String parseDmsLatitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.latitudeCombo.getSelectedIndex();
        String string = ((String)this.latitudeCombo.getSelectedItem()).trim();
        String string2 = this.latitudeDegreeField.getText();
        String string3 = this.latitudeMinuteField.getText();
        String string4 = this.latitudeSecondField.getText();
        String string5 = this.latitudeCentiSecondField.getText();
        String string6 = null;
        try {
            n = Integer.parseInt(string2);
            if (n5 != 0) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n4 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -90 || n > 90) {
                bl = true;
            } else if (n2 < 0 || n2 > 59) {
                bl = true;
            } else if (n3 < 0 || n3 > 59) {
                bl = true;
            } else if (n4 < 0 || n4 > 99) {
                bl = true;
            } else if (Math.abs(n) == 90 && (n2 != 0 || n3 != 0 || n4 != 0)) {
                bl = true;
            } else {
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                if (string5.length() == 1) {
                    string5 = "0" + string5;
                }
                string6 = string + string2 + "." + string3 + "." + string4 + "." + string5;
            }
        }
        return string6;
    }

    static boolean parseDmsLongitudeString(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        string4 = stringTokenizer.nextToken();
        string5 = stringTokenizer.nextToken();
        if (string2.length() < 1 || string2.length() > 4) {
            return false;
        }
        if (string3.length() != 2 || string4.length() != 2 || string5.length() != 2) {
            return false;
        }
        switch (string2.charAt(0)) {
            case 'E': {
                bl = false;
                break;
            }
            case 'W': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            n = Integer.parseInt(string2.substring(1));
            if (bl) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n4 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            return false;
        }
        if (n < -180 || n >= 180) {
            return false;
        }
        if (n2 < 0 || n2 > 59) {
            return false;
        }
        if (n3 < 0 || n3 > 59) {
            return false;
        }
        if (n4 < 0 || n4 > 99) {
            return false;
        }
        return n != -180 || n2 == 0 && n3 == 0 && n4 == 0;
    }

    private String parseDmsLongitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.longitudeCombo.getSelectedIndex();
        String string = ((String)this.longitudeCombo.getSelectedItem()).trim();
        String string2 = this.longitudeDegreeField.getText();
        String string3 = this.longitudeMinuteField.getText();
        String string4 = this.longitudeSecondField.getText();
        String string5 = this.longitudeCentiSecondField.getText();
        String string6 = null;
        try {
            n = Integer.parseInt(string2);
            if (n5 != 0) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            n4 = Integer.parseInt(string5);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -180 || n >= 180) {
                bl = true;
            } else if (n2 < 0 || n2 > 59) {
                bl = true;
            } else if (n3 < 0 || n3 > 59) {
                bl = true;
            } else if (n4 < 0 || n4 > 99) {
                bl = true;
            } else if (n == -180 && (n2 != 0 || n3 != 0 || n4 != 0)) {
                bl = true;
            } else {
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                if (string5.length() == 1) {
                    string5 = "0" + string5;
                }
                string6 = string + string2 + "." + string3 + "." + string4 + "." + string5;
            }
        }
        return string6;
    }

    private String getDmsPart(String string, int n) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 3) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    string2 = string3.substring(0, 1);
                    break;
                }
                case 1: {
                    string2 = string3.substring(1);
                    break;
                }
                case 2: {
                    string2 = string4;
                    break;
                }
                case 3: {
                    string2 = string5;
                    break;
                }
                case 4: {
                    string2 = string6;
                }
            }
        }
        return string2;
    }

    void set() {
        if (this.saveLocationInfoFile()) {
            this.parent.closeWindow(this);
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }
}

