/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.Environment;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.LocationInfoWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class LocationSelectWindow
extends AbstractWindow {
    private final String TITLE_KEY = "title";
    private final String ENTRY_ID_KEY = "entry_id";
    private final String TIMESTAMP_KEY = "timestamp";
    private final String ACCURACY_LEVEL_KEY = "level";
    private final String LATITUDE_KEY = "latitude";
    private final String LONGITUDE_KEY = "longitude";
    private final String DATUM_KEY = "datum";
    private final String ACCURACY_LEVEL_1 = "2147483647";
    private final String ACCURACY_LEVEL_2 = "299";
    private final String ACCURACY_LEVEL_3 = "49";
    private MainWindow parent;
    private int launchType = -1;
    private JButton startButton;
    private JButton cancelButton;
    private String locationTitleID = null;
    private long locationInfoTimestamp = 0L;
    private int locationInfoLevel = 0;
    private String locationInfoLatitude = null;
    private String locationInfoLongitude = null;
    private int locationInfoDatum = 0;
    private boolean islocationImage = false;

    LocationSelectWindow(MainWindow mainWindow, int n) {
        super(mainWindow, "");
        if (n == 14) {
            this.islocationImage = true;
        }
        if (this.islocationImage) {
            this.setTitle(Resource.getString("LOCATION_IMAGE_SELECT_WINDOW_TITLE"));
        } else {
            this.setTitle(Resource.getString("LOCATION_SELECT_WINDOW_TITLE"));
        }
        this.parent = mainWindow;
        this.launchType = n;
        this.addWindowListener();
        this.init();
        this.loadLocationInfoFile();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Environment.getLocale());
        String string = simpleDateFormat.format(new Date(this.locationInfoTimestamp));
        JLabel jLabel = null;
        jLabel = this.islocationImage ? new JLabel(Resource.getString("LOCATION_IMAGE_ID") + " : ") : new JLabel(Resource.getString("LOCATION_INFO_TITLE") + " : ");
        JLabel jLabel2 = new JLabel(Resource.getString("LOCATION_INFO_TIMESTAMP") + " : ");
        JLabel jLabel3 = new JLabel(Resource.getString("GPS_ACCURACY_LEVEL") + " : ");
        JLabel jLabel4 = new JLabel(Resource.getString("GPS_LATITUDE") + " : ");
        JLabel jLabel5 = new JLabel(Resource.getString("GPS_LONGITUDE") + " : ");
        JLabel jLabel6 = new JLabel(Resource.getString("GPS_DATUM_TYPE") + " : ");
        JLabel jLabel7 = new JLabel(this.locationTitleID);
        JLabel jLabel8 = new JLabel(string);
        JLabel jLabel9 = new JLabel(String.valueOf(this.locationInfoLevel));
        JLabel jLabel10 = new JLabel(" " + this.locationInfoLatitude);
        JLabel jLabel11 = new JLabel(" " + this.locationInfoLongitude);
        JLabel jLabel12 = new JLabel(" " + Resource.getString("GPS_DATUM_WGS84"));
        this.startButton = new JButton(Resource.getString("LAUNCH_FROM_MINIWINDOW"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new GridLayout(6, 1));
        jPanel4.setLayout(new GridLayout(6, 1));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("LOCATION_INFO_CURRENT")));
        jPanel3.add(this.getFlowPanel(jLabel, 2));
        jPanel3.add(this.getFlowPanel(jLabel2, 2));
        jPanel3.add(this.getFlowPanel(jLabel3, 2));
        jPanel3.add(this.getFlowPanel(jLabel4, 2));
        jPanel3.add(this.getFlowPanel(jLabel5, 2));
        jPanel3.add(this.getFlowPanel(jLabel6, 2));
        jPanel4.add(this.getFlowPanel(jLabel7, 0));
        jPanel4.add(this.getFlowPanel(jLabel8, 0));
        jPanel4.add(this.getFlowPanel(jLabel9, 0));
        jPanel4.add(this.getFlowPanel(jLabel10, 0));
        jPanel4.add(this.getFlowPanel(jLabel11, 0));
        jPanel4.add(this.getFlowPanel(jLabel12, 0));
        jPanel5.add(this.startButton);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add("North", jPanel2);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.startButton.setActionCommand("start");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.startButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.pack();
    }

    private void init() {
        this.locationInfoTimestamp = System.currentTimeMillis();
        this.locationTitleID = this.islocationImage ? "0" : new Date(this.locationInfoTimestamp).toString();
        this.locationInfoLevel = 3;
        this.locationInfoLatitude = new String(" N0.00.00.00");
        this.locationInfoLongitude = new String(" E0.00.00.00");
        this.locationInfoDatum = 0;
    }

    private String getLocationInfoPath() {
        String string = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "location_information" + File.separator;
        string = this.islocationImage ? string + "location_image" : string + "location_information";
        return string;
    }

    private void loadLocationInfoFile() {
        File file = new File(this.getLocationInfoPath());
        BufferedReader bufferedReader = null;
        if (file.exists() && file.isFile()) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (string.startsWith("#") || (stringTokenizer = new StringTokenizer(string, ",")).countTokens() != 6) continue;
                    try {
                        this.locationTitleID = stringTokenizer.nextToken();
                        this.locationInfoTimestamp = Long.parseLong(stringTokenizer.nextToken());
                        this.locationInfoLevel = Integer.parseInt(stringTokenizer.nextToken());
                        if (this.locationInfoLevel < 1 || this.locationInfoLevel > 3) {
                            throw new IllegalArgumentException("Illegal value:level");
                        }
                        String string2 = stringTokenizer.nextToken();
                        if (!LocationInfoWindow.parseDmsLatitudeString(string2)) {
                            throw new IllegalArgumentException("Illegal value:latitude");
                        }
                        this.locationInfoLatitude = string2;
                        String string3 = stringTokenizer.nextToken();
                        if (!LocationInfoWindow.parseDmsLongitudeString(string3)) {
                            throw new IllegalArgumentException("Illegal value:longitude");
                        }
                        this.locationInfoLongitude = string3;
                        this.locationInfoDatum = Integer.parseInt(stringTokenizer.nextToken());
                        if (this.locationInfoDatum == 0) break;
                        throw new IllegalArgumentException("Illegal value:datum");
                    }
                    catch (Exception exception) {
                        this.init();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                this.init();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    void start() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.islocationImage) {
            hashtable.put("entry_id", this.locationTitleID);
        } else {
            hashtable.put("title", this.locationTitleID);
        }
        hashtable.put("timestamp", String.valueOf(this.locationInfoTimestamp));
        String string = null;
        switch (this.locationInfoLevel) {
            case 1: {
                string = "2147483647";
                break;
            }
            case 2: {
                string = "299";
                break;
            }
            case 3: {
                string = "49";
            }
        }
        hashtable.put("level", string);
        hashtable.put("latitude", this.locationInfoLatitude);
        hashtable.put("longitude", this.locationInfoLongitude);
        hashtable.put("datum", String.valueOf(this.locationInfoDatum));
        JOptionPane jOptionPane = new JOptionPane(Resource.getString("LOCATION_FIRST_WNG"), 3, 0);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        ((Component)jDialog).setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer && (Integer)object == 0) {
            try {
                JAMManager.invokeApplication(this.parent.getAdfPath(), this.parent.getJarPath(), this.launchType, JAMManager.getParams(hashtable), this.parent.getDeviceName(), this.parent.getAdfUrl(), this.parent.getProjectNameForBytes(), DebugTraceWindow.getDebugParam());
                this.parent.setEnabledDeviceMenu(false);
                this.parent.closeWindow(this);
            }
            catch (Exception exception) {
                this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
            }
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }
}

