/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MailAddressEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.MailFileManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class MailAddressWindow
extends AbstractWindow {
    private JList addressList = null;
    static final String DEFAULT_ADDRESS = "message_app_usr0@docomo.ne.jp";
    private JButton editAddressButton = null;
    private JButton newAddressButton = null;
    private JButton okButton = null;
    private JButton closeButton = null;
    MainWindow parent = null;

    MailAddressWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("ADDRESS_SETTING_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.editAddressButton = new JButton(Resource.getString("EDIT_MAIL"));
        this.newAddressButton = new JButton(Resource.getString("ADD"));
        this.okButton = new JButton(Resource.getString("SET"));
        this.closeButton = new JButton(Resource.getString("CANCEL"));
        this.addressList = new JList();
        this.addressList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.addressList);
        this.changeWindowState();
        this.editAddressButton.setActionCommand("editAddress");
        this.newAddressButton.setActionCommand("newAddress");
        this.okButton.setActionCommand("saveAddress");
        this.closeButton.setActionCommand("close");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.editAddressButton.addActionListener(actionDispatcher);
        this.newAddressButton.addActionListener(actionDispatcher);
        this.okButton.addActionListener(actionDispatcher);
        this.closeButton.addActionListener(actionDispatcher);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(this.newAddressButton);
        jPanel.add(this.editAddressButton);
        jPanel.add(this.okButton);
        jPanel.add(this.closeButton);
        container.setLayout(new BorderLayout());
        container.add("Center", jScrollPane);
        container.add("South", jPanel);
        this.setResizable(false);
        this.pack();
    }

    void newAddress() {
        MailAddressEditWindow mailAddressEditWindow = new MailAddressEditWindow(this.parent, null, false);
        this.parent.editMailAddress(mailAddressEditWindow);
        this.changeWindowState();
    }

    void editAddress() {
        String string = (String)this.addressList.getSelectedValue();
        String string2 = MailFileManager.getMyAddress();
        boolean bl = false;
        if (string == null) {
            return;
        }
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("NOT_ADDRESS_WNG"), this, 2);
            return;
        }
        if (string2 != null && string2.trim().equals(string.trim())) {
            bl = true;
        }
        MailAddressEditWindow mailAddressEditWindow = new MailAddressEditWindow(this.parent, string, bl);
        this.parent.editMailAddress(mailAddressEditWindow);
        this.changeWindowState();
    }

    void saveAddress() {
        String string = (String)this.addressList.getSelectedValue();
        boolean bl = false;
        if (string == null) {
            return;
        }
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("NOT_ADDRESS_WNG"), this, 2);
            return;
        }
        bl = MailFileManager.setMyAddress(string);
        if (!bl) {
            this.parent.showDialog(Resource.format("WRITE_ERR", Resource.getString("MY_ADDRESS")), this, 2);
            return;
        }
        this.dispose();
    }

    void close() {
        this.parent.closeWindow(this);
    }

    void changeWindowState() {
        String[] stringArray = null;
        String string = null;
        boolean bl = false;
        int n = 0;
        stringArray = MailFileManager.getMailAddresses();
        string = MailFileManager.getMyAddress();
        this.addressList.removeAll();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string != null && stringArray[n2].equals(string)) {
                n = n2;
                bl = true;
            }
            ++n2;
        }
        if (stringArray.length != 0) {
            if (!bl) {
                n = 0;
            }
            this.okButton.setEnabled(true);
            this.editAddressButton.setEnabled(true);
            this.addressList.setListData(stringArray);
            this.addressList.setSelectedIndex(n);
            this.addressList.ensureIndexIsVisible(n);
        } else {
            this.okButton.setEnabled(false);
            this.editAddressButton.setEnabled(false);
        }
        this.pack();
    }
}

