/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.MailEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.MailInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

class MailFileManager {
    static final String DEFAULT_MESSAGECODE = "0000000000";
    static final String SHORT_MAIL_STRING = "SMS";
    static final String BOUNDARY = "--B:P";
    static final String BOUNDARY_END = "--B:P--";
    static final int DEFAULT_RECEIVE_MAIL_NUM_MAX = 200;
    static final int DEFAULT_SENT_MAIL_NUM_MAX = 50;
    static final int MESSAGE_CODE_LENGTH = 10;
    private static final String MAIL_FILE_EXT = ".mail";
    private static final String RECEIVED_BOX_NAME = "received";
    private static final String SENT_BOX_NAME = "sent";
    private static final String UNSENT_BOX_NAME = "unsent";
    private static final String ADDRESS_FILE_NAME = "myAddress";
    private static final String STATE_FILE_NAME = "mail.state";
    private static final String XSTRING_FILE_NAME = "xstring.state";
    private static final String BODY_FILE_NAME = "boundary.data";
    private static final String SHORT_MAIL_ADDR_STRING = "(\uff7c\uff6e\uff70\uff84\uff92\uff70\uff99)";
    private static final int YEAR_COLUMN = 4;
    private static final int OTHER_COLUMN = 2;
    private static final String SUBJECT = "Subject:";
    private static final String TO = "To:";
    private static final String FROM = "From:";
    private static final String CC = "Cc:";
    private static final String BCC = "Bcc:";
    private static final String DATE = "Date:";
    private static final int MAIL_ID_COLUM = 3;
    private static final int MAIL_ID_MAX = 999;
    private static final String MAIL_STATE_SEPARATOR = "\t";
    private static final String MAIL_FILE_SEPARATOR = "_";
    private String mailAddress = null;
    private String messageCode;

    MailFileManager(String string, String string2) {
        this.mailAddress = string;
        this.messageCode = string2;
        this.messageCode = this.messageCode == null ? DEFAULT_MESSAGECODE : this.messageCode.toLowerCase();
        if (this.mailAddress == null) {
            this.mailAddress = "message_app_usr0@docomo.ne.jp";
        }
    }

    private String getMailFolderPath(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = MailFileManager.getMailBoxPath() + File.separator + this.mailAddress + File.separator + RECEIVED_BOX_NAME;
                break;
            }
            case 1: {
                string = MailFileManager.getMailBoxPath() + File.separator + this.mailAddress + File.separator + SENT_BOX_NAME;
                break;
            }
            case 2: {
                string = MailFileManager.getMailBoxPath() + File.separator + this.mailAddress + File.separator + UNSENT_BOX_NAME;
                break;
            }
            default: {
                return null;
            }
        }
        return string;
    }

    private String getAppliFolderPath(int n) {
        String string = null;
        String string2 = this.messageCode;
        string = this.getMailFolderPath(n);
        File file = new File(string = string + File.separator + string2);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdir();
        }
        return string;
    }

    Vector getMails(int n) {
        File[] fileArray = new File(this.getAppliFolderPath(n)).listFiles();
        Vector<MailInfo> vector = new Vector<MailInfo>();
        try {
            int n2 = fileArray.length - 1;
            while (n2 >= 0) {
                String string = "";
                String string2 = "";
                String string3 = "";
                boolean bl = false;
                if (fileArray[n2].isFile() && fileArray[n2].getName().endsWith(MAIL_FILE_EXT) && this.getMailId(fileArray[n2].getName()) != -1) {
                    MailInfo mailInfo = new MailInfo(fileArray[n2], n);
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[n2]));
                    mailInfo.setDate(this.getMailDate(fileArray[n2].getName()));
                    if (n == 0) {
                        mailInfo.setState(this.getMailState(fileArray[n2].getName(), this.getStateFilePath(0)));
                    }
                    bl = false;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith(CC) || string.startsWith(BCC) || string.startsWith(DATE)) continue;
                        if (string.startsWith(SUBJECT)) {
                            mailInfo.setSubjectHeader(string.substring(string.indexOf(":") + 1));
                            bl = true;
                            continue;
                        }
                        if (string.startsWith(TO)) {
                            mailInfo.setToHeader(string.substring(string.indexOf(":") + 1));
                            continue;
                        }
                        if (string.startsWith(FROM)) {
                            mailInfo.setFromHeader(string.substring(string.indexOf(":") + 1));
                            continue;
                        }
                        if (string.equals(BOUNDARY)) {
                            string3 = string;
                            break;
                        }
                        string2 = string;
                        break;
                    }
                    if (string3.length() == 0) {
                        while ((string = bufferedReader.readLine()) != null) {
                            if (BOUNDARY.equals(string)) {
                                string3 = string;
                                break;
                            }
                            string2 = string2 + "\n" + string;
                        }
                    }
                    if (!string2.equals("")) {
                        mailInfo.setMessage(string2);
                    }
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith(BOUNDARY_END)) {
                            string3 = string3 + "\n" + string;
                            break;
                        }
                        string3 = string3 + "\n" + string;
                    }
                    if (string3.trim().length() != 0) {
                        mailInfo.setBoundary(string3);
                        if (n != 0) {
                            int n3 = this.getMailState(mailInfo.getMailPath().getName(), this.getStateFilePath(n));
                            mailInfo.setRecipientState(n3);
                        }
                    } else {
                        if (n != 0) {
                            mailInfo.setRecipientState(2);
                        }
                        if (!bl) {
                            mailInfo.setSubjectHeader(mailInfo.getToHeader());
                            mailInfo.setToHeader(SHORT_MAIL_STRING);
                        }
                    }
                    vector.addElement(mailInfo);
                    bufferedReader.close();
                }
                --n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    String getMailDate(String string) {
        String string2 = this.getDateString(string);
        StringTokenizer stringTokenizer = null;
        String string3 = "";
        stringTokenizer = new StringTokenizer(string2, MAIL_FILE_SEPARATOR);
        try {
            string3 = string3 + stringTokenizer.nextToken() + "/";
            string3 = string3 + stringTokenizer.nextToken() + "/";
            string3 = string3 + stringTokenizer.nextToken() + " ";
            string3 = string3 + stringTokenizer.nextToken() + ":";
            string3 = string3 + stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        return string3;
    }

    int getMailId(String string) {
        String string2 = this.getDateString(string);
        StringTokenizer stringTokenizer = null;
        int n = -1;
        if (string2 == null) {
            return -1;
        }
        stringTokenizer = new StringTokenizer(string2, MAIL_FILE_SEPARATOR);
        try {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            return -1;
        }
        return n;
    }

    private int getMailState(String string, File file) {
        BufferedReader bufferedReader = null;
        String string2 = null;
        String string3 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.startsWith(string)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, MAIL_STATE_SEPARATOR);
                stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                break;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return -1;
        }
        if (string3 == null) {
            return -1;
        }
        return Integer.parseInt(string3);
    }

    void changeMailState(File file, File file2, int n, boolean bl) {
        Object object;
        Object object2;
        String string = file.getName();
        Vector<Object> vector = new Vector<Object>();
        try {
            object2 = null;
            object = new BufferedReader(new FileReader(file2));
            while ((object2 = ((BufferedReader)object).readLine()) != null) {
                if (((String)object2).startsWith(string)) continue;
                vector.addElement(object2);
            }
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object2 = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
            object = vector.elements();
            while (object.hasMoreElements()) {
                ((PrintWriter)object2).println(object.nextElement());
            }
            if (!bl) {
                ((PrintWriter)object2).println(string + MAIL_STATE_SEPARATOR + n);
            }
            ((PrintWriter)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean saveMail(MailInfo mailInfo, String string, int n, int n2) {
        Object object;
        Object object2;
        String string2 = mailInfo.getDate();
        if (mailInfo.getMailPath() != null) {
            object2 = this.getMailDate(mailInfo.getMailPath().getName());
            if (!string2.equals(object2)) {
                object = mailInfo.getMailPath();
                String string3 = this.generateFileName(mailInfo);
                if (string3 == null) {
                    return false;
                }
                File file = new File(this.getAppliFolderPath(mailInfo.getMailType()) + File.separator + string3);
                File file2 = this.getStateFilePath(mailInfo.getMailType());
                this.changeMailState((File)object, file2, -1, true);
                ((File)object).renameTo(file);
                mailInfo.setMailPath(file);
            }
        } else {
            object2 = this.generateFileName(mailInfo);
            if (object2 == null) {
                return false;
            }
            object = new File(this.getAppliFolderPath(mailInfo.getMailType()) + File.separator + (String)object2);
            mailInfo.setMailPath((File)object);
        }
        try {
            object2 = new FileWriter(mailInfo.getMailPath());
            object = new PrintWriter(new BufferedWriter((Writer)object2));
            if (mailInfo.getMailType() == 0) {
                ((PrintWriter)object).println(TO + mailInfo.getToHeader());
            } else if (mailInfo.getToHeader() == null) {
                ((PrintWriter)object).println(TO + mailInfo.getToHeader());
            } else if (mailInfo.getBoundary() == null && mailInfo.getToHeader().trim().equals(SHORT_MAIL_STRING) && mailInfo.getRecipientState() == 2) {
                ((PrintWriter)object).println(TO + mailInfo.getSubjectHeader());
            } else {
                ((PrintWriter)object).println(TO + mailInfo.getToHeader());
            }
            ((PrintWriter)object).println(FROM + mailInfo.getFromHeader());
            ((PrintWriter)object).println(DATE + mailInfo.getDate());
            if (mailInfo.getMailType() == 0) {
                ((PrintWriter)object).println(SUBJECT + mailInfo.getSubjectHeader());
            } else if (mailInfo.getToHeader() == null) {
                ((PrintWriter)object).println(SUBJECT + mailInfo.getSubjectHeader());
            } else if (mailInfo.getBoundary() != null || !mailInfo.getToHeader().trim().equals(SHORT_MAIL_STRING) || mailInfo.getRecipientState() != 2) {
                ((PrintWriter)object).println(SUBJECT + mailInfo.getSubjectHeader());
            }
            ((PrintWriter)object).print(mailInfo.getMessage());
            if (mailInfo.getBoundary() != null) {
                ((PrintWriter)object).print("\n" + mailInfo.getBoundary());
            }
            ((PrintWriter)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        object2 = this.getStateFilePath(mailInfo.getMailType());
        if (mailInfo.getMailType() == 0) {
            this.changeMailState(mailInfo.getMailPath(), (File)object2, mailInfo.getState(), false);
        } else {
            this.changeMailState(mailInfo.getMailPath(), (File)object2, mailInfo.getRecipientState(), false);
        }
        return true;
    }

    int getMailNum(int n) {
        int n2 = 0;
        File file = new File(this.getAppliFolderPath(n));
        File[] fileArray = file.listFiles();
        int n3 = 0;
        while (n3 < fileArray.length) {
            if (fileArray[n3].isFile() && fileArray[n3].getName().endsWith(MAIL_FILE_EXT)) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private String getDateString(String string) {
        String string2 = null;
        try {
            string2 = string.substring(0, string.length() - MAIL_FILE_EXT.length());
        }
        catch (Exception exception) {
            return null;
        }
        return string2;
    }

    private String generateFileName(MailInfo mailInfo) {
        boolean bl = false;
        String string = "";
        int[] nArray = this.getIdArray(mailInfo.getMailType());
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(mailInfo.getDate(), "/ :");
        string = string + stringTokenizer.nextToken() + MAIL_FILE_SEPARATOR;
        string = string + stringTokenizer.nextToken() + MAIL_FILE_SEPARATOR;
        string = string + stringTokenizer.nextToken() + MAIL_FILE_SEPARATOR;
        string = string + stringTokenizer.nextToken() + MAIL_FILE_SEPARATOR;
        string = string + stringTokenizer.nextToken() + MAIL_FILE_SEPARATOR;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] > n) {
                n = nArray[n3];
            }
            ++n3;
        }
        n2 = n >= 999 ? 0 : n;
        int n4 = 0;
        while (n4 < 999) {
            bl2 = false;
            int n5 = 0;
            while (n5 < nArray.length) {
                if (n2 == nArray[n5]) {
                    bl2 = true;
                    break;
                }
                ++n5;
            }
            if (!bl2) break;
            ++n2;
            ++n4;
        }
        string = string + MailEditWindow.intToString(n2, 3);
        string = string + MAIL_FILE_EXT;
        return string;
    }

    private int[] getIdArray(int n) {
        File[] fileArray = new File(this.getAppliFolderPath(n)).listFiles();
        int[] nArray = new int[fileArray.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < fileArray.length) {
            n2 = this.getMailId(fileArray[n4].getName());
            if (n2 >= 0 && n2 <= 999) {
                nArray[n3] = n2;
                ++n3;
            }
            ++n4;
        }
        int[] nArray2 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray2[n5] = nArray[n5];
            ++n5;
        }
        return nArray2;
    }

    String getBinaryData() {
        String string = null;
        String string2 = "";
        File file = new File(MailFileManager.getMailBoxPath() + File.separator + BODY_FILE_NAME);
        boolean bl = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return "";
        }
        return string2;
    }

    File getStateFilePath(int n) {
        File file = null;
        if (n == 0) {
            file = new File(this.getAppliFolderPath(0) + File.separator + STATE_FILE_NAME);
        } else if (n == 1) {
            file = new File(this.getAppliFolderPath(1) + File.separator + XSTRING_FILE_NAME);
        } else if (n == 2) {
            file = new File(this.getAppliFolderPath(2) + File.separator + XSTRING_FILE_NAME);
        }
        return file;
    }

    boolean createMessageBox() {
        File file = null;
        try {
            file = new File(this.getAppliFolderPath(0));
            if (!file.isDirectory() && !file.mkdirs()) {
                return false;
            }
            file = new File(this.getAppliFolderPath(1));
            if (!file.isDirectory() && !file.mkdirs()) {
                return false;
            }
            file = new File(this.getAppliFolderPath(2));
            if (!file.isDirectory() && !file.mkdirs()) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    boolean checkMessageCode() {
        char[] cArray = null;
        if (this.messageCode == null) {
            return false;
        }
        if (this.messageCode.length() != 10) {
            return false;
        }
        cArray = this.messageCode.toCharArray();
        if (cArray.length != 10) {
            return false;
        }
        int n = 0;
        while (n < cArray.length) {
            if (!(cArray[n] >= 'a' && cArray[n] <= 'z' || cArray[n] >= '0' && cArray[n] <= '9')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static boolean addAddress(String string) {
        File file = null;
        boolean bl = false;
        if (string == null) {
            return false;
        }
        file = new File(MailFileManager.getMailBoxPath() + File.separator + string);
        if (file.isDirectory()) {
            return false;
        }
        try {
            bl = file.mkdir();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    static boolean removeAddress(String string) {
        File file = null;
        boolean bl = false;
        if (string == null) {
            bl = true;
        } else {
            file = new File(MailFileManager.getMailBoxPath() + File.separator + string);
            if (file.isDirectory()) {
                try {
                    bl = file.delete();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bl = false;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    static boolean renameAddress(String string, String string2) {
        File file = null;
        File file2 = null;
        boolean bl = false;
        if (string == null || string2 == null) {
            return false;
        }
        file = new File(MailFileManager.getMailBoxPath() + File.separator + string);
        file2 = new File(MailFileManager.getMailBoxPath() + File.separator + string2);
        if (!file.isDirectory()) {
            return false;
        }
        if (file2.isDirectory()) {
            return false;
        }
        try {
            bl = file.renameTo(file2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    static boolean addressExists(String string) {
        File file = null;
        if (string == null) {
            return false;
        }
        file = new File(MailFileManager.getMailBoxPath() + File.separator + string);
        return file.isDirectory();
    }

    static String getShortMailAddress(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf(SHORT_MAIL_ADDR_STRING) != -1) {
            return string.substring(0, string.indexOf(SHORT_MAIL_ADDR_STRING));
        }
        return string;
    }

    private static String getMailBoxPath() {
        return System.getProperty("emu.home") + File.separator + "lib" + File.separator + "mail";
    }

    static String[] getMailAddresses() {
        String[] stringArray;
        File file = new File(MailFileManager.getMailBoxPath());
        File[] fileArray = null;
        Vector<String> vector = new Vector<String>();
        if (!file.exists()) {
            return null;
        }
        fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory() && (stringArray = fileArray[n].getName().trim()).length() != 0 && stringArray.length() <= 50 && MailEditWindow.checkASCIICharacters((String)stringArray) && stringArray.indexOf(32) < 0 && stringArray.indexOf(44) < 0 && stringArray.length() == fileArray[n].getName().length()) {
                vector.addElement(fileArray[n].getName());
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    static String getMyAddress() {
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            String string2 = null;
            bufferedReader = new BufferedReader(new FileReader(MailFileManager.getMailBoxPath() + File.separator + ADDRESS_FILE_NAME));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().length() == 0) continue;
                string = string2.trim();
                break;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    static boolean setMyAddress(String string) {
        if (string == null) {
            return false;
        }
        File file = null;
        try {
            file = new File(MailFileManager.getMailBoxPath() + File.separator + ADDRESS_FILE_NAME);
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(fileWriter));
            printWriter.print(string);
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }
}

