/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MailEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.MailFileManager;
import com.nttdocomo.dojaemu.ktoolbar.MailInfo;
import com.nttdocomo.dojaemu.ktoolbar.MailTableCellRenderer;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

class MailSettingWindow
extends AbstractWindow
implements ItemListener {
    static final int FRAME_WIDTH = 600;
    static final int FRAME_HEIGHT = 300;
    private final int TEXT_AREA_WIDTH = 580;
    private final int TEXT_AREA_HEIGHT = 240;
    private final int COLUMN_NUM = 4;
    private final int INITIAL_ROWHEIGHT = 20;
    private final int STATE_COLUMN_WIDTH = 35;
    private final int DATE_COLUMN_WIDTH = 110;
    private JComboBox mailBoxList = null;
    private JTable tableView = null;
    private String mailAddress = null;
    private Vector mailBox = new Vector();
    private JButton editMailButton = null;
    private int mailBoxState = 0;
    private String messageCode = null;
    private int receivedNum = 0;
    private int sentNum = 0;
    static /* synthetic */ Class class$java$lang$Object;

    MailSettingWindow(MainWindow mainWindow, String string, String string2, int n, int n2) {
        super(mainWindow, Resource.getString("MAIL_TABLE"));
        this.addWindowListener();
        this.mailAddress = string;
        this.messageCode = string2;
        this.receivedNum = n;
        this.sentNum = n2;
        if (this.receivedNum == 0) {
            this.receivedNum = 200;
        }
        if (this.sentNum == 0) {
            this.sentNum = 50;
        }
        this.mailBoxList = this.getMailBoxes();
        this.mailBoxList.addItemListener(this);
        this.editMailButton = new JButton(Resource.getString("EDIT_MAIL"));
        JButton jButton = new JButton(Resource.getString("ADD"));
        JButton jButton2 = new JButton(Resource.getString("CLOSE"));
        this.tableView = new JTable();
        this.changeWindowState();
        JScrollPane jScrollPane = new JScrollPane(this.tableView);
        this.editMailButton.setActionCommand("editMail");
        jButton.setActionCommand("newMail");
        jButton2.setActionCommand("close");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.editMailButton.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.mailBoxList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(jButton);
        jPanel2.add(this.editMailButton);
        jPanel2.add(jButton2);
        container.setLayout(new BorderLayout());
        container.add("North", jPanel);
        container.add("Center", jScrollPane);
        container.add("South", jPanel2);
        this.setResizable(false);
        ((Component)this).setSize(600, 300);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent != null) {
            this.mailBoxState = this.mailBoxList.getSelectedIndex();
        }
        this.changeWindowState();
    }

    void newMail() {
        boolean bl = true;
        MailFileManager mailFileManager = new MailFileManager(this.mailAddress, this.messageCode);
        if (this.mailBoxState == 0) {
            if (mailFileManager.getMailNum(0) >= this.receivedNum) {
                bl = false;
            }
        } else if (mailFileManager.getMailNum(1) + mailFileManager.getMailNum(2) >= this.sentNum) {
            bl = false;
        }
        if (!bl) {
            this.parent.showDialog(Resource.getString("ADD_MAIL_ERR"), this, 2);
            return;
        }
        try {
            MailEditWindow mailEditWindow = new MailEditWindow(this.parent, this.mailAddress, this.mailBoxState, this.messageCode, this.receivedNum, this.sentNum, this.getWindowTitle());
            this.parent.editMail(mailEditWindow);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.changeWindowState();
    }

    void editMail() {
        int n = this.tableView.getSelectedRow();
        if (n == -1) {
            return;
        }
        try {
            MailInfo mailInfo = (MailInfo)this.mailBox.elementAt(n);
            MailEditWindow mailEditWindow = new MailEditWindow(this.parent, mailInfo, this.mailAddress, this.mailBoxState, this.messageCode, this.receivedNum, this.sentNum, this.getWindowTitle());
            this.parent.editMail(mailEditWindow);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.changeWindowState();
    }

    void close() {
        this.parent.closeWindow(this);
    }

    private JComboBox getMailBoxes() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(Resource.getString("RECEIVED_BOX"));
        jComboBox.addItem(Resource.getString("SENT_BOX"));
        jComboBox.addItem(Resource.getString("UNSENT_BOX"));
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    private void setEnabledButtons(boolean bl) {
        this.editMailButton.setEnabled(bl);
    }

    private TableModel getMailListTable() {
        Object object;
        String string = Resource.getString("TO");
        String string2 = Resource.getString("SEND_DATE");
        MailFileManager mailFileManager = new MailFileManager(this.mailAddress, this.messageCode);
        if (this.mailBoxState == 0) {
            string = Resource.getString("FROM");
            string2 = Resource.getString("RECEIVE_DATE");
        }
        final String[] stringArray = new String[]{Resource.getString("MAIL_STATE"), string2, string, Resource.getString("SUBJECT")};
        this.mailBox = mailFileManager.getMails(this.mailBoxState);
        final Object[][] objectArray = new Object[this.mailBox.size()][4];
        int n = 0;
        while (n < this.mailBox.size()) {
            object = null;
            String string3 = "";
            if (this.mailBoxState == 0) {
                object = ((MailInfo)this.mailBox.elementAt(n)).getFromHeader();
                string3 = this.getStateString(((MailInfo)this.mailBox.elementAt(n)).getState());
            } else {
                object = MailEditWindow.getAddressString(((MailInfo)this.mailBox.elementAt(n)).getToHeader());
            }
            objectArray[n] = new Object[]{string3, ((MailInfo)this.mailBox.elementAt(n)).getDate(), object, ((MailInfo)this.mailBox.elementAt(n)).getSubjectHeader()};
            ++n;
        }
        object = new AbstractTableModel(){

            public int getColumnCount() {
                return stringArray.length;
            }

            public int getRowCount() {
                return objectArray.length;
            }

            public Object getValueAt(int n, int n2) {
                return objectArray[n][n2];
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
                objectArray[n][n2] = object;
            }
        };
        return object;
    }

    void changeWindowState() {
        this.tableView.setModel(this.getMailListTable());
        this.tableView.setSelectionMode(0);
        this.tableView.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = MailSettingWindow.class$("java.lang.Object")) : class$java$lang$Object, new MailTableCellRenderer());
        this.tableView.setRowHeight(20);
        this.tableView.getColumnModel().getColumn(0).setMinWidth(35);
        this.tableView.getColumnModel().getColumn(0).setMaxWidth(35);
        this.tableView.getColumnModel().getColumn(1).setMinWidth(110);
        this.tableView.getColumnModel().getColumn(1).setMaxWidth(110);
        this.tableView.getTableHeader().setReorderingAllowed(false);
        this.tableView.getTableHeader().setResizingAllowed(false);
        if (this.tableView.getRowCount() != 0) {
            this.setEnabledButtons(true);
        } else {
            this.setEnabledButtons(false);
        }
    }

    private String getWindowTitle() {
        String string = null;
        switch (this.mailBoxState) {
            case 0: {
                string = Resource.getString("MAIL_EDIT") + "(" + Resource.getString("RECEIVED_BOX") + ")";
                break;
            }
            case 1: {
                string = Resource.getString("MAIL_EDIT") + "(" + Resource.getString("SENT_BOX") + ")";
                break;
            }
            case 2: {
                string = Resource.getString("MAIL_EDIT") + "(" + Resource.getString("UNSENT_BOX") + ")";
                break;
            }
        }
        return string;
    }

    private String getStateString(int n) {
        String string = "";
        if (n == 1) {
            string = Resource.getString("ALREADY_READ_SHORT");
        } else if (n == 0) {
            string = Resource.getString("NOT_READ_YET_SHORT");
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

