/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.Environment;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SDF;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

class NewWindow
extends AbstractWindow {
    private JTextField projectNameField;
    private JLabel projectPathLabel;
    private static String projectHome;

    NewWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("NEW_WINDOW_TITLE"));
        this.addWindowListener();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("PROJECT_HOME"));
        this.projectPathLabel = new JLabel(mainWindow.getProjectHome());
        JButton jButton = new JButton(Resource.getString("FILE_SELECT"));
        jButton.setMnemonic(82);
        JLabel jLabel2 = new JLabel(" ");
        JLabel jLabel3 = new JLabel(Resource.getString("PROJECT_NAME"));
        this.projectNameField = new JTextField(25);
        JButton jButton2 = new JButton(Resource.getString("MAKE"));
        JButton jButton3 = new JButton(Resource.getString("CANCEL"));
        this.projectNameField.setActionCommand("make");
        jButton.setActionCommand("select");
        jButton2.setActionCommand("make");
        jButton3.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.projectNameField.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 0));
        jPanel4.setLayout(new BorderLayout(3, 0));
        jPanel2.setLayout(new FlowLayout(0));
        JSeparator jSeparator = new JSeparator(0);
        jPanel3.setLayout(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(jButton);
        jPanel.add("North", jPanel2);
        jPanel.add("West", jLabel2);
        jPanel.add("Center", this.projectPathLabel);
        jPanel3.add(jLabel3);
        jPanel3.add(this.projectNameField);
        jPanel4.add("North", jSeparator);
        jPanel4.add("Center", jPanel3);
        jPanel5.add(jButton2);
        jPanel5.add(jButton3);
        container.add("North", jPanel);
        container.add("Center", jPanel4);
        container.add("South", jPanel5);
        projectHome = mainWindow.getProjectHome();
        this.pack();
    }

    void make() {
        String string = this.projectNameField.getText();
        this.parent.setProjectHome(projectHome);
        if (string.equals("")) {
            this.parent.showDialog(Resource.getString("PROJECT_NAME_WNG"), this, 2);
            return;
        }
        if (this.parent.checkProjectExists(string)) {
            this.parent.showDialog(Resource.format("EXIST_PROJECT_WNG", string), this, 2);
            return;
        }
        this.parent.clearOutputText();
        System.out.println(Resource.format("MAKE_PROJECT", string));
        Setting setting = new Setting();
        setting.setProperty("adfUrl", "");
        setting.setProperty("launchType", String.valueOf(0));
        setting.setProperty("sentMailMax", "50");
        setting.setProperty("receivedMailMax", "200");
        setting.setProperty("phoneBookEntry", "10");
        setting.setProperty("groupEntry", "10");
        setting.setProperty("bookmarkEntry", "10");
        setting.setProperty("launchTime", "1@1999/11//9/9/9;4@//2//2/2;;;");
        setting.setProperty("launchTimeMax", "4");
        setting.setProperty("useChat", "false");
        if (this.parent.saveProjectSetting(string, setting) < 0) {
            System.err.println(Resource.getString("MAKE_PROJECT_ERR"));
            this.parent.closeWindow(this);
            return;
        }
        ADF aDF = new ADF();
        aDF.setProperty("PackageURL", string + ".jar");
        aDF.setProperty("LastModified", this.getDate());
        if (this.parent.saveProject(string, aDF) < 0) {
            System.err.println(Resource.getString("MAKE_PROJECT_ERR"));
            this.parent.closeWindow(this);
            return;
        }
        SDF sDF = new SDF();
        sDF.setProperty("Sts", "0");
        String string2 = aDF.getProperty("PackageURL");
        sDF.setProperty("PackageURL", string2);
        sDF.parseSDF(aDF);
        if (this.parent.saveSdf(string, sDF) < 0) {
            System.err.println(Resource.getString("MAKE_PROJECT_ERR"));
            this.parent.closeWindow(this);
            return;
        }
        this.parent.setProject(string, aDF, sDF);
        String string3 = this.parent.getProjectPath(string) + File.separator + "src";
        String string4 = this.parent.getProjectPath(string) + File.separator + "res";
        String string5 = this.parent.getProjectPath(string) + File.separator + "sp";
        File file = new File(string3);
        File file2 = new File(string4);
        File file3 = new File(string5);
        file.mkdirs();
        file2.mkdirs();
        file3.mkdirs();
        System.out.println(Resource.getString("FINISH_MAKE_PROJECT"));
        System.out.println(Resource.format("SRC_LOCATION", string3));
        System.out.println(Resource.format("RESOURCE_LOCATION", string4));
        System.out.println(Resource.format("SP_LOCATION", string5));
        this.parent.closeWindow(this);
    }

    void select() {
        JFileChooser jFileChooser = new JFileChooser(projectHome);
        jFileChooser.setDialogTitle(Resource.getString("PROJECT_HOME_DIALOG"));
        jFileChooser.setDialogType(2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(null);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            projectHome = jFileChooser.getSelectedFile().getAbsolutePath();
            this.projectPathLabel.setText(projectHome);
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private String getDate() {
        int n = 60000;
        int n2 = 60 * n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Environment.getLocale());
        String string = simpleDateFormat.format(new Date());
        return string;
    }
}

