/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class ParameterWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 130;
    private MainWindow parent;
    private Container cp;
    private JTextField parameterTextField;
    private Setting projectSetting;
    private Setting setting;

    ParameterWindow(MainWindow mainWindow, Setting setting, Setting setting2) {
        super(mainWindow, Resource.getString("PARAMETER_SETTING_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.cp = this.getContentPane();
        this.cp.setLayout(new BorderLayout());
        this.setting = setting;
        if (setting2 == null) {
            setting2 = new Setting();
            setting2.setProperty("remoteParameter", "");
        } else {
            this.projectSetting = setting2;
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("PARAM_LABEL"));
        jLabel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel);
        this.parameterTextField = new JTextField(30);
        this.parameterTextField.setLayout(new FlowLayout(2));
        jPanel.add(this.parameterTextField);
        jPanel.setBorder(new TitledBorder(Resource.getString("PARAM_SET_TITLE")));
        JButton jButton = new JButton(Resource.getString("SET_UP"));
        JButton jButton2 = new JButton(Resource.getString("CLOSE"));
        jButton.setActionCommand("setup");
        jButton2.setActionCommand("close");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        ((Container)jButton).setLayout(new FlowLayout(2));
        ((Container)jButton2).setLayout(new FlowLayout(2));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.cp.add("North", jPanel);
        this.cp.add("South", jPanel2);
        this.setResizable(false);
        ((Component)this).setSize(480, 130);
    }

    void setup() {
        String string = this.parameterTextField.getText();
        if (string.indexOf(",") != -1 || string.indexOf("\"") != -1 || string.indexOf("\r") != -1 || string.indexOf("\n") != -1) {
            String string2 = Resource.getString("PARAM_CHAR_WNG");
            if (this.showDialogParam(string2) == 0) {
                return;
            }
            this.parent.closeWindow(this);
        } else {
            try {
                byte[] byArray = string.getBytes("Shift_JIS");
                if (byArray.length > 255) {
                    String string3 = Resource.getString("PARAM_OVER_WNG");
                    if (this.showDialogParam(string3) == 0) {
                        return;
                    }
                    this.parent.closeWindow(this);
                } else {
                    Date date = new Date();
                    long l = date.getTime();
                    this.projectSetting.setProperty("remotePushedTime", String.valueOf(l));
                    this.projectSetting.setProperty("remoteParameter", string);
                    this.parent.saveRemoteProjectSetting(this.projectSetting);
                    this.parent.closeWindow(this);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    void close() {
        this.parent.closeWindow(this);
    }

    private int showDialogParam(String string) {
        Object[] objectArray = new Object[]{Resource.getString("RETRY"), Resource.getString("CLOSE")};
        JOptionPane jOptionPane = new JOptionPane(string, 2, 2, null, objectArray);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("WNG"));
        jDialog.setResizable(false);
        ((Component)jDialog).setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object.toString().equals(objectArray[1].toString())) {
            return 2;
        }
        return 0;
    }
}

