/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhoneBookEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class PhoneBookWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private static String[] phoneBookFiles;
    private JTable phoneBookTable;
    private Hashtable phoneBookHash;
    private Hashtable columnIndexHash;
    private MainWindow parent;
    private int next;
    private JScrollPane scrollpane;
    private Container cp;
    private static final File phoneBookDir;
    static /* synthetic */ Class class$java$lang$Object;

    PhoneBookWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("PHONEBOOK_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.cp = this.getContentPane();
        this.cp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(Resource.getString("ADD"));
        JButton jButton2 = new JButton(Resource.getString("EDIT"));
        JButton jButton3 = new JButton(Resource.getString("CLOSE"));
        jButton.setActionCommand("add");
        jButton2.setActionCommand("edit");
        jButton3.setActionCommand("close");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        this.phoneBookTable = this.createPhoneBookTable();
        this.scrollpane = new JScrollPane(this.phoneBookTable);
        this.cp.add("Center", this.scrollpane);
        this.cp.add("South", jPanel2);
        this.setResizable(true);
        ((Component)this).setSize(480, 200);
    }

    private JTable createPhoneBookTable() {
        Object object;
        String[] stringArray;
        String string = "";
        phoneBookFiles = phoneBookDir.list(new PhoneBookFilter());
        String[] stringArray2 = new String[phoneBookFiles.length];
        this.phoneBookHash = new Hashtable();
        int n = 0;
        while (n < phoneBookFiles.length) {
            block9: {
                int n2;
                stringArray = phoneBookDir.getPath() + File.separator + phoneBookFiles[n];
                int n3 = phoneBookFiles[n].indexOf(95);
                try {
                    n2 = Integer.parseInt(phoneBookFiles[n].substring(0, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    break block9;
                }
                if (n2 >= this.next) {
                    this.next = n2;
                }
                try {
                    object = new PhoneBookEntry();
                    ((PhoneBookEntry)object).load((String)stringArray);
                    this.phoneBookHash.put(((PhoneBookEntry)object).getMemoryNo().toString(), object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(Resource.format("NOT_FOUND_ERR", (Object)stringArray));
                }
                catch (IOException iOException) {
                    System.err.println(Resource.format("READ_ERR", (Object)stringArray));
                }
            }
            ++n;
        }
        ++this.next;
        stringArray = new String[]{Resource.getString("PHONEBOOK_NAME"), Resource.getString("PHONEBOOK_KANA"), Resource.getString("PHONEBOOK_GROUP_ID")};
        PhoneBookTableModel phoneBookTableModel = new PhoneBookTableModel(stringArray, 0);
        this.columnIndexHash = new Hashtable();
        object = this.phoneBookHash.elements();
        while (object.hasMoreElements()) {
            PhoneBookEntry phoneBookEntry = null;
            Object e = object.nextElement();
            if (e instanceof PhoneBookEntry) {
                phoneBookEntry = (PhoneBookEntry)e;
            }
            Vector<String> vector = new Vector<String>();
            vector.addElement(phoneBookEntry.getFamilyName() + phoneBookEntry.getGivenName());
            vector.addElement(phoneBookEntry.getFamilyKana() + phoneBookEntry.getGivenKana());
            vector.addElement(phoneBookEntry.getGroupID());
            vector.addElement(phoneBookEntry.getMemoryNo());
            phoneBookTableModel.addRow(vector);
            this.columnIndexHash.put(new Integer(phoneBookTableModel.getRowCount()), phoneBookEntry.getMemoryNo());
        }
        JTable jTable = new JTable(phoneBookTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PhoneBookWindow.class$("java.lang.Object")) : class$java$lang$Object, new PhoneBookTableCellRenderer());
        jTable.setSelectionMode(0);
        return jTable;
    }

    void add() {
        PhoneBookEntry phoneBookEntry = new PhoneBookEntry();
        phoneBookEntry.setMemoryNo(new Integer(this.next).toString());
        this.parent.pbe(phoneBookEntry, "PHONEBOOK_ENTRY_WINDOW_TITLE");
        ((Component)this).setVisible(false);
        this.cp.remove(this.scrollpane);
        this.scrollpane = null;
        this.phoneBookTable = null;
        this.phoneBookTable = this.createPhoneBookTable();
        this.scrollpane = new JScrollPane(this.phoneBookTable);
        this.cp.add("Center", this.scrollpane);
        ((Component)this).setVisible(true);
    }

    void edit() {
        Object v = this.columnIndexHash.get(new Integer(this.phoneBookTable.getSelectedRow() + 1));
        String string = "";
        if (v != null) {
            if (v instanceof String) {
                string = (String)v;
            }
            Object v2 = this.phoneBookHash.get(string);
            PhoneBookEntry phoneBookEntry = null;
            if (v2 instanceof PhoneBookEntry) {
                phoneBookEntry = (PhoneBookEntry)v2;
            }
            this.parent.pbe(phoneBookEntry, "PHONEBOOK_EDIT_WINDOW_TITLE");
            ((Component)this).setVisible(false);
            this.cp.remove(this.scrollpane);
            this.scrollpane = null;
            this.phoneBookTable = null;
            this.phoneBookTable = this.createPhoneBookTable();
            this.scrollpane = new JScrollPane(this.phoneBookTable);
            this.cp.add("Center", this.scrollpane);
            ((Component)this).setVisible(true);
        }
    }

    void close() {
        this.parent.closeWindow(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        phoneBookDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "phonebook");
    }

    class PhoneBookTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        PhoneBookTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class PhoneBookFilter
    implements FilenameFilter {
        PhoneBookFilter() {
        }

        public boolean accept(File file, String string) {
            if (file.equals(phoneBookDir)) {
                return string.endsWith(".tel");
            }
            return false;
        }
    }

    class PhoneBookTableModel
    extends DefaultTableModel {
        PhoneBookTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

