/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MyConparator;
import com.nttdocomo.dojaemu.ktoolbar.ReadWindowCellRenderer;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SDF;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

class ReadWindow
extends AbstractWindow {
    private String projectName = null;
    ArrayList files = new ArrayList();
    private JLabel projectPathLabel;
    private JTable projectTable;
    private static String projectHome;
    private static final int ORDER_NAME = 0;
    private static final int ORDER_DATE = 1;
    private int orderNo = 0;
    private static final int SORT_UP = -1;
    private static final int SORT_DOWN = 1;
    private int sortFlag = -1;
    static /* synthetic */ Class class$java$lang$Object;

    ReadWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("READ_WINDOW_TITLE"));
        this.addWindowListener();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        String string = System.getProperty("emu.home") + File.separator + "apps";
        projectHome = mainWindow.getProjectHome();
        this.sortFlag = mainWindow.getSort();
        if (this.sortFlag > 2) {
            this.orderNo = 1;
            this.sortFlag -= 2;
        } else {
            this.orderNo = 0;
        }
        this.sortFlag = this.sortFlag == 1 ? -1 : 1;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 0));
        jPanel2.setLayout(new BorderLayout(1, 2));
        jPanel3.setLayout(new FlowLayout(0));
        JSeparator jSeparator = new JSeparator(0);
        jPanel4.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel(Resource.getString("PROJECT_HOME"));
        this.projectPathLabel = new JLabel(mainWindow.getProjectHome());
        JButton jButton = new JButton(Resource.getString("FILE_SELECT"));
        jButton.setMnemonic(82);
        JLabel jLabel2 = new JLabel(" ");
        this.projectTable = new JTable(new DirectoryModel(projectHome));
        this.projectTable.setShowGrid(false);
        ListSelectionModel listSelectionModel = this.projectTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ReadWindowListSelectionListener());
        JTableHeader jTableHeader = this.projectTable.getTableHeader();
        jTableHeader.addMouseListener(new SelectionHeader());
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        this.projectTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ReadWindow.class$("java.lang.Object")) : class$java$lang$Object, new ReadWindowCellRenderer());
        this.projectTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.projectTable);
        this.getContentPane().add(jScrollPane);
        JButton jButton2 = new JButton(Resource.getString("READ2"));
        JButton jButton3 = new JButton(Resource.getString("CANCEL"));
        jButton.setActionCommand("select");
        jButton2.setActionCommand("read");
        jButton3.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jButton2);
        jPanel5.add(jButton3);
        jPanel2.add("North", jSeparator);
        jPanel2.add("Center", jScrollPane);
        jPanel3.add(jLabel);
        jPanel3.add(jButton);
        jPanel.add("North", jPanel3);
        jPanel.add("West", jLabel2);
        jPanel.add("Center", this.projectPathLabel);
        container.add("North", jPanel);
        container.add("Center", jPanel2);
        container.add("South", jPanel5);
        ((Component)this).setSize(400, 307);
    }

    void read() {
        if (this.projectTable.getSelectedRow() == -1 || this.projectName == null) {
            this.parent.showDialog(Resource.getString("SELECT_PROJECT_WNG"), this, 2);
            return;
        }
        this.parent.setProjectHome(projectHome);
        int n = this.sortFlag == -1 ? 1 : 2;
        if (this.orderNo == 1) {
            n += 2;
        }
        this.parent.setSort(n);
        File file = new File(this.parent.getJamPath(this.projectName));
        File file2 = new File(this.parent.getProjectSettingPath(this.projectName));
        File file3 = new File(this.parent.getSdfPath(this.projectName));
        this.parent.clearOutputText();
        System.out.println(Resource.format("READING_PROJECT", this.projectName));
        ADF aDF = null;
        try {
            aDF = new ADF(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(Resource.format("NOT_FOUND_ERR", file.getPath()));
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", file.getPath()));
            return;
        }
        SDF sDF = null;
        try {
            sDF = new SDF(file3);
            sDF.parseSDF(aDF);
        }
        catch (FileNotFoundException fileNotFoundException) {
            sDF = new SDF();
            sDF.setProperty("Sts", "0");
            String string = aDF.getProperty("PackageURL");
            sDF.setProperty("PackageURL", string);
            sDF.parseSDF(aDF);
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", file3.getPath()));
            return;
        }
        Setting setting = null;
        try {
            setting = new Setting(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            setting = new Setting();
            setting.setProperty("adfUrl", "");
            setting.setProperty("launchType", String.valueOf(0));
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", file2.getPath()));
            return;
        }
        this.parent.setProjectSetting(setting);
        this.parent.setProject(this.projectName, aDF, sDF);
        System.out.println(Resource.format("FINISH_READ_PROJECT", this.projectName));
        this.parent.closeWindow(this);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    void select() {
        JFileChooser jFileChooser = new JFileChooser(projectHome);
        jFileChooser.setDialogTitle(Resource.getString("PROJECT_HOME_DIALOG"));
        jFileChooser.setDialogType(2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(null);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            projectHome = jFileChooser.getSelectedFile().getAbsolutePath();
            this.projectPathLabel.setText(projectHome);
            this.projectTable.setModel(new DirectoryModel(projectHome));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DirectoryModel
    extends AbstractTableModel
    implements ActionListener {
        public DirectoryModel() {
            Object[] objectArray = ReadWindow.this.files.toArray();
            MyConparator myConparator = new MyConparator();
            myConparator.setSort(ReadWindow.this.sortFlag);
            myConparator.setOrder(ReadWindow.this.orderNo);
            Arrays.sort(objectArray, myConparator);
            ReadWindow.this.files.clear();
            int n = 0;
            while (n < objectArray.length) {
                ReadWindow.this.files.add(objectArray[n]);
                ++n;
            }
        }

        public DirectoryModel(String string) {
            String[] stringArray;
            Object object;
            File file = new File(string);
            String[] stringArray2 = file.list();
            if (stringArray2 == null) {
                stringArray2 = new String[]{};
            }
            ReadWindow.this.files.clear();
            int n = 0;
            while (n < stringArray2.length) {
                object = projectHome + File.separator + stringArray2[n] + File.separator + "bin" + File.separator + stringArray2[n] + ".jam";
                if (new File((String)object).exists()) {
                    stringArray = new String[]{stringArray2[n], new Long(new File((String)object).lastModified()).toString()};
                    ReadWindow.this.files.add(stringArray);
                }
                ++n;
            }
            object = ReadWindow.this.files.toArray();
            stringArray = new MyConparator();
            stringArray.setSort(ReadWindow.this.sortFlag);
            stringArray.setOrder(ReadWindow.this.orderNo);
            Arrays.sort(object, stringArray);
            ReadWindow.this.files.clear();
            int n2 = 0;
            while (n2 < ((Object[])object).length) {
                ReadWindow.this.files.add(object[n2]);
                ++n2;
            }
        }

        public int getRowCount() {
            return ReadWindow.this.files != null ? ReadWindow.this.files.size() : 0;
        }

        public int getColumnCount() {
            return ReadWindow.this.files != null ? 2 : 0;
        }

        public Object getValueAt(int n, int n2) {
            if (ReadWindow.this.files == null || ReadWindow.this.files.size() == 0) {
                return null;
            }
            String[] stringArray = (String[])ReadWindow.this.files.get(n);
            switch (n2) {
                case 0: {
                    return stringArray[0];
                }
                case 1: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    return simpleDateFormat.format(new Date(Long.parseLong(stringArray[1])));
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                if (ReadWindow.this.orderNo == 1) {
                    return Resource.getString("NAMEORDER");
                }
                if (ReadWindow.this.orderNo == 1 || ReadWindow.this.sortFlag == -1) {
                    return Resource.getString("NAMEORDER_UP");
                }
                if (ReadWindow.this.orderNo == 1 || ReadWindow.this.sortFlag == 1) {
                    return Resource.getString("NAMEORDER_DOWN");
                }
            }
            if (n == 1) {
                if (ReadWindow.this.orderNo == 0) {
                    return Resource.getString("DATEORDER");
                }
                if (ReadWindow.this.orderNo == 0 || ReadWindow.this.sortFlag == -1) {
                    return Resource.getString("DATEORDER_UP");
                }
                if (ReadWindow.this.orderNo == 0 || ReadWindow.this.sortFlag == 1) {
                    return Resource.getString("DATEORDER_DOWN");
                }
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryModel directoryModel = new DirectoryModel(projectHome);
            ReadWindow.this.projectTable.setModel(directoryModel);
        }
    }

    class SelectionHeader
    extends MouseAdapter {
        SelectionHeader() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n == 0 || n == 1) {
                Object[] objectArray = ReadWindow.this.files.toArray();
                MyConparator myConparator = new MyConparator();
                if (ReadWindow.this.orderNo == n) {
                    if (ReadWindow.this.sortFlag == -1) {
                        ReadWindow.this.sortFlag = 1;
                    } else {
                        ReadWindow.this.sortFlag = -1;
                    }
                } else {
                    ReadWindow.this.orderNo = n;
                    ReadWindow.this.sortFlag = -1;
                }
                ReadWindow.this.projectTable.setModel(new DirectoryModel());
                int n2 = 0;
                while (n2 < ReadWindow.this.projectTable.getRowCount()) {
                    if (ReadWindow.this.projectTable.getValueAt(n2, 0).equals(ReadWindow.this.projectName)) {
                        ReadWindow.this.projectTable.setRowSelectionInterval(n2, n2);
                    }
                    ++n2;
                }
            }
        }
    }

    class ReadWindowListSelectionListener
    implements ListSelectionListener {
        ReadWindowListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            if (!listSelectionEvent.getValueIsAdjusting() && (n = ReadWindow.this.projectTable.getSelectedRow()) != -1) {
                ReadWindow.this.projectName = (String)ReadWindow.this.projectTable.getValueAt(n, 0);
            }
        }
    }
}

