/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.BroFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PdfFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class SetupHelpWindow
extends AbstractWindow {
    private static String projectHome;
    private MainWindow parent;
    private JTextField browserField;
    private JTextField docpathField;
    private JTextField pdftoolField;

    SetupHelpWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("SETTING_HELP_WINDOW_TITLE"), true);
        this.addWindowListener();
        this.parent = mainWindow;
        JLabel jLabel = new JLabel(Resource.getString("API_OPEN_BROWSER"));
        JLabel jLabel2 = new JLabel(Resource.getString("API_STORING_DIR"));
        JLabel jLabel3 = new JLabel(Resource.getString("PDF_OPEN_TOOL"));
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        JButton jButton3 = new JButton(Resource.getString("BROWSER_SELECT"));
        jButton3.setMnemonic(66);
        JButton jButton4 = new JButton(Resource.getString("DOCPATH_SELECT"));
        jButton4.setMnemonic(65);
        JButton jButton5 = new JButton(Resource.getString("PDFTOOL_SELECT"));
        jButton5.setMnemonic(84);
        this.browserField = new JTextField(24);
        this.browserField.setText(mainWindow.getApiBrowser());
        this.docpathField = new JTextField(24);
        this.docpathField.setText(mainWindow.getDoc());
        this.pdftoolField = new JTextField(24);
        this.pdftoolField.setText(mainWindow.getPdf());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.browserField);
        jPanel3.add(jButton3);
        jPanel.add("North", jPanel2);
        jPanel.add("South", jPanel3);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(jLabel2);
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.add(this.docpathField);
        jPanel6.add(jButton4);
        jPanel4.add("North", jPanel5);
        jPanel4.add("South", jPanel6);
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel8.setLayout(new FlowLayout(0));
        jPanel8.add(jLabel3);
        jPanel9.setLayout(new FlowLayout(0));
        jPanel9.add(this.pdftoolField);
        jPanel9.add(jButton5);
        jPanel7.add("North", jPanel8);
        jPanel7.add("South", jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout(1));
        jPanel10.add(jButton);
        jPanel10.add(jButton2);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        jPanel11.add("North", jPanel);
        jPanel11.add("Center", jPanel4);
        jPanel11.add("South", jPanel7);
        container.add("North", jPanel11);
        container.add("South", jPanel10);
        jButton3.setActionCommand("selectb");
        jButton4.setActionCommand("selects");
        jButton5.setActionCommand("selectp");
        jButton2.setActionCommand("cancel");
        jButton.setActionCommand("save");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton3.addActionListener(actionDispatcher);
        jButton4.addActionListener(actionDispatcher);
        jButton5.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        projectHome = mainWindow.getProjectHome();
        this.pack();
    }

    void save() {
        String string = this.browserField.getText();
        String string2 = this.docpathField.getText();
        String string3 = this.pdftoolField.getText();
        if ((string.trim().length() != 0 || string2.trim().length() != 0) && this.apiCheck(string, string2)) {
            return;
        }
        if (string3.trim().length() != 0 && this.pdfCheck(string3)) {
            return;
        }
        this.parent.setApiBrowser(string);
        this.parent.setDoc(string2);
        this.parent.setPdf(string3);
        this.parent.closeWindow(this);
    }

    private boolean apiCheck(String string, String string2) {
        if (string.trim().length() == 0) {
            try {
                this.parent.showDialog(Resource.format("SPECIFIED_VAL_WNG", Resource.getString("API_OPEN_BROWSER")), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        if (!new File(string).isFile()) {
            try {
                this.parent.showDialog(Resource.getString("BRO_VAL_WNG"), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        if (string2.trim().length() == 0) {
            try {
                this.parent.showDialog(Resource.format("SPECIFIED_VAL_WNG", Resource.getString("API_STORING_DIR")), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        if (!new File(string2).isDirectory()) {
            try {
                this.parent.showDialog(Resource.getString("DOCPATH_VAL_WNG"), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private boolean pdfCheck(String string) {
        if (!new File(string).isFile()) {
            try {
                this.parent.showDialog(Resource.getString("PDFTOOL_VAL_WNG"), this, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        return false;
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    void selectb() {
        JFileChooser jFileChooser = new JFileChooser(new File(this.browserField.getText()).getAbsolutePath());
        jFileChooser.setDialogTitle(Resource.getString("API_OPEN_BROWSER"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new BroFileFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.browserField.setText(jFileChooser.getSelectedFile().toString());
        }
    }

    void selects() {
        JFileChooser jFileChooser = new JFileChooser(new File(this.docpathField.getText()).getAbsolutePath());
        jFileChooser.setDialogTitle(Resource.getString("API_STORING_DIR"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setFileFilter(null);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.docpathField.setText(jFileChooser.getSelectedFile().toString());
        }
    }

    void selectp() {
        JFileChooser jFileChooser = new JFileChooser(new File(this.pdftoolField.getText()).getAbsolutePath());
        jFileChooser.setDialogTitle(Resource.getString("PDF_OPEN_TOOL"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new PdfFileFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.pdftoolField.setText(jFileChooser.getSelectedFile().toString());
        }
    }
}

