/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

class SurveyDataWindow
extends AbstractWindow {
    private MainWindow parent;
    private JComboBox latitudeCombo;
    private JComboBox longitudeCombo;
    private JTextField latitudeDegreeField;
    private JTextField latitudeDecimalField;
    private JTextField longitudeDegreeField;
    private JTextField longitudeDecimalField;
    private JTextField surveyTimeField;
    private ButtonGroup accuracyLevelButtonGroup;
    private JRadioButton accuracyCoarseRadioButton;
    private JRadioButton accuracyNormalRadioButton;
    private JRadioButton accuracyFineRadioButton;
    private JButton setButton;
    private JButton cancelButton;
    private String[] latitudePrefixItems = null;
    private String[] longitudePrefixItems = null;
    private int surveyDataLevel = 0;
    private String surveyDataLatitude = null;
    private String surveyDataLongitude = null;
    private int surveyDataDatum = 0;
    private String surveyDataTime = null;
    private String ILLEGAL_TIME = "1";
    private String ILLEGAL_LONGITUDE = "3";
    private String ILLEGAL_LATITUDE = "4";
    private static final int DECIMAL_COLUMN = 6;

    SurveyDataWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("SURVEY_DATA_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.init();
        this.loadSurveyDataFile();
        this.latitudePrefixItems = new String[2];
        this.latitudePrefixItems[0] = new String("N  ");
        this.latitudePrefixItems[1] = new String("S  ");
        this.longitudePrefixItems = new String[2];
        this.longitudePrefixItems[0] = new String("E  ");
        this.longitudePrefixItems[1] = new String("W ");
        this.latitudeCombo = new JComboBox<String>(this.latitudePrefixItems);
        this.longitudeCombo = new JComboBox<String>(this.longitudePrefixItems);
        if (this.getDegreePart(this.surveyDataLatitude, 0).equals("N")) {
            this.latitudeCombo.setSelectedIndex(0);
        } else {
            this.latitudeCombo.setSelectedIndex(1);
        }
        if (this.getDegreePart(this.surveyDataLongitude, 0).equals("E")) {
            this.longitudeCombo.setSelectedIndex(0);
        } else {
            this.longitudeCombo.setSelectedIndex(1);
        }
        JLabel jLabel = new JLabel(Resource.getString("GPS_ACCURACY_LEVEL"));
        JLabel jLabel2 = new JLabel(Resource.getString("GPS_LATITUDE"));
        JLabel jLabel3 = new JLabel(Resource.getString("GPS_LONGITUDE"));
        JLabel jLabel4 = new JLabel(Resource.getString("GPS_DATUM_TYPE"));
        JLabel jLabel5 = new JLabel(Resource.getString("SURVEY_TIME"));
        JLabel jLabel6 = new JLabel(Resource.getString("SECOND"));
        JLabel jLabel7 = new JLabel(".");
        JLabel jLabel8 = new JLabel(".");
        JLabel jLabel9 = new JLabel(" " + Resource.getString("GPS_DATUM_WGS84"));
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.accuracyCoarseRadioButton = new JRadioButton("1");
        this.accuracyNormalRadioButton = new JRadioButton("2");
        this.accuracyFineRadioButton = new JRadioButton("3");
        this.accuracyLevelButtonGroup = new ButtonGroup();
        this.accuracyLevelButtonGroup.add(this.accuracyCoarseRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyNormalRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyFineRadioButton);
        switch (this.surveyDataLevel) {
            case 1: {
                this.accuracyCoarseRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.accuracyNormalRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.accuracyFineRadioButton.setSelected(true);
            }
        }
        this.latitudeDegreeField = new JTextField(3);
        this.latitudeDecimalField = new JTextField(6);
        this.latitudeDegreeField.setHorizontalAlignment(4);
        this.latitudeDecimalField.setHorizontalAlignment(2);
        ((JTextComponent)this.latitudeDegreeField).setDocument(new HalfNumberDocument(3));
        ((JTextComponent)this.latitudeDecimalField).setDocument(new HalfNumberDocument(6));
        this.longitudeDegreeField = new JTextField(3);
        this.longitudeDecimalField = new JTextField(6);
        this.longitudeDegreeField.setHorizontalAlignment(4);
        this.longitudeDecimalField.setHorizontalAlignment(2);
        ((JTextComponent)this.longitudeDegreeField).setDocument(new HalfNumberDocument(3));
        ((JTextComponent)this.longitudeDecimalField).setDocument(new HalfNumberDocument(6));
        this.latitudeDegreeField.setText(this.getDegreePart(this.surveyDataLatitude, 1));
        this.latitudeDecimalField.setText(this.getDegreePart(this.surveyDataLatitude, 2));
        this.longitudeDegreeField.setText(this.getDegreePart(this.surveyDataLongitude, 1));
        this.longitudeDecimalField.setText(this.getDegreePart(this.surveyDataLongitude, 2));
        this.surveyTimeField = new JTextField(10);
        ((JTextComponent)this.surveyTimeField).setDocument(new HalfNumberDocument(10));
        this.surveyTimeField.setHorizontalAlignment(4);
        this.surveyTimeField.setText(this.surveyDataTime);
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new GridLayout(5, 1));
        jPanel4.setLayout(new GridLayout(5, 1));
        jPanel6.setLayout(new FlowLayout(0));
        jPanel7.setLayout(new FlowLayout(0));
        jPanel8.setLayout(new FlowLayout(0));
        jPanel9.setLayout(new FlowLayout(0));
        jPanel6.add(this.accuracyCoarseRadioButton);
        jPanel6.add(this.accuracyNormalRadioButton);
        jPanel6.add(this.accuracyFineRadioButton);
        jPanel7.add(this.latitudeCombo);
        jPanel7.add(this.latitudeDegreeField);
        jPanel7.add(jLabel7);
        jPanel7.add(this.latitudeDecimalField);
        jPanel8.add(this.longitudeCombo);
        jPanel8.add(this.longitudeDegreeField);
        jPanel8.add(jLabel8);
        jPanel8.add(this.longitudeDecimalField);
        jPanel9.add(this.surveyTimeField);
        jPanel9.add(jLabel6);
        jPanel3.add(this.getFlowPanel(jLabel, 2));
        jPanel3.add(this.getFlowPanel(jLabel2, 2));
        jPanel3.add(this.getFlowPanel(jLabel3, 2));
        jPanel3.add(this.getFlowPanel(jLabel5, 2));
        jPanel3.add(this.getFlowPanel(jLabel4, 2));
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel4.add(jPanel9);
        jPanel4.add(this.getFlowPanel(jLabel9, 0));
        jPanel5.add(this.setButton);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add("Center", jPanel2);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    private void init() {
        this.surveyDataLevel = 3;
        this.surveyDataLatitude = new String("N0.0");
        this.surveyDataLongitude = new String("E0.0");
        this.surveyDataDatum = 0;
        this.surveyDataTime = new String("0");
    }

    private String getSurveyDataPath() {
        return System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "survey_data" + File.separator + "survey_data";
    }

    private void loadSurveyDataFile() {
        File file = new File(this.getSurveyDataPath());
        BufferedReader bufferedReader = null;
        int n = -1;
        if (file.exists() && file.isFile()) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    if (string.startsWith("#") || (stringTokenizer = new StringTokenizer(string, ",")).countTokens() != 6) continue;
                    try {
                        this.surveyDataDatum = Integer.parseInt(stringTokenizer.nextToken());
                        if (this.surveyDataDatum != 0) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        String string2 = stringTokenizer.nextToken();
                        if (!SurveyDataWindow.parseDegreeLatitudeString(string2)) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        this.surveyDataLatitude = string2;
                        String string3 = stringTokenizer.nextToken();
                        if (!SurveyDataWindow.parseDegreeLongitudeString(string3)) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        this.surveyDataLongitude = string3;
                        stringTokenizer.nextToken();
                        this.surveyDataLevel = Integer.parseInt(stringTokenizer.nextToken());
                        if (this.surveyDataLevel < 1 || this.surveyDataLevel > 3) {
                            throw new IllegalArgumentException("Illegal value.");
                        }
                        this.surveyDataTime = stringTokenizer.nextToken();
                        n = Integer.parseInt(this.surveyDataTime);
                        if (n >= 0) break;
                        throw new IllegalArgumentException("Illegal value.");
                    }
                    catch (Exception exception) {
                        this.init();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                this.init();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private boolean saveSurveyDataFile() {
        boolean bl;
        block29: {
            bl = true;
            int n = 1;
            String string = null;
            String string2 = this.parseDegreeLatitude();
            String string3 = this.parseDegreeLongitude();
            String string4 = this.parseSurveyTime();
            File file = new File(this.getSurveyDataPath());
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            String string5 = "";
            if (string2 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_LATITUDE);
            }
            if (string3 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_LONGITUDE);
            }
            if (string4 == null) {
                throw new IllegalArgumentException(this.ILLEGAL_TIME);
            }
            if (this.accuracyCoarseRadioButton.isSelected()) {
                n = 1;
            } else if (this.accuracyNormalRadioButton.isSelected()) {
                n = 2;
            } else if (this.accuracyFineRadioButton.isSelected()) {
                n = 3;
            }
            string = "0," + string2 + "," + string3 + "," + "0" + "," + n + "," + string4;
            String string6 = "";
            if (file.exists() && file.isFile()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string7 = null;
                while ((string7 = bufferedReader.readLine()) != null) {
                    if (!string7.startsWith("#")) continue;
                    string6 = string6 + string7 + '\n';
                }
                bufferedReader.close();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(this.getSurveyDataPath(), false));
            if (!string6.equals("")) {
                bufferedWriter.write(string6);
            }
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
            Object var15_15 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                break block29;
            }
            catch (Exception exception) {}
            break block29;
            {
                catch (IOException iOException) {
                    this.parent.showDialog(Resource.format("WRITE_ERR", file), this, 2);
                    bl = false;
                    Object var15_16 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block29;
                    }
                    catch (Exception exception) {}
                    break block29;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string5 = illegalArgumentException.getMessage().equals(this.ILLEGAL_LATITUDE) ? Resource.getString("GPS_LATITUDE") : (illegalArgumentException.getMessage().equals(this.ILLEGAL_LONGITUDE) ? Resource.getString("GPS_LONGITUDE") : Resource.getString("SURVEY_TIME"));
                    this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string5), this, 2);
                    bl = false;
                    Object var15_17 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        break block29;
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    static boolean parseDegreeLatitudeString(String string) {
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        if (string2.length() < 1 || string2.length() > 4) {
            return false;
        }
        if (string3.length() < 1 || string3.length() > 6) {
            return false;
        }
        switch (string2.charAt(0)) {
            case 'N': {
                bl = false;
                break;
            }
            case 'S': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            n = Integer.parseInt(string2.substring(1));
            if (bl) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return false;
        }
        if (n < -90 || n > 90) {
            return false;
        }
        return Math.abs(n) != 90 || n2 == 0;
    }

    private String parseSurveyTime() {
        String string = this.surveyTimeField.getText();
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        return string;
    }

    private String parseDegreeLatitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.latitudeCombo.getSelectedIndex();
        String string = ((String)this.latitudeCombo.getSelectedItem()).trim();
        String string2 = this.latitudeDegreeField.getText();
        String string3 = this.latitudeDecimalField.getText();
        String string4 = null;
        try {
            n = Integer.parseInt(string2);
            if (n3 != 0) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -90 || n > 90) {
                bl = true;
            } else if (Math.abs(n) == 90 && n2 != 0) {
                bl = true;
            } else {
                string3 = this.getDecimalString(n2, 6);
                string4 = string + string2 + "." + string3;
            }
        }
        return string4;
    }

    static boolean parseDegreeLongitudeString(String string) {
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        string3 = stringTokenizer.nextToken();
        if (string2.length() < 1 || string2.length() > 4) {
            return false;
        }
        if (string3.length() < 1 || string3.length() > 6) {
            return false;
        }
        switch (string2.charAt(0)) {
            case 'E': {
                bl = false;
                break;
            }
            case 'W': {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        try {
            n = Integer.parseInt(string2.substring(1));
            if (bl) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return false;
        }
        if (n < -180 || n >= 180) {
            return false;
        }
        return n != -180 || n2 == 0;
    }

    private String parseDegreeLongitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.longitudeCombo.getSelectedIndex();
        String string = ((String)this.longitudeCombo.getSelectedItem()).trim();
        String string2 = this.longitudeDegreeField.getText();
        String string3 = this.longitudeDecimalField.getText();
        String string4 = null;
        try {
            n = Integer.parseInt(string2);
            if (n3 != 0) {
                n = -n;
            }
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -180 || n >= 180) {
                bl = true;
            } else if (n == -180 && n2 != 0) {
                bl = true;
            } else {
                string3 = this.getDecimalString(n2, 6);
                string4 = string + string2 + "." + string3;
            }
        }
        return string4;
    }

    private String getDegreePart(String string, int n) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 2) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    string2 = string3.substring(0, 1);
                    break;
                }
                case 1: {
                    string2 = string3.substring(1);
                    break;
                }
                case 2: {
                    string2 = string4;
                }
            }
        }
        return string2;
    }

    void set() {
        if (this.saveSurveyDataFile()) {
            this.parent.closeWindow(this);
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    private String getDecimalString(int n, int n2) {
        String string = null;
        if (n < 0 || n2 < 1) {
            string = null;
        } else {
            string = Integer.toString(n);
            while (string.length() < n2) {
                string = string + "0";
            }
            if (string.length() > n2) {
                string = string.substring(0, n2);
            }
        }
        return string;
    }
}

