/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica;

import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipIssue;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipManufacture;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipSystem;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipUnuse;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipUserData;
import java.util.Vector;

class FaverChipBlockManager {
    static final int BLOCK_SIZE = 16;
    static final int INFO_SIZE = 4;
    static final int TOTAL_BLOCK = 320;
    static final int BLOCK_TOTAL_SIZE = 5120;
    static final int INFO_TOTAL_SIZE = 1280;
    static final int TOTAL_SIZE = 6400;
    static final int COMMON_DATA_BLOCK = 286;
    static final int FREE_DATA_BLOCK = 34;
    static final int COMMON_AREA0000_POS = 3;
    static final int FREE_AREA0000_POS = 289;
    byte[][] faverData = new byte[320][16];
    byte[][] faverInfo = new byte[320][4];
    private int useBlockNum;
    private int useAreaNum;
    private int useServiceNum;
    private Vector vBlock = new Vector();
    private Vector vArea = new Vector();
    private Vector vService = new Vector();

    FaverChipBlockManager(byte[] byArray) {
        int n = 0;
        while (n < 320) {
            System.arraycopy(byArray, n * 16, this.faverData[n], 0, 16);
            System.arraycopy(byArray, 5120 + n * 4, this.faverInfo[n], 0, 4);
            ++n;
        }
    }

    Vector makeBlocks() {
        int n = 0;
        while (n < 320) {
            FaverChipBlock faverChipBlock;
            if (this.faverInfo[n][0] == 4) {
                faverChipBlock = new FaverChipArea(n, this.faverData[n], this.faverInfo[n]);
                this.vBlock.add(faverChipBlock);
                this.vArea.add(faverChipBlock);
            } else if (this.faverInfo[n][0] == 5) {
                faverChipBlock = new FaverChipService(n, this.faverData[n], this.faverInfo[n]);
                this.vBlock.add(faverChipBlock);
                this.vService.add(faverChipBlock);
            } else if (this.faverInfo[n][0] == 6) {
                faverChipBlock = new FaverChipUserData(n, this.faverData[n], this.faverInfo[n]);
                this.vBlock.add(faverChipBlock);
            } else if (this.faverInfo[n][0] == 1) {
                faverChipBlock = new FaverChipManufacture(n, this.faverData[n], this.faverInfo[n]);
                this.vBlock.add(faverChipBlock);
            } else if (this.faverInfo[n][0] == 2) {
                faverChipBlock = new FaverChipIssue(n, this.faverData[n], this.faverInfo[n]);
                this.vBlock.add(faverChipBlock);
            } else if (this.faverInfo[n][0] == 3) {
                faverChipBlock = new FaverChipSystem(n, this.faverData[n], this.faverInfo[n]);
                this.vBlock.add(faverChipBlock);
            } else {
                faverChipBlock = new FaverChipUnuse(n, this.faverData[n], this.faverInfo[n]);
                this.vBlock.add(faverChipBlock);
            }
            ++n;
        }
        this.useAreaNum = this.vArea.size();
        this.useServiceNum = this.vService.size();
        this.useBlockNum = this.vBlock.size();
        return this.vBlock;
    }

    Vector getAreaVector() {
        return this.vArea;
    }

    Vector getServiceVector() {
        return this.vService;
    }

    byte[] getFaverData() {
        byte[] byArray = new byte[6400];
        int n = 0;
        while (n < 320) {
            FaverChipBlock faverChipBlock = (FaverChipBlock)this.vBlock.get(n);
            byte[] byArray2 = faverChipBlock.getDataBytes();
            byte[] byArray3 = faverChipBlock.getInfoBytes();
            System.arraycopy(byArray2, 0, byArray, n * 16, 16);
            System.arraycopy(byArray3, 0, byArray, 5120 + n * 4, 4);
            ++n;
        }
        return byArray;
    }
}

