/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica;

import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerLabelInfo;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerParam;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

abstract class FaverChipData
implements FaverChipViewerParam {
    public int realDataSize;
    public int managementSize;
    public int beginEditArea;
    public int endEditArea;
    File fcFile;
    byte[] originData;
    StringBuffer editData;
    byte[] originManagementInfo;
    byte[] editManagementInfo;
    byte[] savedata = null;
    boolean editflag;

    FaverChipData() {
    }

    void init() {
        int n = this.originData.length;
        String string = "";
        this.editData = new StringBuffer(n);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.originManagementInfo);
            this.editManagementInfo = new byte[this.originManagementInfo.length];
            byteArrayInputStream.read(this.editManagementInfo, 0, this.editManagementInfo.length);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.originData[n2] < 0 ? 256 + this.originData[n2] : this.originData[n2];
            string = Integer.toHexString(n3);
            if (string.length() == 1) {
                this.editData.append("0");
            }
            this.editData.append(string.toUpperCase());
            ++n2;
        }
    }

    String getHexString(int n, int n2) {
        if (n2 <= 0 || n < 0 || this.originData.length < n + n2) {
            return "";
        }
        return this.editData.substring(n * 2, n * 2 + n2 * 2);
    }

    byte hexStrToByte(String string) {
        if (string == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = 1;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            switch (cArray[n3]) {
                case '0': {
                    n2 += n * 0;
                    break;
                }
                case '1': {
                    n2 += n * 1;
                    break;
                }
                case '2': {
                    n2 += n * 2;
                    break;
                }
                case '3': {
                    n2 += n * 3;
                    break;
                }
                case '4': {
                    n2 += n * 4;
                    break;
                }
                case '5': {
                    n2 += n * 5;
                    break;
                }
                case '6': {
                    n2 += n * 6;
                    break;
                }
                case '7': {
                    n2 += n * 7;
                    break;
                }
                case '8': {
                    n2 += n * 8;
                    break;
                }
                case '9': {
                    n2 += n * 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    n2 += n * 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    n2 += n * 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 += n * 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    n2 += n * 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    n2 += n * 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    n2 += n * 15;
                }
            }
            n *= 16;
            --n3;
        }
        return (byte)n2;
    }

    byte[] hexStrToByteArray(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return null;
        }
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.hexStrToByte(string.substring(2 * n3, 2 * n3 + 2));
            ++n3;
        }
        return byArray;
    }

    void update(String string, byte[] byArray) {
        int n = string.length();
        this.editData.replace(0, n, string);
        this.editManagementInfo = byArray;
        this.createSaveData();
    }

    void save() throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.fcFile);
        fileOutputStream.write(this.savedata, 0, this.savedata.length);
        fileOutputStream.close();
    }

    byte[] getSaveData() {
        return this.savedata;
    }

    byte[] getOriginData() {
        return this.originData;
    }

    byte[] getManagementInfo() {
        return this.originManagementInfo;
    }

    void setSaveData(byte[] byArray) {
        this.savedata = byArray;
    }

    abstract void createSaveData();

    public abstract boolean isEnabledRightClick();

    public abstract FaverChipViewerLabelInfo[] getLabelInfo();

    public abstract String[] getBlockName();
}

