/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica;

import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipData;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerLabelInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

class FaverChipDataGen
extends FaverChipData {
    final int FULL_DATA_SIZE = 6400;
    final int REAL_DATA_SIZE = 512;
    int MANAGEMENT_SIZE = 128;
    final int OFFSET_REAL_DATA = 4608;
    final int OFFSET_MANAGEMENT = 6272;
    final int BEGIN_EDIT_AREA = -1;
    final int END_EDIT_AREA = -1;
    byte[] allDataByte = null;
    final boolean ENABLE_RIGTH_CLICK = false;
    private final int SAVE_OFFSET = 32;
    private final int BLOCK_SIZE = 16;
    private String[] blockName = new String[]{"System define block (Free area)", "Area define block (Free area)", "Area define block (Free area 0001)", "Service block 1 (Free area 0001)", "CPID data block (Free area 0001)", "Service block 2 (Free area 0001)", "Data block 0 (Free area 0001)", "Data block 1 (Free area 0001)", "Data block 2 (Free area 0001)", "Data block 3 (Free area 0001)", "PIN service block (Free area 0001)", "PIN data block (Free area 0001)", "Area define block (Free area 0002)", "Service block 1 (Free area 0002)", "CPID data block (Free area 0002)", "Service block 2 (Free area 0002)", "Data block 0 (Free area 0002)", "Data block 1 (Free area 0002)", "Data block 2 (Free area 0002)", "Data block 3 (Free area 0002)", "PIN service block (Free area 0002)", "PIN data block (Free area 0002)", "Area define block (Free area 0003)", "Service block 1 (Free area 0003)", "CPID data block (Free area 0003)", "Service block 2 (Free area 0003)", "Data block 0 (Free area 0003)", "Data block 1 (Free area 0003)", "Data block 2 (Free area 0003)", "Data block 3 (Free area 0003)", "PIN service block (Free area 0003)", "PIN data block (Free area 0003)"};

    FaverChipDataGen(File file) throws IOException {
        FileInputStream fileInputStream = null;
        this.realDataSize = 512;
        this.managementSize = this.MANAGEMENT_SIZE;
        this.beginEditArea = -1;
        this.endEditArea = -1;
        if (!file.canRead()) {
            throw new IOException("Illegal FaverChip data");
        }
        int n = (int)file.length();
        if (n < this.realDataSize + this.managementSize) {
            throw new IOException("Illegal FaverChip data");
        }
        this.allDataByte = new byte[6400];
        this.originData = new byte[512];
        this.originManagementInfo = new byte[this.MANAGEMENT_SIZE];
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(this.allDataByte);
        fileInputStream.close();
        System.arraycopy(this.allDataByte, 4608, this.originData, 0, 512);
        System.arraycopy(this.allDataByte, 6272, this.originManagementInfo, 0, this.MANAGEMENT_SIZE);
        this.fcFile = file;
        this.editflag = false;
        this.init();
    }

    public void createSaveData() {
        try {
            byte[] byArray = this.hexStrToByteArray(this.editData.toString());
            int n = 0;
            while (n < 3) {
                int n2 = 32 + n * 10 * 16;
                int n3 = n2 + 32;
                System.arraycopy(byArray, n3, this.allDataByte, 4608 + n3, 16);
                int n4 = n2 + 64;
                System.arraycopy(byArray, n4, this.allDataByte, 4608 + n4, 64);
                int n5 = n2 + 144;
                System.arraycopy(byArray, n5, this.allDataByte, 4608 + n5, 4);
                ++n;
            }
            System.arraycopy(this.editManagementInfo, 0, this.allDataByte, 6272, this.MANAGEMENT_SIZE);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.allDataByte);
            this.savedata = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getBlockName() {
        return this.blockName;
    }

    public FaverChipViewerLabelInfo[] getLabelInfo() {
        ArrayList<FaverChipViewerLabelInfo> arrayList = new ArrayList<FaverChipViewerLabelInfo>();
        arrayList.add(new FaverChipViewerLabelInfo(0, 0, 16));
        arrayList.add(new FaverChipViewerLabelInfo(1, 16, 16));
        arrayList.add(new FaverChipViewerLabelInfo(2, 32, 16));
        arrayList.add(new FaverChipViewerLabelInfo(3, 48, 16));
        arrayList.add(new FaverChipViewerLabelInfo(4, 64, 16));
        arrayList.add(new FaverChipViewerLabelInfo(5, 80, 16));
        arrayList.add(new FaverChipViewerLabelInfo(6, 96, 16));
        arrayList.add(new FaverChipViewerLabelInfo(7, 112, 16));
        arrayList.add(new FaverChipViewerLabelInfo(8, 128, 16));
        arrayList.add(new FaverChipViewerLabelInfo(9, 144, 16));
        arrayList.add(new FaverChipViewerLabelInfo(10, 160, 16));
        arrayList.add(new FaverChipViewerLabelInfo(11, 176, 16));
        arrayList.add(new FaverChipViewerLabelInfo(12, 192, 16));
        arrayList.add(new FaverChipViewerLabelInfo(13, 208, 16));
        arrayList.add(new FaverChipViewerLabelInfo(14, 224, 16));
        arrayList.add(new FaverChipViewerLabelInfo(15, 240, 16));
        arrayList.add(new FaverChipViewerLabelInfo(16, 256, 16));
        arrayList.add(new FaverChipViewerLabelInfo(17, 272, 16));
        arrayList.add(new FaverChipViewerLabelInfo(18, 288, 16));
        arrayList.add(new FaverChipViewerLabelInfo(19, 304, 16));
        arrayList.add(new FaverChipViewerLabelInfo(20, 320, 16));
        arrayList.add(new FaverChipViewerLabelInfo(21, 336, 16));
        arrayList.add(new FaverChipViewerLabelInfo(22, 352, 16));
        arrayList.add(new FaverChipViewerLabelInfo(23, 368, 16));
        arrayList.add(new FaverChipViewerLabelInfo(24, 384, 16));
        arrayList.add(new FaverChipViewerLabelInfo(25, 400, 16));
        arrayList.add(new FaverChipViewerLabelInfo(26, 416, 16));
        arrayList.add(new FaverChipViewerLabelInfo(27, 432, 16));
        arrayList.add(new FaverChipViewerLabelInfo(28, 448, 16));
        arrayList.add(new FaverChipViewerLabelInfo(29, 464, 16));
        arrayList.add(new FaverChipViewerLabelInfo(30, 480, 16));
        arrayList.add(new FaverChipViewerLabelInfo(31, 496, 16));
        return arrayList.toArray(new FaverChipViewerLabelInfo[0]);
    }

    public boolean isEnabledRightClick() {
        return false;
    }
}

