/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipData;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipDataCon;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipDataGen;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewButtonListener;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewDocument;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewPane;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewWindowAdapter;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerLabelInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FaverChipViewer
extends JFrame {
    private static final String TITLE = Resource.getString("FC_WINDOW_TITLE");
    private static final int FAVER_VIEW_COLUMN = 16;
    static final int BYTE_PER_ROW = 16;
    private static final String ENCODING = "8859_1";
    private File fcLocationDir;
    private FaverChipViewPane fcTextPane;
    private FaverChipViewDocument doc;
    private Style style;
    private StyledDocument sd;
    private FaverChipData fcd;
    private MainWindow parent = null;
    private File fcFile = null;
    private JComboBox areaBox;
    private JButton updateButton;
    private JButton reloadButton;
    private JButton closeButton;
    private JPopupMenu rightClickMenu;
    private JMenu blockTypeItem;
    private JMenuItem areaItem;
    private JMenuItem serviceItem;
    private JMenuItem dataItem;
    private JMenuItem unuseItem;
    private JMenuItem allUnuseItem;
    FaverChipViewerBlock[] blocks;
    private FaverChipViewerLabelInfo[] labels;
    private StringBuffer[] fcViewLines;
    ActionListener comboListener;
    private int felicaEmuDiv;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        FaverChipViewer faverChipViewer = new FaverChipViewer();
    }

    private FaverChipViewer() {
        try {
            this.fcLocationDir = new File(System.getProperty("emu.home") + File.separator + "apps");
        }
        catch (NullPointerException nullPointerException) {
            this.fcLocationDir = null;
        }
        String string = this.showFileChooser();
        if (string.equals("")) {
            System.exit(0);
        } else {
            try {
                this.makeFaverChipViewer(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("FC_NOT_FOUND_ERR", string));
                System.exit(0);
            }
            catch (IOException iOException) {
                System.out.println(Resource.format("FC_READ_ERR", string));
                System.exit(0);
            }
            ((Component)this).setVisible(true);
        }
    }

    public FaverChipViewer(MainWindow mainWindow, File file, int n) throws FileNotFoundException, IOException {
        try {
            this.fcLocationDir = new File(System.getProperty("emu.home") + File.separator + "apps");
        }
        catch (NullPointerException nullPointerException) {
            this.fcLocationDir = null;
        }
        this.parent = mainWindow;
        this.fcFile = file;
        this.felicaEmuDiv = n;
        this.makeFaverChipViewer(file);
    }

    private synchronized void makeFaverChipViewer(File file) throws FileNotFoundException, IOException {
        this.fcFile = file;
        this.setTitle(TITLE + " - " + file.getName());
        this.fcd = this.felicaEmuDiv != 4 ? new FaverChipDataCon(file) : new FaverChipDataGen(file);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.areaBox = new JComboBox();
        this.initAreaBox();
        this.doc = new FaverChipViewDocument();
        this.fcTextPane = new FaverChipViewPane(this.doc);
        this.style = this.doc.addStyle(null, null);
        this.fcTextPane.setFont(new Font("monospaced", 0, 14));
        JScrollPane jScrollPane = new JScrollPane(this.fcTextPane);
        this.comboListener = new ActionListener(){

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                int n = FaverChipViewer.this.areaBox.getSelectedIndex();
                if (FaverChipViewer.this.rightClickMenu.isVisible()) {
                    FaverChipViewer.this.rightClickMenu.setVisible(false);
                    FaverChipViewer.this.blockTypeItem.setPopupMenuVisible(false);
                }
                int n2 = 0;
                while (n2 < FaverChipViewer.this.labels.length) {
                    if (((FaverChipViewer)FaverChipViewer.this).labels[n2].labelIndex == n) {
                        FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[n2].viewbeginpos);
                        FaverChipViewer.this.coloring(FaverChipViewer.this.labels[n2]);
                        break;
                    }
                    ++n2;
                }
            }
        };
        this.updateButton = new JButton(Resource.getString("UPDATE"));
        this.updateButton.setActionCommand("update");
        this.reloadButton = new JButton(Resource.getString("RELOAD"));
        this.reloadButton.setActionCommand("reload");
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.closeButton.setActionCommand("close");
        this.createRightClickMenu();
        this.addWindowListener(new FaverChipViewWindowAdapter(this));
        FaverChipViewButtonListener faverChipViewButtonListener = new FaverChipViewButtonListener(this);
        this.fcTextPane.setEditable(true);
        this.sd = this.fcTextPane.getStyledDocument();
        this.fcTextPane.addKeyListener(new KeyAdapter(){

            public synchronized void keyPressed(KeyEvent keyEvent) {
                int n = FaverChipViewer.this.fcTextPane.getCaretPosition();
                int n2 = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                int n3 = keyEvent.getModifiers();
                if (FaverChipViewer.this.rightClickMenu.isVisible()) {
                    FaverChipViewer.this.rightClickMenu.setVisible(false);
                    FaverChipViewer.this.blockTypeItem.setPopupMenuVisible(false);
                }
                if (n2 == 10) {
                    int n4 = FaverChipViewer.this.labels.length - 1;
                    while (n4 >= 0) {
                        if (((FaverChipViewer)FaverChipViewer.this).labels[n4].viewbeginpos <= n && ((FaverChipViewer)FaverChipViewer.this).labels[n4].viewendpos >= n) {
                            if (n3 == 1) {
                                if (n4 > 0) {
                                    FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                                    FaverChipViewer.this.coloring(FaverChipViewer.this.labels[n4 - 1]);
                                    FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[n4 - 1].viewbeginpos);
                                    FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[n4 - 1].labelIndex);
                                    FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                                    break;
                                }
                                FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                                FaverChipViewer.this.coloring(FaverChipViewer.this.labels[FaverChipViewer.this.labels.length - 1]);
                                FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[((FaverChipViewer)FaverChipViewer.this).labels.length - 1].viewbeginpos);
                                FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[((FaverChipViewer)FaverChipViewer.this).labels.length - 1].labelIndex);
                                FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                                break;
                            }
                            if (n4 < FaverChipViewer.this.labels.length - 1) {
                                FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                                FaverChipViewer.this.coloring(FaverChipViewer.this.labels[n4 + 1]);
                                FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[n4 + 1].viewbeginpos);
                                FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[n4 + 1].labelIndex);
                                FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                                break;
                            }
                            FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                            FaverChipViewer.this.coloring(FaverChipViewer.this.labels[0]);
                            FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[0].viewbeginpos);
                            FaverChipViewer.this.areaBox.setSelectedIndex(0);
                            FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                            break;
                        }
                        --n4;
                    }
                    keyEvent.consume();
                } else if (n2 == 9) {
                    if (n3 == 1) {
                        FaverChipViewer.this.areaBox.requestFocus();
                    } else {
                        FaverChipViewer.this.closeButton.requestFocus();
                    }
                    keyEvent.consume();
                } else if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                    ((FaverChipViewer)FaverChipViewer.this).fcd.editflag = true;
                    FaverChipViewer.this.blocks[((FaverChipViewer)FaverChipViewer.this).getLineNumber((int)n)].editflag = true;
                }
            }

            public synchronized void keyReleased(KeyEvent keyEvent) {
                int n = FaverChipViewer.this.fcTextPane.getCaretPosition();
                int n2 = keyEvent.getKeyCode();
                if (n2 == 123) {
                    FaverChipViewer.this.coloring(FaverChipViewer.this.labels);
                } else {
                    int n3 = FaverChipViewer.this.labels.length - 1;
                    while (n3 >= 0) {
                        if (((FaverChipViewer)FaverChipViewer.this).labels[n3].viewbeginpos <= n && ((FaverChipViewer)FaverChipViewer.this).labels[n3].viewendpos >= n) {
                            if (FaverChipViewer.this.areaBox.getSelectedIndex() != ((FaverChipViewer)FaverChipViewer.this).labels[n3].labelIndex) {
                                FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                                FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[n3].labelIndex);
                                FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                                FaverChipViewer.this.coloring(FaverChipViewer.this.labels[n3]);
                                break;
                            }
                            FaverChipViewer.this.coloring(FaverChipViewer.this.labels[n3]);
                        }
                        --n3;
                    }
                }
            }
        });
        this.fcTextPane.addMouseListener(new MouseAdapter(){

            public synchronized void mouseReleased(MouseEvent mouseEvent) {
                int n = FaverChipViewer.this.fcTextPane.getCaretPosition();
                int n2 = FaverChipViewer.this.labels.length - 1;
                while (n2 >= 0) {
                    if (((FaverChipViewer)FaverChipViewer.this).labels[n2].viewbeginpos <= n && ((FaverChipViewer)FaverChipViewer.this).labels[n2].viewendpos >= n) {
                        if (FaverChipViewer.this.areaBox.getSelectedIndex() != ((FaverChipViewer)FaverChipViewer.this).labels[n2].labelIndex) {
                            FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                            FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[n2].labelIndex);
                            FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                        }
                        FaverChipViewer.this.coloring(FaverChipViewer.this.labels[n2]);
                    }
                    --n2;
                }
            }

            public synchronized void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) == 4) {
                    int n = FaverChipViewer.this.fcTextPane.getCaretPosition();
                    FaverChipViewer.this.areaItem.setEnabled(true);
                    FaverChipViewer.this.serviceItem.setEnabled(true);
                    FaverChipViewer.this.dataItem.setEnabled(true);
                    FaverChipViewer.this.unuseItem.setEnabled(true);
                    FaverChipViewer.this.allUnuseItem.setEnabled(true);
                    int n2 = FaverChipViewer.this.getLineNumber(n);
                    if (((FaverChipViewer)FaverChipViewer.this).fcd.beginEditArea <= FaverChipViewer.this.blocks[n2].begin && FaverChipViewer.this.blocks[n2].begin <= ((FaverChipViewer)FaverChipViewer.this).fcd.endEditArea) {
                        switch (FaverChipViewer.this.blocks[n2].getBlockType()) {
                            case 0: {
                                FaverChipViewer.this.unuseItem.setEnabled(false);
                                break;
                            }
                            case 4: {
                                FaverChipViewer.this.areaItem.setEnabled(false);
                                break;
                            }
                            case 5: {
                                FaverChipViewer.this.serviceItem.setEnabled(false);
                                break;
                            }
                            case 6: {
                                FaverChipViewer.this.dataItem.setEnabled(false);
                                break;
                            }
                        }
                    } else {
                        FaverChipViewer.this.areaItem.setEnabled(false);
                        FaverChipViewer.this.serviceItem.setEnabled(false);
                        FaverChipViewer.this.dataItem.setEnabled(false);
                        FaverChipViewer.this.unuseItem.setEnabled(false);
                    }
                    if (FaverChipViewer.this.fcd.isEnabledRightClick()) {
                        FaverChipViewer.this.rightClickMenu.show(FaverChipViewer.this.fcTextPane, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.areaBox.addActionListener(this.comboListener);
        this.updateButton.addActionListener(faverChipViewButtonListener);
        this.reloadButton.addActionListener(faverChipViewButtonListener);
        this.closeButton.addActionListener(faverChipViewButtonListener);
        JPanel jPanel = new JPanel();
        jPanel.add(this.updateButton);
        jPanel.add(this.reloadButton);
        jPanel.add(this.closeButton);
        container.add("North", this.areaBox);
        container.add("Center", jScrollPane);
        container.add("South", jPanel);
        this.initLabelInfo();
        this.initBlockInfo();
        this.initViewLines();
        this.setDataToView();
        this.fcTextPane.setCaretPosition(0);
        this.areaBox.setSelectedIndex(0);
        this.pack();
        ((Component)this).setSize(500, 400);
    }

    void reload() {
        this.fcd = null;
        try {
            this.fcd = this.felicaEmuDiv != 4 ? new FaverChipDataCon(this.fcFile) : new FaverChipDataGen(this.fcFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.parent.closeWindow(this);
        }
        this.resetBlockInfo();
        this.resetView();
    }

    void close() {
        this.parent.closeWindow(this);
    }

    void update() {
        try {
            this.fcd.update(this.viewStrToHexStr(), this.getBlockToByte());
            if (this.felicaEmuDiv != 4) {
                if (this.fcd.editflag) {
                    FaverChipCheck faverChipCheck = new FaverChipCheck(this.fcd.getSaveData());
                    if (!faverChipCheck.verification()) {
                        System.out.println("\u3010NG EDITING\u3011" + faverChipCheck.getErrorMessage());
                        return;
                    }
                    this.fcd.setSaveData(faverChipCheck.getUpdatedData());
                    System.out.println("\u3010OK EDITING\u3011");
                }
                this.fcd.save();
                this.resetEditFlag();
                this.fcd.editflag = false;
                this.reload();
            } else if (this.fcd.editflag) {
                this.fcd.save();
                this.resetEditFlag();
                this.fcd.editflag = false;
                this.reload();
                JOptionPane.showMessageDialog(this, Resource.getString("FC_SAVE_DIALOG_MESSAGE"), Resource.getString("CONFIRM"), 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void initViewLines() {
        int n;
        int n2 = 0;
        this.fcViewLines = new StringBuffer[this.fcd.realDataSize / 16];
        int n3 = 0;
        while (n3 < this.fcViewLines.length) {
            this.fcViewLines[n3] = new StringBuffer();
            this.fcViewLines[n3].append(this.getRowNumberString(n3 * 16));
            n2 = n3 * 16;
            n = 0;
            while (n < 16) {
                this.fcViewLines[n3].append(" ");
                int n4 = 0;
                while (n4 < this.labels.length) {
                    if (this.labels[n4].begin == n2 + n) {
                        if (n4 > 0) {
                            int n5 = 0;
                            while (n5 < n3 + 1) {
                                this.labels[n4].viewbeginpos += this.fcViewLines[n5].length();
                                ++n5;
                            }
                            this.labels[n4 - 1].viewendpos = this.labels[n4].viewbeginpos - 1;
                        } else {
                            this.labels[n4].viewbeginpos = 0;
                            this.labels[n4].viewendpos = this.fcViewLines[n3].length() - 1;
                        }
                    }
                    ++n4;
                }
                String string = this.fcd.getHexString(n2 + n, 1);
                this.fcViewLines[n3].append(string);
                ++n;
            }
            if (n3 < this.fcViewLines.length - 1) {
                this.fcViewLines[n3].append("\n");
            }
            ++n3;
        }
        n = 0;
        while (n < this.fcViewLines.length) {
            this.labels[this.labels.length - 1].viewendpos += this.fcViewLines[n].length();
            ++n;
        }
        this.fcTextPane.rowlength = this.fcViewLines[0].length();
        this.fcTextPane.rownumberlen = this.getRowNumberString(0).length();
    }

    private synchronized void resetView() {
        int n;
        int n2 = 0;
        this.fcViewLines = new StringBuffer[this.fcd.realDataSize / 16];
        int n3 = 0;
        while (n3 < this.fcViewLines.length) {
            this.fcViewLines[n3] = new StringBuffer();
            this.fcViewLines[n3].append(this.getRowNumberString(n3 * 16));
            n2 = n3 * 16;
            n = 0;
            while (n < 16) {
                this.fcViewLines[n3].append(" ");
                String string = this.fcd.getHexString(n2 + n, 1);
                this.fcViewLines[n3].append(string);
                ++n;
            }
            if (n3 < this.fcViewLines.length - 1) {
                this.fcViewLines[n3].append("\n");
            }
            ++n3;
        }
        try {
            n = this.fcTextPane.getCaretPosition();
            this.doc.remove(0, this.doc.getLength());
            int n4 = 0;
            while (n4 < this.fcViewLines.length) {
                if (n4 != this.fcViewLines.length - 1) {
                    this.doc.insertString(this.doc.getLength(), this.fcViewLines[n4].toString(), this.style);
                } else {
                    this.doc.insertString(this.doc.getLength(), this.fcViewLines[n4].toString(), this.style);
                }
                ++n4;
            }
            this.fcTextPane.setCaretPosition(n);
            int n5 = 0;
            while (n5 < this.labels.length) {
                if (this.labels[n5].viewbeginpos <= n && this.labels[n5].viewendpos >= n) {
                    this.coloring(this.labels[n5]);
                }
                ++n5;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String showFileChooser() {
        JFileChooser jFileChooser = this.fcLocationDir == null ? new JFileChooser(".") : new JFileChooser(this.fcLocationDir);
        jFileChooser.setFileFilter(new FaverChipViewFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        switch (n) {
            case 0: {
                this.fcLocationDir = jFileChooser.getCurrentDirectory();
                if (!jFileChooser.getSelectedFile().isFile()) break;
                return jFileChooser.getSelectedFile().getPath();
            }
        }
        return "";
    }

    private void setDataToView() {
        try {
            int n = 0;
            while (n < this.fcViewLines.length) {
                if (n != this.fcViewLines.length - 1) {
                    this.doc.insertString(this.doc.getLength(), this.fcViewLines[n].toString(), this.style);
                } else {
                    this.doc.insertString(this.doc.getLength(), this.fcViewLines[n].toString(), this.style);
                }
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String getRowNumberString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toHexString(n);
        stringBuffer.append("0x");
        int n2 = 0;
        while (n2 < 4 - string.length()) {
            stringBuffer.append("0");
            ++n2;
        }
        stringBuffer.append(string + "  ");
        return stringBuffer.toString();
    }

    private String viewStrToHexStr() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.fcTextPane.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                this.fcViewLines[n].delete(0, this.fcViewLines[n].length());
                this.fcViewLines[n].append(stringTokenizer.nextToken().trim());
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        n = 0;
        while (n < this.fcViewLines.length) {
            String string2 = this.fcViewLines[n].substring(7);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            while (stringTokenizer2.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer2.nextToken().trim());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void coloring(FaverChipViewerLabelInfo faverChipViewerLabelInfo) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        StyleConstants.setForeground(simpleAttributeSet2, Color.gray);
        int n = faverChipViewerLabelInfo.viewbeginpos;
        int n2 = faverChipViewerLabelInfo.viewendpos;
        if (n2 > this.doc.getLength()) {
            n2 = this.doc.getLength();
        }
        this.doc.setCharacterAttributes(0, n, simpleAttributeSet, false);
        this.doc.setCharacterAttributes(n, n2 - n, this.blocks[this.getLineNumber((int)n)].attr, false);
        this.doc.setCharacterAttributes(n2, this.doc.getLength() - n2, simpleAttributeSet, false);
        int n3 = this.fcTextPane.rowlength;
        int n4 = this.fcTextPane.rownumberlen;
        int n5 = 0;
        int n6 = 0;
        while (n5 < this.fcd.realDataSize) {
            this.doc.setCharacterAttributes(n6, n4, simpleAttributeSet2, false);
            n5 += 16;
            n6 += n3;
        }
    }

    private void coloring(FaverChipViewerLabelInfo[] faverChipViewerLabelInfoArray) {
        int n = 9;
        int n2 = 0;
        while (n2 < faverChipViewerLabelInfoArray.length) {
            int n3 = faverChipViewerLabelInfoArray[n2].viewbeginpos;
            int n4 = faverChipViewerLabelInfoArray[n2].viewendpos;
            if (n4 > this.doc.getLength()) {
                n4 = this.doc.getLength();
            }
            if (n3 == 0) {
                n3 += n;
            }
            if (n4 - n3 < 32 || n4 == this.doc.getLength()) {
                this.doc.setCharacterAttributes(n3, n4 - n3, this.blocks[this.getLineNumber((int)n3)].attr, false);
            } else {
                this.doc.setCharacterAttributes(n3, n4 - n3 - n, this.blocks[this.getLineNumber((int)n3)].attr, false);
            }
            ++n2;
        }
    }

    private void showDialog(String string, JFrame jFrame, int n) {
        JOptionPane jOptionPane = new JOptionPane(string, n);
        JDialog jDialog = jOptionPane.createDialog(jFrame, n == 0 ? Resource.getString("ERR") : Resource.getString("WNG"));
        jDialog.setResizable(false);
        ((Component)jDialog).setVisible(true);
    }

    public void initAreaBox() {
        String[] stringArray = this.fcd.getBlockName();
        int n = 0;
        while (n < stringArray.length) {
            this.areaBox.addItem(stringArray[n]);
            ++n;
        }
        this.areaBox.repaint();
    }

    private void initLabelInfo() {
        this.labels = this.fcd.getLabelInfo();
    }

    private byte[] getBlockToByte() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = null;
        try {
            int n = 0;
            while (n < this.blocks.length) {
                byteArrayOutputStream.write(this.blocks[n].blocktype);
                byteArrayOutputStream.write(this.blocks[n].code, 0, this.blocks[n].code.length);
                byteArrayOutputStream.write(this.blocks[n].authority);
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private int getLineNumber(int n) {
        int n2 = 0;
        int n3 = this.fcTextPane.rowlength;
        if (n > 0) {
            n2 = n / n3;
        }
        return n2;
    }

    private int[] getEditLineNumbers() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < this.blocks.length) {
            if (this.blocks[n].editflag) {
                arrayList.add(new Integer(n));
            }
            ++n;
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        int[] nArray = new int[integerArray.length];
        int n2 = 0;
        while (n2 < integerArray.length) {
            nArray[n2] = integerArray[n2];
            ++n2;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    private void resetEditFlag() {
        int n = 0;
        while (n < this.blocks.length) {
            this.blocks[n].editflag = false;
            ++n;
        }
    }

    private void initBlockInfo() {
        byte[] byArray = this.fcd.getManagementInfo();
        byte[] byArray2 = this.fcd.getOriginData();
        ArrayList<FaverChipViewerBlock> arrayList = new ArrayList<FaverChipViewerBlock>();
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                byte[] byArray3 = new byte[]{byArray2[n * 4], byArray2[n * 4 + 1]};
                arrayList.add(new FaverChipViewerBlock(arrayList.size() * 16, byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], byArray3));
                n += 4;
            }
            this.blocks = arrayList.toArray(new FaverChipViewerBlock[0]);
        }
    }

    private void resetBlockInfo() {
        byte[] byArray = this.fcd.getManagementInfo();
        byte[] byArray2 = this.fcd.getOriginData();
        int n = 0;
        if (byArray != null) {
            int n2 = 0;
            while (n2 < this.blocks.length) {
                n = n2 * 4;
                byte[] byArray3 = new byte[]{byArray2[n * 4], byArray2[n * 4 + 1]};
                this.blocks[n2].set(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], byArray3);
                ++n2;
            }
        }
        this.resetEditFlag();
    }

    private void createRightClickMenu() {
        JSeparator jSeparator = new JSeparator();
        this.rightClickMenu = new JPopupMenu();
        this.blockTypeItem = new JMenu(Resource.getString("MENU_CHANGE_BLOCK_TYPE"));
        this.areaItem = new JMenuItem(Resource.getString("MENU_CHANGE_AREA"));
        this.areaItem.setActionCommand("Area");
        this.serviceItem = new JMenuItem(Resource.getString("MENU_CHANGE_SERVICE"));
        this.serviceItem.setActionCommand("Service");
        this.dataItem = new JMenuItem(Resource.getString("MENU_CHANGE_USERDATA"));
        this.dataItem.setActionCommand("UserData");
        this.unuseItem = new JMenuItem(Resource.getString("MENU_CHANGE_UNUSED"));
        this.unuseItem.setActionCommand("Unused");
        this.allUnuseItem = new JMenuItem(Resource.getString("MENU_CHANGE_ALLUNUSED"));
        this.allUnuseItem.setActionCommand("AllUnused");
        ActionListener actionListener = new ActionListener(){

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = FaverChipViewer.this.fcTextPane.getCaretPosition();
                String string = actionEvent.getActionCommand();
                if (!string.equals("AllUnused")) {
                    n = 7;
                    if (string.equals("Area")) {
                        n = 4;
                    } else if (string.equals("Service")) {
                        n = 5;
                    } else if (string.equals("UserData")) {
                        n = 6;
                    } else if (string.equals("Unused")) {
                        n = 0;
                    }
                    int n3 = FaverChipViewer.this.getLineNumber(n2);
                    FaverChipViewer.this.blocks[n3].setBlockType((byte)n);
                    FaverChipViewer.this.blocks[n3].editflag = true;
                    ((FaverChipViewer)FaverChipViewer.this).fcd.editflag = true;
                } else {
                    n = 0;
                    while (n < FaverChipViewer.this.blocks.length) {
                        if (((FaverChipViewer)FaverChipViewer.this).fcd.beginEditArea <= FaverChipViewer.this.blocks[n].begin && FaverChipViewer.this.blocks[n].begin <= ((FaverChipViewer)FaverChipViewer.this).fcd.endEditArea) {
                            FaverChipViewer.this.blocks[n].setBlockType((byte)0);
                            FaverChipViewer.this.blocks[n].editflag = true;
                        }
                        ++n;
                    }
                    ((FaverChipViewer)FaverChipViewer.this).fcd.editflag = true;
                }
                n = 0;
                while (n <= FaverChipViewer.this.labels.length) {
                    if (((FaverChipViewer)FaverChipViewer.this).labels[n].viewbeginpos <= n2 && ((FaverChipViewer)FaverChipViewer.this).labels[n].viewendpos >= n2) {
                        FaverChipViewer.this.coloring(FaverChipViewer.this.labels[n]);
                        break;
                    }
                    ++n;
                }
            }
        };
        this.areaItem.addActionListener(actionListener);
        this.serviceItem.addActionListener(actionListener);
        this.dataItem.addActionListener(actionListener);
        this.unuseItem.addActionListener(actionListener);
        this.allUnuseItem.addActionListener(actionListener);
        this.blockTypeItem.add(this.areaItem);
        this.blockTypeItem.add(this.serviceItem);
        this.blockTypeItem.add(this.dataItem);
        this.blockTypeItem.add(this.unuseItem);
        this.blockTypeItem.add(jSeparator);
        this.blockTypeItem.add(this.allUnuseItem);
        this.rightClickMenu.add(this.blockTypeItem);
    }
}

