/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.scratchpad;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPWindowActionListener;
import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPWindowWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SPWindow
extends JFrame {
    private static final String TITLE = Resource.getString("SP_WINDOW_TITLE");
    private static final int BYTE_PER_ROW = 16;
    private static final String ENCODING = "8859_1";
    private File spLocationDir;
    private JTextArea spTextArea;
    private MainWindow parent = null;
    private File spFile = null;
    private File[] spFileArray = null;
    private int spFileIndex = -1;
    private boolean read_flg = false;
    private JButton previousButton;
    private JButton nextButton;
    private JButton deleteButton;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        SPWindow sPWindow = new SPWindow();
    }

    private SPWindow() {
        try {
            this.spLocationDir = new File(System.getProperty("emu.home") + File.separator + "apps");
        }
        catch (NullPointerException nullPointerException) {
            this.spLocationDir = null;
        }
        String string = this.showFileChooser();
        if (string.equals("")) {
            System.exit(0);
        } else {
            try {
                this.makeSPWindow(new File(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("SP_NOT_FOUND_ERR", string));
                System.exit(0);
            }
            catch (IOException iOException) {
                System.out.println(Resource.format("READ_SP_ERR", string));
                System.exit(0);
            }
            ((Component)this).setVisible(true);
        }
    }

    public SPWindow(MainWindow mainWindow, File[] fileArray) throws FileNotFoundException, IOException {
        try {
            this.spLocationDir = new File(System.getProperty("emu.home") + File.separator + "apps");
        }
        catch (NullPointerException nullPointerException) {
            this.spLocationDir = null;
        }
        this.parent = mainWindow;
        this.spFileArray = fileArray;
        this.spFileIndex = 0;
        this.makeSPWindow(fileArray[0]);
    }

    private void makeSPWindow(File file) throws FileNotFoundException, IOException {
        this.spFile = file;
        this.setTitle(TITLE + " - " + file.getName());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.spTextArea = new JTextArea(16, 56);
        this.spTextArea.setFont(new Font("monospaced", 0, 15));
        JScrollPane jScrollPane = new JScrollPane(this.spTextArea);
        this.previousButton = new JButton(Resource.getString("SP_PREVIOUS"));
        this.nextButton = new JButton(Resource.getString("SP_NEXT"));
        JButton jButton = new JButton(Resource.getString("READ2"));
        this.deleteButton = new JButton(Resource.getString("REMOVE"));
        JButton jButton2 = new JButton(Resource.getString("EXIT"));
        this.previousButton.setActionCommand("previous");
        this.nextButton.setActionCommand("next");
        jButton.setActionCommand("read");
        this.deleteButton.setActionCommand("delete");
        jButton2.setActionCommand("exit");
        this.addWindowListener(new SPWindowWindowAdapter(this));
        SPWindowActionListener sPWindowActionListener = new SPWindowActionListener(this);
        this.spTextArea.setEditable(false);
        this.previousButton.addActionListener(sPWindowActionListener);
        this.nextButton.addActionListener(sPWindowActionListener);
        jButton.addActionListener(sPWindowActionListener);
        this.deleteButton.addActionListener(sPWindowActionListener);
        jButton2.addActionListener(sPWindowActionListener);
        JPanel jPanel = new JPanel();
        jPanel.add(this.previousButton);
        jPanel.add(this.nextButton);
        jPanel.add(jButton);
        jPanel.add(this.deleteButton);
        jPanel.add(jButton2);
        container.add("Center", jScrollPane);
        container.add("South", jPanel);
        this.drawSP(file);
        this.setBtnState();
        this.pack();
    }

    void previous() {
        if (this.read_flg) {
            return;
        }
        this.spTextArea.setText("");
        this.setTitle(TITLE);
        int n = this.spFileIndex - 1;
        while (n >= 0) {
            try {
                if (this.spFileArray[n].exists()) {
                    this.drawSP(this.spFileArray[n]);
                    this.setTitle(TITLE + " - " + this.spFileArray[n].getName());
                    this.spFileIndex = n;
                    this.spFile = this.spFileArray[n];
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = Resource.format("SP_NOT_FOUND_ERR", this.spFileArray[n].getName());
                this.showDialog(string, this, 0);
                return;
            }
            catch (IOException iOException) {
                String string = Resource.format("READ_SP_ERR", this.spFileArray[n].getName());
                this.showDialog(string, this, 0);
                return;
            }
            --n;
        }
        this.setBtnState();
    }

    void next() {
        if (this.read_flg) {
            return;
        }
        this.spTextArea.setText("");
        this.setTitle(TITLE);
        int n = this.spFileIndex + 1;
        while (n < this.spFileArray.length) {
            try {
                if (this.spFileArray[n].exists()) {
                    this.drawSP(this.spFileArray[n]);
                    this.setTitle(TITLE + " - " + this.spFileArray[n].getName());
                    this.spFileIndex = n;
                    this.spFile = this.spFileArray[n];
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = Resource.format("SP_NOT_FOUND_ERR", this.spFileArray[n].getName());
                this.showDialog(string, this, 0);
                return;
            }
            catch (IOException iOException) {
                String string = Resource.format("READ_SP_ERR", this.spFileArray[n].getName());
                this.showDialog(string, this, 0);
                return;
            }
            ++n;
        }
        this.setBtnState();
    }

    private void setBtnState() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (this.read_flg) {
            return;
        }
        int n3 = 0;
        while (n3 < this.spFileArray.length) {
            if (this.spFileArray[n3].exists()) {
                if (!bl) {
                    n = n3;
                    n2 = n3;
                } else {
                    n2 = n3;
                }
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.spTextArea.setText("");
            this.setTitle(TITLE);
        } else {
            if (n < this.spFileIndex) {
                this.previousButton.setEnabled(true);
            } else {
                this.previousButton.setEnabled(false);
            }
            if (n2 > this.spFileIndex) {
                this.nextButton.setEnabled(true);
            } else {
                this.nextButton.setEnabled(false);
            }
        }
    }

    private void readBtnState() {
        this.previousButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.deleteButton.setEnabled(true);
        this.read_flg = true;
    }

    private void deleteToMove() {
        if (this.read_flg) {
            return;
        }
        this.setBtnState();
        if (this.previousButton.isEnabled() && this.nextButton.isEnabled()) {
            this.next();
        } else if (this.previousButton.isEnabled()) {
            this.previous();
        } else if (this.nextButton.isEnabled()) {
            this.next();
        }
    }

    void read() {
        String string = this.showFileChooser();
        if (!string.equals("")) {
            File file = this.spFile;
            String string2 = this.spTextArea.getText();
            this.spFile = new File(string);
            try {
                this.spTextArea.setText("");
                this.drawSP(this.spFile);
                this.setTitle(TITLE + " - " + this.spFile.getName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.spTextArea.setText(string2);
                this.spFile = file;
                this.setTitle(TITLE + " - " + this.spFile.getName());
                String string3 = Resource.format("SP_NOT_FOUND_ERR", this.spFile.getName());
                this.showDialog(string3, this, 0);
                return;
            }
            catch (IOException iOException) {
                this.spTextArea.setText(string2);
                this.spFile = file;
                this.setTitle(TITLE + " - " + this.spFile.getName());
                String string4 = Resource.format("READ_SP_ERR", this.spFile.getName());
                this.showDialog(string4, this, 0);
                return;
            }
            this.readBtnState();
        }
    }

    void delete() {
        if (this.spFile == null) {
            return;
        }
        String string = this.spFile.getName();
        if (this.spFile.exists()) {
            System.out.println(Resource.format("REMOVING_SP", string));
            if (this.spFile.exists()) {
                this.spFile.delete();
            }
            this.spFile = null;
            this.setTitle(TITLE);
            this.spTextArea.setText("");
            System.out.println(Resource.format("FINISH_REMOVE_SP", string));
        } else {
            System.out.println(Resource.format("SP_NOT_FOUND_WNG", string));
        }
        this.deleteToMove();
    }

    void exit() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.parent.closeWindow(this);
        }
    }

    private String showFileChooser() {
        JFileChooser jFileChooser = this.spLocationDir == null ? new JFileChooser(".") : new JFileChooser(this.spLocationDir);
        jFileChooser.setFileFilter(new SPFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        switch (n) {
            case 0: {
                this.spLocationDir = jFileChooser.getCurrentDirectory();
                if (!jFileChooser.getSelectedFile().isFile()) break;
                return jFileChooser.getSelectedFile().getPath();
            }
        }
        return "";
    }

    private void drawSP(File file) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray.length < n2 + 16 ? byArray.length - n2 : 16;
            String string = "0x";
            String string2 = Integer.toHexString(n2);
            int n4 = 0;
            while (n4 < 4 - string2.length()) {
                string = string + "0";
                ++n4;
            }
            string = string + string2 + "  " + this.getHexString(byArray, n2, n3) + "\n";
            this.spTextArea.append(string);
            n2 += 16;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getHexString(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        ByteArrayInputStream byteArrayInputStream;
        block10: {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            byteArrayOutputStream.write(byArray, n, n2);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                try {
                    while (true) {
                        int n3;
                        if ((n3 = byteArrayInputStream.read()) == -1) {
                            object = byteArrayOutputStream.toString(ENCODING);
                            Object var11_12 = null;
                            if (byteArrayOutputStream == null) break block10;
                            break;
                        }
                        object = Integer.toHexString(n3).getBytes(ENCODING);
                        byte[] byArray2 = " ".getBytes(ENCODING);
                        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
                        if (((Object)object).length == 1) {
                            byte[] byArray3 = "0".getBytes(ENCODING);
                            byteArrayOutputStream.write(byArray3, 0, byArray3.length);
                        }
                        byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string = new String("");
                    Object var11_13 = null;
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                    if (byteArrayInputStream == null) return string;
                    byteArrayInputStream.close();
                    return string;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (byteArrayInputStream == null) throw throwable;
                byteArrayInputStream.close();
                throw throwable;
            }
            byteArrayOutputStream.close();
        }
        if (byteArrayInputStream == null) return object;
        byteArrayInputStream.close();
        return object;
    }

    private void showDialog(String string, JFrame jFrame, int n) {
        JOptionPane jOptionPane = new JOptionPane(string, n);
        JDialog jDialog = jOptionPane.createDialog(jFrame, n == 0 ? Resource.getString("ERR") : Resource.getString("WNG"));
        jDialog.setResizable(false);
        ((Component)jDialog).setVisible(true);
    }
}

