/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.FieldInfo;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.LocalVariable;

class DebuggerListener
extends ProxyListener
implements VMConstants {
    static final int UseClassParser = 1;
    SocketConnection connDebugger;
    ProxyListener KVMListener;
    ClassManager manager = null;
    Packet replyPacket;
    Options options;
    boolean Ready = false;
    ServerSocket serverSocket = null;
    Socket acceptSocket = null;

    public DebuggerListener(Options options) {
        this.options = options;
    }

    public void set(ProxyListener proxyListener, ClassManager classManager) {
        this.KVMListener = proxyListener;
        this.manager = classManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void send(Packet packet) throws IOException {
        DebuggerListener debuggerListener = this;
        synchronized (debuggerListener) {
            while (!this.Ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        String string = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if ((packet.flags & 0x80) == 0 && packet.id < 0) {
                this.waitingQueue.put(string, packet);
            }
        }
        this.connDebugger.send(packet);
    }

    public void quit() {
        boolean bl = this.timeToQuit;
        this.timeToQuit = true;
        if (bl != this.timeToQuit) {
            this.KVMListener.quit();
            try {
                if (this.acceptSocket != null) {
                    this.acceptSocket.close();
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block110: {
            var2_1 = null;
            var3_2 = null;
            var4_3 = null;
            try {
                System.out.println("Waiting for debugger on port " + this.options.getLocalPort());
                this.serverSocket = new ServerSocket(this.options.getLocalPort());
                this.acceptSocket = this.serverSocket.accept();
                this.connDebugger = new SocketConnection(this, this.acceptSocket);
                System.out.println("Connection received.");
            }
            catch (IOException var6_4) {
                Runtime.getRuntime().exit(1);
                System.out.println("DebuggerListener: " + var6_4.getMessage());
            }
            catch (SecurityException var7_6) {
                Runtime.getRuntime().exit(1);
                System.out.println("DebuggerListener: " + var7_6.getMessage());
            }
            var6_5 = new String("JDWP-Handshake").getBytes();
            try {
                var7_7 = 0;
                while (var7_7 < var6_5.length) {
                    this.connDebugger.receiveByte();
                    ++var7_7;
                }
                var8_10 = 0;
                while (var8_10 < var6_5.length) {
                    this.connDebugger.sendByte(var6_5[var8_10]);
                    ++var8_10;
                }
            }
            catch (IOException var7_8) {
                // empty catch block
            }
            var7_9 = this;
            synchronized (var7_9) {
                this.Ready = true;
                this.notify();
            }
            new Thread(this.connDebugger).start();
            try {
                while (!this.timeToQuit) {
                    block111: {
                        var1_14 = false;
                        var2_1 = this.waitForPacket();
                        if (var2_1 == null) break block110;
                        if ((var2_1.flags & 128) != 0 || !this.options.getUseClassParser()) break block111;
                        var11_18 = new PacketStream(this, var2_1);
                        switch (var2_1.cmdSet) {
                            case 1: {
                                switch (var2_1.cmd) {
                                    case 1: {
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeString("Version 1.0");
                                        var5_15.writeInt(1);
                                        var5_15.writeInt(0);
                                        var5_15.writeString("1.0.3");
                                        var5_15.writeString("KVM");
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 2: {
                                        var12_20 = var11_18.readString();
                                        Log.LOGN(3, "ClassBySig: class " + var12_20);
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var13_21 = ClassManager.classMap.values().iterator();
                                        while (var13_21.hasNext()) {
                                            try {
                                                var9_12 = (ClassFile)var13_21.next();
                                                if (var9_12 == null) {
                                                    throw new Exception("Couldn't find classFile object");
                                                }
                                                if (var12_20.compareTo(var9_12.getClassSignature()) != 0) continue;
                                                Log.LOGN(3, "ClassBySig matched " + var9_12.getClassName());
                                                Log.LOGN(6, "Class Signature: " + var9_12.getClassSignature());
                                                var5_15.writeInt(1);
                                                var5_15.writeByte(var9_12.getJDWPTypeTag());
                                                var5_15.writeInt(var9_12.getClassID());
                                                var5_15.writeInt(var9_12.getClassStatus());
                                                var5_15.send();
                                                var1_14 = true;
                                                break;
                                            }
                                            catch (Exception var15_23) {
                                                System.out.println("ClassesBySig command failed with " + var15_23);
                                                var14_22 = new PacketStream(this, var11_18.id, 128, 41);
                                                var14_22.send();
                                                var1_14 = true;
                                            }
                                        }
                                        if (var1_14) break;
                                        var5_15.writeInt(0);
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 3: {
                                        Log.LOGN(3, "All_Classes command");
                                        var5_15 = new PacketStream(this.KVMListener, 1, 3);
                                        var17_34 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.send();
                                        try {
                                            var5_15.waitForReply();
                                        }
                                        catch (Exception var18_35) {
                                            var17_34.writeInt(0);
                                            var17_34.send();
                                            var1_14 = true;
                                            break;
                                        }
                                        var18_36 = var5_15.readInt();
                                        var17_34.writeInt(var18_36);
                                        var19_42 = 0;
                                        while (var19_42 < var18_36) {
                                            var16_29 = var5_15.readByte();
                                            var10_16 = var5_15.readInt();
                                            var14_22 = var5_15.readString();
                                            var15_24 = var5_15.readInt();
                                            var17_34.writeByte((byte)var16_29);
                                            var17_34.writeInt(var10_16);
                                            var17_34.writeString((String)var14_22);
                                            var17_34.writeInt(var15_24);
                                            if (var16_29 != 3) {
                                                var14_22 = new String(var14_22.substring(1, var14_22.length() - 1));
                                            }
                                            Log.LOGN(3, "AllClasses:  " + (String)var14_22 + ", ID = " + Integer.toHexString(var10_16));
                                            var9_12 = (ClassFile)ClassManager.classMap.get(new Integer(var10_16));
                                            if (var9_12 != null) ** GOTO lbl136
                                            var9_12 = this.manager.findClass((byte)var16_29, (String)var14_22);
                                            if (var9_12 != null) {
                                                ClassManager.classMap.put(new Integer(var10_16), var9_12);
                                                var9_12.setClassID(var10_16);
                                                var9_12.setClassStatus(var15_24);
                                            } else {
                                                System.out.println("ALL_CLASSES_CMD: couldn't find classfile object");
                                                var17_34 = new PacketStream(this, var11_18.id, 128, 41);
                                                var17_34.send();
                                                var1_14 = true;
                                                break;
lbl136:
                                                // 1 sources

                                                var9_12.setClassStatus(var15_24);
                                            }
                                            ++var19_42;
                                        }
                                        var17_34.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 5: {
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeInt(1);
                                        var5_15.writeInt(-32);
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 6: {
                                        var5_15 = new PacketStream(this.KVMListener, 1, 10);
                                        var5_15.send();
                                        var14_22 = new PacketStream(this, var11_18.id, 128, 0);
                                        var14_22.send();
                                        var1_14 = true;
                                        this.quit();
                                        break;
                                    }
                                    case 7: {
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeInt(8);
                                        var5_15.writeInt(4);
                                        var5_15.writeInt(4);
                                        var5_15.writeInt(4);
                                        var5_15.writeInt(4);
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 12: {
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeBoolean(false);
                                        var5_15.writeBoolean(false);
                                        var5_15.writeBoolean(false);
                                        var5_15.writeBoolean(false);
                                        var5_15.writeBoolean(false);
                                        var5_15.writeBoolean(false);
                                        var5_15.writeBoolean(false);
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 13: {
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeString("");
                                        var5_15.writeInt(0);
                                        var5_15.writeInt(0);
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 14: {
                                        Log.LOGN(3, "Dispose Objects: ");
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.send();
                                        var1_14 = true;
                                    }
                                }
                                break;
                            }
                            case 2: {
                                switch (var2_1.cmd) {
                                    case 1: {
                                        var10_16 = var11_18.readInt();
                                        Log.LOGN(3, "Signature cmd: class id = " + Integer.toHexString(var10_16));
                                        try {
                                            var9_12 = (ClassFile)ClassManager.classMap.get(new Integer(var10_16));
                                            if (var9_12 == null) {
                                                throw new Exception("Couldn't get ClassFile object for signature cmd");
                                            }
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                            if (var10_16 == -32) {
                                                var5_15.writeString("Lkvm_threadgroup;");
                                            } else {
                                                var5_15.writeString(var9_12.getClassSignature());
                                            }
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                        catch (Exception var15_25) {
                                            System.out.println("Signature cmd: exception " + var15_25);
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 41);
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                        break;
                                    }
                                    case 2: {
                                        var11_18.readInt();
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeInt(0);
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 3: {
                                        var10_16 = var11_18.readInt();
                                        try {
                                            var9_12 = (ClassFile)ClassManager.classMap.get(new Integer(var10_16));
                                            if (var9_12 == null) {
                                                throw new Exception("Couldn't get ClassFile object for Modifiers cmd");
                                            }
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                            var5_15.writeInt(var9_12.getRawAccessFlags());
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                        catch (Exception var15_26) {
                                            System.out.println("Modifiers cmd: exception " + var15_26);
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 41);
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                        break;
                                    }
                                    case 4: {
                                        var10_16 = var11_18.readInt();
                                        Log.LOGN(3, "field command: cid = " + Integer.toHexString(var10_16));
                                        var9_12 = (ClassFile)ClassManager.classMap.get(new Integer(var10_16));
                                        if (var9_12 == null) {
                                            Log.LOGN(3, "field_cmd: cf == null");
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                            var5_15.writeInt(0);
                                            var5_15.send();
                                            var1_14 = true;
                                            break;
                                        }
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        if (this.processFields(var9_12, var5_15, var11_18.id)) {
                                            var5_15.send();
                                        }
                                        var1_14 = true;
                                        break;
                                    }
                                    case 5: {
                                        var10_16 = var11_18.readInt();
                                        Log.LOGN(3, "methods command: cid = " + Integer.toHexString(var10_16));
                                        var9_12 = (ClassFile)ClassManager.classMap.get(new Integer(var10_16));
                                        if (var9_12 == null || var9_12.getJDWPTypeTag() == 3) {
                                            Log.LOGN(3, "methods_cmd: cf == null or cf == arrayclass");
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                            var5_15.writeInt(0);
                                            var5_15.send();
                                            var1_14 = true;
                                            break;
                                        }
                                        Log.LOGN(3, "methods for " + var9_12.getClassFileName());
                                        try {
                                            var16_29 = 0;
                                            var17_34 = var9_12.getAllMethodInfo();
                                            var18_37 = var17_34.iterator();
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                            Log.LOGN(5, "Methods: " + var17_34.size() + " methods");
                                            var5_15.writeInt(var17_34.size());
                                            while (var18_37.hasNext()) {
                                                var15_27 = (MethodInfo)var18_37.next();
                                                if (var15_27 == null) {
                                                    throw new Exception("methodinfo null");
                                                }
                                                Log.LOGN(5, "Method: id = " + Integer.toHexString(var16_29));
                                                var5_15.writeInt(var16_29++);
                                                Log.LOGN(5, "Method: name = " + var15_27.getName());
                                                var5_15.writeString(var15_27.getName());
                                                Log.LOGN(5, "Method: sig = " + var15_27.getSignatureRaw());
                                                var5_15.writeString(var15_27.getSignatureRaw());
                                                Log.LOGN(5, "Method: flags = " + var15_27.getAccessFlags());
                                                var5_15.writeInt(var15_27.getAccessFlags());
                                            }
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                        catch (Exception var15_28) {
                                            System.out.println("Methods cmd: exception " + var15_28);
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 41);
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                        break;
                                    }
                                    case 7: {
                                        Log.LOGN(3, "Source file cmd");
                                        var10_16 = var11_18.readInt();
                                        try {
                                            var9_12 = (ClassFile)ClassManager.classMap.get(new Integer(var10_16));
                                            if (var9_12 == null) {
                                                throw new Exception("Couldn't get ClassFile object for Modifiers cmd");
                                            }
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                            var15_27 = var9_12.getSourceAttribute();
                                            if (var15_27 != null) {
                                                var16_30 = var15_27.getSourceFileName();
                                                Log.LOGN(3, "Returning from attribute: " + var16_30);
                                                var5_15.writeString(var16_30);
                                            } else {
                                                Log.LOGN(3, "Creating source name: " + var9_12.getBaseName() + ".java");
                                                var5_15.writeString(var9_12.getBaseName() + ".java");
                                            }
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                        catch (Exception var16_31) {
                                            System.out.println("Sourcefile cmd: exception " + var16_31);
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 41);
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                        break;
                                    }
                                    case 10: {
                                        var10_16 = var11_18.readInt();
                                        try {
                                            var9_12 = (ClassFile)ClassManager.classMap.get(new Integer(var10_16));
                                            if (var9_12 == null) {
                                                throw new Exception("Couldn't get ClassFile object for Interfaces cmd");
                                            }
                                            var16_32 = var9_12.getAllInterfaces();
                                            var17_34 = var16_32.iterator();
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                            Log.LOGN(3, "Interfaces: class " + var9_12.getClassName() + " " + var16_32.size() + " interfaces");
                                            var5_15.writeInt(var16_32.size());
                                            while (var17_34.hasNext()) {
                                                var18_38 = (String)var17_34.next();
                                                Log.LOGN(3, "interfaces: classname: " + var18_38);
                                                if (var18_38 == null) {
                                                    throw new Exception("interface name null");
                                                }
                                                var9_12 = this.manager.findClass((byte)76, var18_38);
                                                if (var9_12 == null) {
                                                    var5_15.writeInt(0);
                                                    continue;
                                                }
                                                var5_15.writeInt(var9_12.getClassID());
                                            }
                                            var5_15.send();
                                            var1_14 = true;
                                            break;
                                        }
                                        catch (Exception var16_33) {
                                            System.out.println("Interfaces cmd: exception " + var16_33);
                                            var5_15 = new PacketStream(this, var11_18.id, 128, 41);
                                            var5_15.send();
                                            var1_14 = true;
                                        }
                                    }
                                }
                                break;
                            }
                            case 6: {
                                switch (var2_1.cmd) {
                                    case 1: {
                                        this.handleLineTable(var11_18);
                                        var1_14 = true;
                                        break;
                                    }
                                    case 2: {
                                        this.handleVariableTable(var11_18);
                                        var1_14 = true;
                                        break;
                                    }
                                    case 3: {
                                        this.handleByteCode(var11_18);
                                        var1_14 = true;
                                    }
                                }
                                break;
                            }
                            case 11: {
                                switch (var2_1.cmd) {
                                    case 5: {
                                        Log.LOGN(3, "Threadreference: threadgroup");
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeInt(-32);
                                        var5_15.send();
                                        var1_14 = true;
                                    }
                                }
                                break;
                            }
                            case 12: {
                                switch (var2_1.cmd) {
                                    case 1: {
                                        var11_18.readInt();
                                        Log.LOGN(3, "ThreadGroup: name");
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeString("KVM_System");
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 2: {
                                        var16_29 = var11_18.readInt();
                                        Log.LOGN(3, "ThreadGroup: parent");
                                        var5_15 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeInt(0);
                                        var5_15.send();
                                        var1_14 = true;
                                        break;
                                    }
                                    case 3: {
                                        var16_29 = var11_18.readInt();
                                        Log.LOGN(3, "ThreadGroup: children");
                                        var17_34 = new PacketStream(this, var11_18.id, 128, 0);
                                        if (var16_29 == -32) {
                                            var5_15 = new PacketStream(this.KVMListener, 1, 4);
                                            var5_15.send();
                                            try {
                                                var5_15.waitForReply();
                                            }
                                            catch (Exception var18_39) {
                                                var17_34.writeInt(0);
                                                var17_34.writeInt(0);
                                                var17_34.send();
                                                var1_14 = true;
                                                break;
                                            }
                                            var18_40 = var5_15.readInt();
                                            Log.LOGN(3, "threadgroup: " + var18_40 + " children");
                                            var17_34.writeInt(var18_40);
                                            while (var18_40-- > 0) {
                                                var17_34.writeInt(var5_15.readInt());
                                            }
                                        } else {
                                            var17_34.writeInt(0);
                                        }
                                        var17_34.writeInt(0);
                                        var17_34.send();
                                        var1_14 = true;
                                    }
                                }
                                break;
                            }
                            case 16: {
                                switch (var2_1.cmd) {
                                    case 3: {
                                        Log.LOGN(3, "Stackframe: thisobject");
                                        var18_41 = var11_18.readInt();
                                        var19_42 = var11_18.readInt();
                                        var5_15 = new PacketStream(this.KVMListener, 16, 1);
                                        var20_43 = new PacketStream(this, var11_18.id, 128, 0);
                                        var5_15.writeInt(var18_41);
                                        var5_15.writeInt(var19_42);
                                        var5_15.writeInt(1);
                                        var5_15.writeInt(0);
                                        var5_15.writeByte((byte)76);
                                        var5_15.send();
                                        try {
                                            var5_15.waitForReply();
                                        }
                                        catch (Exception var21_44) {
                                            var20_43.writeByte((byte)76);
                                            var20_43.writeInt(0);
                                            var20_43.send();
                                            var1_14 = true;
                                            break;
                                        }
                                        var21_45 = var5_15.readInt();
                                        var22_46 = var5_15.readByte();
                                        var23_47 = var5_15.readInt();
                                        Log.LOGN(3, "Stackframe: thisobject tag: " + var22_46 + " objectID " + var23_47);
                                        var20_43.writeByte(var22_46);
                                        var20_43.writeInt(var23_47);
                                        var20_43.send();
                                        var1_14 = true;
                                    }
                                }
                                break;
                            }
                            case 17: {
                                switch (var2_1.cmd) {
                                    case 1: {
                                        var24_48 = var11_18.readInt();
                                        var25_49 = new PacketStream(this, var11_18.id, 128, 0);
                                        var9_12 = (ClassFile)ClassManager.classMap.get(new Integer(var24_48));
                                        if (var9_12 == null) {
                                            var25_49.writeByte((byte)1);
                                        } else {
                                            var25_49.writeByte(var9_12.getJDWPTypeTag());
                                        }
                                        var25_49.writeInt(var24_48);
                                        var25_49.send();
                                        var1_14 = true;
                                    }
                                }
                            }
                        }
                    }
                    if (var1_14) continue;
                    Log.LOG(3, "DebuggerListener: ");
                    this.disp(var2_1);
                    if (var2_1.cmdSet == 15 && var2_1.cmd == 1) {
                        Log.LOG(3, "EventKind == " + var2_1.data[0] + "\n");
                    }
                    if (var2_1.cmdSet == 1 && var2_1.cmd == 9) {
                        Thread.sleep(1000L);
                    }
                    this.KVMListener.send(var2_1);
                }
            }
            catch (IOException var9_13) {
            }
            catch (ArrayIndexOutOfBoundsException var10_17) {
                System.out.println(var2_1.cmdSet + "/" + var2_1.cmd + " caused: " + var10_17);
            }
            catch (InterruptedException var11_19) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return new String("DebuggerListener: ");
    }

    protected String getClassName(byte[] byArray) {
        return new String("");
    }

    protected String getMethodName(byte[] byArray) {
        return new String("");
    }

    protected boolean processFields(ClassFile classFile, PacketStream packetStream, int n) {
        Log.LOGN(3, "processFields for " + classFile.getClassFileName());
        try {
            List list = classFile.getAllFieldInfo();
            Iterator iterator = list.iterator();
            long l = (long)classFile.getClassID() << 32;
            Log.LOGN(5, "field class id is " + Integer.toHexString(classFile.getClassID()) + " fieldid is " + Long.toHexString(l));
            packetStream.writeInt(list.size());
            while (iterator.hasNext()) {
                FieldInfo fieldInfo = (FieldInfo)iterator.next();
                if (fieldInfo == null) {
                    throw new Exception("fieldinfo null");
                }
                Log.LOGN(5, "Field: id = " + Long.toHexString(l));
                packetStream.writeLong(l++);
                Log.LOGN(5, "Field: name = " + fieldInfo.getName());
                packetStream.writeString(fieldInfo.getName());
                Log.LOGN(5, "Field: sig = " + fieldInfo.getType());
                packetStream.writeString(fieldInfo.getType());
                Log.LOGN(5, "Field: flags = " + fieldInfo.getAccessFlags());
                packetStream.writeInt(fieldInfo.getAccessFlags());
            }
        }
        catch (Exception exception) {
            System.out.println("Fields cmd: exception " + exception);
            packetStream = new PacketStream(this, n, 128, 41);
            packetStream.send();
            return false;
        }
        return true;
    }

    public void handleLineTable(PacketStream packetStream) throws IOException {
        ClassFile classFile = null;
        int n = packetStream.readInt();
        int n2 = packetStream.readInt();
        Log.LOGN(4, "linetable: class id= " + Integer.toHexString(n) + ", method id= " + Integer.toHexString(n2));
        classFile = (ClassFile)ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            Log.LOGN(3, "Linetable cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream2.send();
            return;
        }
        Log.LOGN(4, "linetable: class: " + classFile.getClassFileName());
        int[][] nArray = null;
        PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 0);
        try {
            MethodInfo methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo != null) {
                nArray = methodInfo.getBreakableLineNumbers();
            } else {
                System.out.println("Couldn't find methodinfo for index " + n2);
                packetStream3 = new PacketStream(this, packetStream.id, 128, 23);
                packetStream3.send();
            }
            if (nArray == null) {
                System.out.println("No linenumber table found for class " + classFile.getClassName());
                packetStream3 = new PacketStream(this, packetStream.id, 128, 41);
                packetStream3.send();
                return;
            }
        }
        catch (Exception exception) {
            System.out.println(" class" + classFile.getClassName() + " caused " + exception);
            packetStream3 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream3.send();
            return;
        }
        packetStream3.writeLong(nArray[0][1]);
        packetStream3.writeLong(nArray[nArray.length - 1][1]);
        packetStream3.writeInt(nArray.length);
        int n3 = 0;
        while (n3 < nArray.length) {
            packetStream3.writeLong(nArray[n3][1]);
            packetStream3.writeInt(nArray[n3][0]);
            Log.LOGN(5, "  index=" + nArray[n3][1] + " l#=" + nArray[n3][0]);
            ++n3;
        }
        packetStream3.send();
    }

    public void handleVariableTable(PacketStream packetStream) throws IOException {
        List list = null;
        MethodInfo methodInfo = null;
        int n = packetStream.readInt();
        Log.LOG(3, "variable: class id=" + Integer.toHexString(n) + "\n");
        int n2 = packetStream.readInt();
        Log.LOG(3, "variable: method id=" + Integer.toHexString(n2) + "\n");
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            Log.LOGN(3, "Variabletable cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream2.send();
            return;
        }
        try {
            list = classFile.getVariableTableForMethodIndex(n2);
            methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo == null) {
                throw new Exception("couldn't find method info for class " + classFile.getClassFileName());
            }
        }
        catch (Exception exception) {
            System.out.println("class " + classFile.getClassName() + " caused " + exception);
            PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream3.send();
            return;
        }
        PacketStream packetStream4 = new PacketStream(this, packetStream.id, 128, 0);
        packetStream4.writeInt(methodInfo.getArgCount());
        if (list != null) {
            packetStream4.writeInt(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LocalVariable localVariable = (LocalVariable)iterator.next();
                packetStream4.writeLong(localVariable.getCodeIndex());
                packetStream4.writeString(localVariable.getName());
                packetStream4.writeString(this.getJNISignature(localVariable.getType()));
                packetStream4.writeInt(localVariable.getLength());
                packetStream4.writeInt(localVariable.getSlot());
            }
        } else {
            packetStream4.writeInt(0);
        }
        packetStream4.send();
    }

    private void handleByteCode(PacketStream packetStream) {
        MethodInfo methodInfo = null;
        Log.LOG(1, "Method: Bytecodes\n");
        Object var7_3 = null;
        int n = packetStream.readInt();
        Log.LOG(3, "class id=" + Integer.toHexString(n) + "\n");
        int n2 = packetStream.readInt();
        Log.LOG(3, "method id=" + Integer.toHexString(n2) + "\n");
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            Log.LOGN(3, "Bytecode cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream2.send();
            return;
        }
        try {
            methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo == null) {
                throw new Exception("couldn't find method info for class " + classFile.getClassFileName());
            }
        }
        catch (Exception exception) {
            System.out.println(" class" + classFile.getClassFileName() + " caused " + exception);
            PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 41);
            packetStream3.send();
            return;
        }
        byte[] byArray = methodInfo.getCodeAttribute().getByteCodes();
        PacketStream packetStream4 = new PacketStream(this, packetStream.id, 128, 0);
        packetStream4.writeInt(byArray.length);
        packetStream4.writeByteArray(byArray);
        packetStream4.send();
    }

    private String getJNISignature(String string) {
        int n;
        int n2 = n = string.length();
        String string2 = new String();
        Log.LOGN(6, "getJNISignature()  type == " + string);
        while ((n = string.lastIndexOf("[]", n)) != -1) {
            string2 = string2 + "[";
            n2 = n--;
        }
        String string3 = string.substring(0, n2);
        string2 = "int".equalsIgnoreCase(string3) ? string2 + "I" : ("boolean".equalsIgnoreCase(string3) ? string2 + "Z" : ("short".equalsIgnoreCase(string3) ? string2 + "S" : ("byte".equalsIgnoreCase(string3) ? string2 + "B" : ("char".equalsIgnoreCase(string3) ? string2 + "C" : ("long".equalsIgnoreCase(string3) ? string2 + "J" : ("float".equalsIgnoreCase(string3) ? string2 + "F" : ("double".equalsIgnoreCase(string3) ? string2 + "D" : string2 + "L" + string3.replace('.', '/') + ";")))))));
        return string2;
    }
}

