/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.File;
import kdp.DebuggerListener;
import kdp.KVMListener;
import kdp.Log;
import kdp.Options;
import kdp.classparser.ClassManager;
import kdp.classparser.SearchPath;

public class KVMDebugProxy {
    Options options = null;

    public boolean parseArgs(String[] stringArray) {
        int n = 0;
        this.options = new Options();
        this.options.setLocalPort(0);
        this.options.setRemotePort(2800);
        this.options.setRemoteHost("localhost");
        this.options.setVerbosity(0);
        this.options.setClassPath("./");
        this.options.setUseClassParser(false);
        if (stringArray.length == 0) {
            this.options = null;
        }
        try {
            while (n < stringArray.length) {
                if ("-l".equals(stringArray[n])) {
                    this.options.setLocalPort(Integer.parseInt(stringArray[++n]));
                } else if ("-r".equals(stringArray[n])) {
                    this.options.setRemoteHost(stringArray[++n]);
                    this.options.setRemotePort(Integer.parseInt(stringArray[++n]));
                } else if ("-v".equals(stringArray[n])) {
                    this.options.setVerbosity(Integer.parseInt(stringArray[++n]));
                } else if ("-cp".equals(stringArray[n]) || "-classpath".equals(stringArray[n])) {
                    this.options.setClassPath(stringArray[++n]);
                } else if ("-p".equals(stringArray[n])) {
                    this.options.setUseClassParser(true);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.options = null;
        }
        return this.options != null;
    }

    public void help() {
        System.out.println("J2ME Debug Agent Copyright (c) 2000 Sun Microsystems, Inc. All rights reserved.");
        System.out.println();
        System.out.println("Usage: KVMDebugProxy -l <localport> -r <remotehost> <remoteport> [-p]");
        System.out.println("        [-v <level>] [-cp | - classpath <classpath:classpath...>]");
        System.out.println("Where:");
        System.out.println("  -l <localport> specifies the local port number that the debug agent will");
        System.out.println("     listen on for a connection from a debugger.");
        System.out.println("  -r <remotehost> <remoteport> is the hostname and port number that the debug");
        System.out.println("     agent will use to connect to the Java VM running the application");
        System.out.println("     being debugged");
        System.out.println("  -p tells the debug agent to process classfiles on behalf of the Java VM ");
        System.out.println("     running the application being debugged.  If not present, all commands");
        System.out.println("     from the debugger are passed down to the Java VM running the application");
        System.out.println("  -v <level> turns on verbose mode.  'level' specifies the amount of output,");
        System.out.println("     the larger the number the more output that is generated.");
        System.out.println("     'level' can be from 1-9.");
        System.out.println("  -cp or -classpath specifies a list of paths separated by " + File.pathSeparator + " where the");
        System.out.println("     debug agent can find copies of the class files.  Only needed if -p is set.");
        System.out.println();
    }

    public int go() {
        if (this.options == null) {
            return 1;
        }
        Log.SET_LOG(this.options.getVerbosity());
        try {
            ClassManager classManager = new ClassManager(new SearchPath(this.options.getClassPath()));
            System.out.println("Connecting to " + this.options.getRemoteHost() + " on port " + this.options.getRemotePort());
            DebuggerListener debuggerListener = new DebuggerListener(this.options);
            KVMListener kVMListener = new KVMListener(this.options);
            debuggerListener.set(kVMListener, classManager);
            kVMListener.set(debuggerListener, classManager);
            debuggerListener.verbose(this.options.getVerbosity());
            kVMListener.verbose(this.options.getVerbosity());
            new Thread(debuggerListener).start();
            new Thread(kVMListener).start();
        }
        catch (SecurityException securityException) {
            System.out.println("KVMDebugProxy: " + securityException.getMessage());
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        KVMDebugProxy kVMDebugProxy = new KVMDebugProxy();
        if (!kVMDebugProxy.parseArgs(stringArray)) {
            kVMDebugProxy.help();
            System.exit(1);
        }
        kVMDebugProxy.go();
    }
}

