/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Map;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.LineNumberTableAttribute;

class KVMListener
extends ProxyListener
implements VMConstants {
    SocketConnection connKvm;
    ProxyListener debuggerListener = null;
    ClassManager manager;
    Options options;
    boolean Ready = false;
    boolean useClassParser = false;
    Socket remoteSocket = null;

    public KVMListener(Options options) {
        this.options = options;
        this.useClassParser = options.getUseClassParser();
    }

    public void set(ProxyListener proxyListener, ClassManager classManager) {
        this.debuggerListener = proxyListener;
        this.manager = classManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void send(Packet packet) throws IOException {
        KVMListener kVMListener = this;
        synchronized (kVMListener) {
            while (!this.Ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        String string = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if ((packet.flags & 0x80) == 0 && packet.id < 0) {
                this.waitingQueue.put(string, packet);
            }
        }
        this.connKvm.send(packet);
    }

    public void quit() {
        boolean bl = this.timeToQuit;
        this.timeToQuit = true;
        if (bl != this.timeToQuit) {
            try {
                if (this.remoteSocket != null) {
                    this.remoteSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.debuggerListener.quit();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block47: {
            block46: {
                while (true) {
                    while (true) {
                        if (this.remoteSocket != null) {
                            this.connKvm = new SocketConnection(this, this.remoteSocket);
                            break block46;
                        }
                        try {
                            this.remoteSocket = new Socket(this.options.getRemoteHost(), this.options.getRemotePort());
                        }
                        catch (ConnectException var8_1) {
                            System.err.println("KVM not ready");
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException var9_4) {
                                // empty catch block
                            }
                        }
                    }
                    break;
                }
                catch (IOException var8_2) {
                    System.out.println("KVMListener: " + var8_2.getMessage());
                }
                catch (SecurityException var9_5) {
                    System.out.println("KVMListener: " + var9_5.getMessage());
                }
            }
            var8_3 = this;
            synchronized (var8_3) {
                this.Ready = true;
                this.notify();
                if (this.useClassParser) break block47;
            }
            var10_7 = new String("JDWP-Handshake").getBytes();
            try {
                var11_10 = 0;
                while (true) {
                    block48: {
                        if (var11_10 < ((byte[])var10_7).length) break block48;
                        var12_14 = 0;
                        if (true) ** GOTO lbl47
                    }
                    this.connKvm.sendByte(var10_7[var11_10]);
                    ++var11_10;
                }
            }
            catch (IOException var11_11) {
                // empty catch block
                break block47;
            }
            do {
                this.connKvm.receiveByte();
                ++var12_14;
lbl47:
                // 2 sources

            } while (var12_14 < ((byte[])var10_7).length);
        }
        new Thread(this.connKvm).start();
        if (this.useClassParser) {
            var2_16 = new PacketStream(this, 128, 1);
            var2_16.writeString("KVM Reference Debugger Agent");
            var2_16.writeByte((byte)1);
            var2_16.writeByte((byte)1);
            var2_16.send();
            try {
                var2_16.waitForReply();
            }
            catch (Exception var10_8) {
                System.out.println("Exception during handshake: " + var10_8 + " exiting...");
                Runtime.getRuntime().exit(1);
            }
            var10_7 = var2_16.readString();
            var11_12 = var2_16.readInt();
            Log.LOGN(1, "KVM Handshake return string: " + (String)var10_7);
            Log.LOGN(1, "KVM Handshake return options: " + var11_12);
            var2_16 = new PacketStream(this, 1, 3);
            var2_16.send();
            try {
                var2_16.waitForReply();
            }
            catch (Exception var12_15) {
                System.out.println("Couldn't get list of classes from KVM");
            }
            var12_14 = var2_16.readInt();
            Log.LOGN(2, var12_14 + " classes");
            var13_17 = 0;
            while (var13_17 < var12_14) {
                var3_18 = var2_16.readByte();
                var4_19 = var2_16.readInt();
                var5_20 = var2_16.readString();
                if (var3_18 != 3) {
                    var5_20 = new String(var5_20.substring(1, var5_20.length() - 1));
                }
                var6_21 = var2_16.readInt();
                var7_22 = (ClassFile)ClassManager.classMap.get(new Integer(var4_19));
                if (var7_22 == null) {
                    Log.LOGN(3, "allclasses: new class: " + var5_20 + " " + Integer.toHexString(var4_19));
                    var7_22 = this.manager.findClass(var3_18, var5_20);
                    if (var7_22 != null) {
                        var7_22.setClassID(var4_19);
                        var7_22.setClassStatus(var6_21);
                        ClassManager.classMap.put(new Integer(var4_19), var7_22);
                    } else {
                        Log.LOGN(3, "allclasses: couldn't find class " + var5_20);
                    }
                }
                ++var13_17;
            }
        }
        try {
            while (true) {
                if (this.timeToQuit) {
                    return;
                }
                var1_23 = false;
                var11_13 = this.waitForPacket();
                if (var11_13 == null) {
                    return;
                }
                if (this.useClassParser && (var11_13.flags & 128) == 0) {
                    block9 : switch (var11_13.cmdSet) {
                        case 64: {
                            switch (var11_13.cmd) {
                                case 100: {
                                    var10_7 = new PacketStream(this, var11_13);
                                    var12_14 = var10_7.readByte();
                                    var13_17 = var10_7.readInt();
                                    var14_24 = var10_7.readByte();
                                    if (var14_24 != 8) break block9;
                                    var15_25 = var10_7.readInt();
                                    var16_26 = var10_7.readInt();
                                    var3_18 = var10_7.readByte();
                                    var4_19 = var10_7.readInt();
                                    var5_20 = var10_7.readString();
                                    var6_21 = var10_7.readInt();
                                    if (var3_18 != 3) {
                                        var5_20 = new String(var5_20.substring(1, var5_20.length() - 1));
                                    }
                                    Log.LOGN(3, "ClassPrepare:  " + var5_20 + ", ID = " + Integer.toHexString(var4_19));
                                    var7_22 = (ClassFile)ClassManager.classMap.get(new Integer(var4_19));
                                    if (var7_22 == null) {
                                        var7_22 = this.manager.findClass(var3_18, var5_20);
                                        if (var7_22 != null) {
                                            ClassManager.classMap.put(new Integer(var4_19), var7_22);
                                            var7_22.setClassID(var4_19);
                                            var7_22.setClassStatus(var6_21);
                                            break;
                                        }
                                        Log.LOGN(3, "ClassPrepare: null cf!");
                                        break;
                                    }
                                    Log.LOGN(3, "ClassPrepare: got classfile " + var7_22.getClassName());
                                    var7_22.setClassStatus(var6_21);
                                }
                            }
                            break;
                        }
                        case 128: {
                            switch (var11_13.cmd) {
                                case 3: {
                                    var10_7 = new PacketStream(this, var11_13);
                                    this.handleSteppingInfo((PacketStream)var10_7);
                                    var1_23 = true;
                                }
                            }
                            break;
                        }
                    }
                }
                if (var1_23) continue;
                Log.LOG(3, "KVMListener:: ");
                this.disp(var11_13);
                if (var11_13.cmdSet == 64 && var11_13.cmd == 100) {
                    Log.LOGN(3, "Eventkind = " + var11_13.data[5]);
                }
                this.debuggerListener.send(var11_13);
            }
        }
        catch (IOException var10_9) {
            // empty catch block
        }
    }

    private void handleSteppingInfo(PacketStream packetStream) {
        int n;
        long l;
        long l2;
        long l3;
        MethodInfo methodInfo;
        int n2 = packetStream.readInt();
        int n3 = packetStream.readInt();
        int n4 = packetStream.readInt();
        long l4 = packetStream.readLong();
        PacketStream packetStream2 = new PacketStream(this, 128, 2);
        packetStream2.writeInt(n2);
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n3));
        if (classFile == null || (methodInfo = classFile.getMethodInfoByIndex(n4)) == null) {
            packetStream2.writeLong(0L);
            packetStream2.writeLong(0L);
            packetStream2.send();
            try {
                packetStream2.waitForReply();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        LineNumberTableAttribute lineNumberTableAttribute = methodInfo.getCodeAttribute().getLineNumberTable();
        if (lineNumberTableAttribute == null) {
            l3 = -1L;
            l2 = -1L;
            l = -1L;
            n = -1;
            int n5 = -1;
            int n6 = -1;
        } else {
            n = lineNumberTableAttribute.getCurrentLineCodeIndex(l4);
            int n7 = lineNumberTableAttribute.getNextExecutableLineCodeIndex(l4);
            int n8 = lineNumberTableAttribute.getDupCurrentExecutableLineCodeIndex(l4);
            l = lineNumberTableAttribute.getStartPCFromIndex(n7);
            l2 = lineNumberTableAttribute.getStartPCFromIndex(n8);
            l3 = lineNumberTableAttribute.getOffsetofDupNextLine(n8);
        }
        Log.LOGN(3, "handleSteppingInfo  current offset = " + l4);
        Log.LOGN(3, "handleSteppingInfo  target offset = " + l);
        Log.LOGN(3, "handleSteppingInfo  dup current line offset = " + l2);
        Log.LOGN(3, "handleSteppingInfo  offset after current dup = " + l3);
        Log.LOGN(3, "handleSteppingInfo current line number = " + lineNumberTableAttribute.getLineNumberFromIndex(n));
        packetStream2.writeLong(l);
        packetStream2.writeLong(l2);
        packetStream2.writeLong(l3);
        packetStream2.send();
        try {
            packetStream2.waitForReply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return new String("KVMListener: ");
    }
}

