/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kdp.Log;
import kdp.Packet;

abstract class ProxyListener
extends Thread {
    int verbose = 0;
    Map waitingQueue = new HashMap(8, 0.75f);
    private List packetQueue;
    boolean timeToQuit = false;
    String[][] VMcmds = new String[][]{{""}, {"Virtual Machine", "Version", "ClassBySignature", "AllClasses", "AllThreads", "TopLevelThreadGroups", "Dispose", "IDSizes", "Suspend", "Resume", "Exit", "CreateString", "Capabilities", "ClassPaths", "DisposeObjects", "HoldEvents", "ReleaseEvents"}, {"ReferenceType", "Signature", "ClassLoader", "Modifiers", "Fields", "Methods", "GetValues", "SourceFile", "NestedTypes", "Status", "Interfaces", "ClassObject"}, {"ClassType", "Superclass", "SetValues", "InvokeMethod", "NewInstance"}, {"ArrayType", "NewInstance"}, {"InterfaceType", ""}, {"Method", "LineTable", "VariableTable", "Bytecodes"}, {"UNUSED", "UNUSED"}, {"Field", ""}, {"ObjectReference", "ReferenceType", "GetValues", "SetValues", "UNUSED", "MonitorInfo", "InvokeMethod", "DisableCollection", "EnableCollection", "IsCollected"}, {"StringReference", "Value"}, {"ThreadReference", "Name", "Suspend", "Resume", "Status", "ThreadGroup", "Frames", "FrameCount", "OwnedMonitors", "CurrentCountendedMonitor", "Stop", "Interrupt", "SuspendCount"}, {"ThreadGroupReference", "Name", "Parent", "Children"}, {"ArrayReference", "Length", "GetValues", "SetValues"}, {"ClassLoaderReference", "VisibleClasses"}, {"EventRequest", "Set", "Clear", "ClearAllBreakpoints"}, {"StackFrame", "GetValues", "SetValues", "ThisObject"}, {"ClassObjectReference", "ReflectedType"}};
    String[][] DBGcmds = new String[][]{{"Event", "Composite"}};
    String[][] VENcmds = new String[][]{{"Vender-Specific", "UNKNOWN"}};

    public ProxyListener() {
        this.packetQueue = Collections.synchronizedList(new LinkedList());
    }

    public void newPacket(Packet packet) {
        if (packet == null) {
            this.quit();
            List list = this.packetQueue;
            synchronized (list) {
                this.packetQueue.notify();
            }
            return;
        }
        List list = this.packetQueue;
        synchronized (list) {
            this.packetQueue.add(packet);
            this.packetQueue.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Packet waitForPacket() {
        List list = this.packetQueue;
        // MONITORENTER : list
        while (!this.timeToQuit && this.packetQueue.size() == 0) {
            try {
                this.packetQueue.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : list
        if (!this.timeToQuit) return (Packet)this.packetQueue.remove(0);
        return null;
    }

    void replyReceived(Packet packet) {
        Packet packet2;
        if (packet == null) {
            this.quit();
            Map map = this.waitingQueue;
            synchronized (map) {
                Iterator iterator = this.waitingQueue.values().iterator();
                while (iterator.hasNext()) {
                    Packet packet3 = (Packet)iterator.next();
                    packet3.notify();
                }
            }
            return;
        }
        String string = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            packet2 = (Packet)this.waitingQueue.get(string);
            if (packet2 != null) {
                this.waitingQueue.remove(string);
            }
        }
        if (packet2 == null) {
            System.err.println("Received reply with no sender!");
            return;
        }
        packet2.errorCode = packet.errorCode;
        packet2.data = packet.data;
        packet2.replied = true;
        Packet packet4 = packet2;
        synchronized (packet4) {
            packet2.notify();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForReply(Packet packet) {
        Packet packet2 = packet;
        synchronized (packet2) {
            while (!this.timeToQuit && !packet.replied) {
                try {
                    packet.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (packet.replied) return;
            throw new RuntimeException();
        }
    }

    public void verbose(int n) {
        this.verbose = n;
    }

    public abstract void send(Packet var1) throws IOException;

    public abstract void quit();

    protected void vp(int n, String string) {
        if (this.verbose >= n) {
            System.out.print(string);
        }
    }

    protected void vpe(int n, String string) {
        if (this.verbose == n) {
            this.vp(n, string);
        }
    }

    protected void disp(Packet packet) {
        String[][] stringArray;
        int n = packet.cmdSet;
        int n2 = packet.cmd;
        int n3 = n;
        int n4 = n2;
        if (n < 64) {
            stringArray = this.VMcmds;
        } else if (n < 128) {
            stringArray = this.DBGcmds;
            n3 -= 64;
            n4 -= 99;
        } else {
            stringArray = this.VENcmds;
            n4 = 0;
            n3 = 0;
        }
        try {
            Log.LOGN(3, "Sending through: " + stringArray[n3][0] + "(" + n + ")/" + stringArray[n3][n4] + "(" + n2 + ")");
            Log.LOGN(8, "Packet: " + packet);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("UNKNOWN COMMAND: " + n + "/" + n2);
        }
    }
}

