/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import kdp.Log;
import kdp.Packet;
import kdp.ProxyListener;

class SocketConnection
implements Runnable {
    Socket socket;
    DataOutputStream out;
    DataInputStream in;
    ProxyListener proxy;

    SocketConnection(ProxyListener proxyListener, Socket socket) throws IOException {
        this.proxy = proxyListener;
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte receiveByte() throws IOException {
        int n = this.in.read();
        return (byte)n;
    }

    public void sendByte(byte by) throws IOException {
        this.out.write(by);
        this.out.flush();
    }

    public void run() {
        Thread.currentThread().setPriority(10);
        try {
            while (true) {
                Packet packet = this.receivePacket();
                if ((packet.flags & 0x80) == 0 || packet.id >= 0) {
                    this.proxy.newPacket(packet);
                    continue;
                }
                this.proxy.replyReceived(packet);
            }
        }
        catch (Exception exception) {
            try {
                Log.LOGN(2, "Socket exception in " + this.proxy + exception + " ...exiting");
                this.proxy.newPacket(null);
                this.proxy.replyReceived(null);
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
    }

    public Packet receivePacket() throws IOException {
        Packet packet = new Packet();
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new EOFException();
        }
        int n5 = (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
        n = this.in.read();
        n2 = this.in.read();
        n3 = this.in.read();
        n4 = this.in.read();
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new EOFException();
        }
        packet.id = (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
        packet.flags = (short)this.in.read();
        if (packet.flags < 0) {
            throw new EOFException();
        }
        if ((packet.flags & 0x80) == 0) {
            packet.cmdSet = (short)this.in.read();
            packet.cmd = (short)this.in.read();
            if (packet.cmdSet < 0 || packet.cmd < 0) {
                throw new EOFException();
            }
        } else {
            n = this.in.read();
            n2 = this.in.read();
            if (n < 0 || n2 < 0) {
                throw new EOFException();
            }
            packet.errorCode = (short)((n << 8) + (n2 << 0));
        }
        if ((n5 -= 11) < 0) {
            System.err.println("length is " + n5);
            System.err.println("Read is " + this.in.read());
        }
        packet.data = new byte[n5];
        int n6 = 0;
        while (n6 < packet.data.length) {
            int n7 = this.in.read(packet.data, n6, packet.data.length - n6);
            if (n7 < 0) {
                throw new EOFException();
            }
            n6 += n7;
        }
        return packet;
    }

    public void send(Packet packet) throws IOException {
        int n = packet.data.length + 11;
        this.out.write(n >>> 24 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 0 & 0xFF);
        this.out.write(packet.id >>> 24 & 0xFF);
        this.out.write(packet.id >>> 16 & 0xFF);
        this.out.write(packet.id >>> 8 & 0xFF);
        this.out.write(packet.id >>> 0 & 0xFF);
        this.out.write(packet.flags);
        if ((packet.flags & 0x80) == 0) {
            this.out.write(packet.cmdSet);
            this.out.write(packet.cmd);
        } else {
            this.out.write(packet.errorCode >>> 8 & 0xFF);
            this.out.write(packet.errorCode >>> 0 & 0xFF);
        }
        this.out.write(packet.data);
        this.out.flush();
    }
}

