/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import kdp.Log;
import kdp.classparser.AccessFlags;
import kdp.classparser.FieldInfo;
import kdp.classparser.FileReference;
import kdp.classparser.MethodInfo;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.attributes.SourceFileAttribute;
import kdp.classparser.constantpoolclasses.ConstantClassInfo;
import kdp.classparser.constantpoolclasses.ConstantDoubleInfo;
import kdp.classparser.constantpoolclasses.ConstantFieldrefInfo;
import kdp.classparser.constantpoolclasses.ConstantFloatInfo;
import kdp.classparser.constantpoolclasses.ConstantIntegerInfo;
import kdp.classparser.constantpoolclasses.ConstantInterfaceMethodrefInfo;
import kdp.classparser.constantpoolclasses.ConstantLongInfo;
import kdp.classparser.constantpoolclasses.ConstantMethodrefInfo;
import kdp.classparser.constantpoolclasses.ConstantNameAndTypeInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantStringInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class ClassFile {
    private static final int OBJECT_SUPER_CLASS_ID = 0;
    final byte TYPE_TAG_ARRAY = (byte)3;
    private String baseName;
    private String className;
    private String classSignature;
    private FileReference classFile;
    private int magic;
    private int majorVersion;
    private int minorVersion;
    private int constantPoolCount;
    private ConstantPoolInfo[] constantPool;
    private AccessFlags accessFlags;
    private int thisClass;
    private int superClass;
    private int interfacesCount;
    private int[] interfaces;
    private int fieldsCount;
    private FieldInfo[] fieldInfo;
    private int methodsCount;
    private MethodInfo[] methodInfo;
    private int attributesCount;
    private AttributeInfo[] attributes;
    private byte typeTag;
    int classID;
    int classStatus;

    public ClassFile(FileReference fileReference, String string, byte by) {
        this.classFile = fileReference;
        this.className = string;
        int n = string.lastIndexOf(47);
        this.baseName = n != -1 ? string.substring(n + 1) : string;
        this.typeTag = by;
        this.classSignature = by == 3 ? string : "L" + string.replace('.', '/') + ";";
    }

    public boolean equals(String string) {
        return this.className.equals(string);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassSignature() {
        return this.classSignature;
    }

    public String getClassFileName() {
        return this.classFile.toString();
    }

    public byte getJDWPTypeTag() {
        return this.typeTag;
    }

    public void setClassID(int n) {
        this.classID = n;
    }

    public int getClassID() {
        return this.classID;
    }

    public void setClassStatus(int n) {
        this.classStatus = n;
    }

    public int getClassStatus() {
        return this.classStatus;
    }

    public void readClassFile() throws IOException {
        try {
            DataInputStream dataInputStream = new DataInputStream(this.classFile.getInputStream());
            this.magic = dataInputStream.readInt();
            this.minorVersion = dataInputStream.readUnsignedShort();
            this.majorVersion = dataInputStream.readUnsignedShort();
            this.readConstantPool(dataInputStream);
            this.accessFlags = new AccessFlags(dataInputStream);
            this.thisClass = dataInputStream.readUnsignedShort();
            this.superClass = dataInputStream.readUnsignedShort();
            this.readInterfaces(dataInputStream);
            this.readFieldInfo(dataInputStream);
            this.readMethodInfo(dataInputStream);
            this.readAttributes(dataInputStream);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Caught IO Exception - " + iOException.getMessage());
            throw iOException;
        }
    }

    private int readConstantPool(DataInputStream dataInputStream) throws IOException {
        this.constantPoolCount = dataInputStream.readUnsignedShort();
        this.constantPool = new ConstantPoolInfo[this.constantPoolCount];
        int n = 1;
        while (n < this.constantPoolCount) {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 7: {
                    this.constantPool[n] = new ConstantClassInfo(dataInputStream);
                    break;
                }
                case 9: {
                    this.constantPool[n] = new ConstantFieldrefInfo(dataInputStream);
                    break;
                }
                case 10: {
                    this.constantPool[n] = new ConstantMethodrefInfo(dataInputStream);
                    break;
                }
                case 11: {
                    this.constantPool[n] = new ConstantInterfaceMethodrefInfo(dataInputStream);
                    break;
                }
                case 8: {
                    this.constantPool[n] = new ConstantStringInfo(dataInputStream);
                    break;
                }
                case 3: {
                    this.constantPool[n] = new ConstantIntegerInfo(dataInputStream);
                    break;
                }
                case 4: {
                    this.constantPool[n] = new ConstantFloatInfo(dataInputStream);
                    break;
                }
                case 5: {
                    this.constantPool[n] = new ConstantLongInfo(dataInputStream);
                    ++n;
                    break;
                }
                case 6: {
                    this.constantPool[n] = new ConstantDoubleInfo(dataInputStream);
                    ++n;
                    break;
                }
                case 12: {
                    this.constantPool[n] = new ConstantNameAndTypeInfo(dataInputStream);
                    break;
                }
                case 1: {
                    this.constantPool[n] = new ConstantUtf8Info(dataInputStream);
                    break;
                }
            }
            ++n;
        }
        return this.constantPoolCount;
    }

    private int readInterfaces(DataInputStream dataInputStream) throws IOException {
        this.interfacesCount = dataInputStream.readUnsignedShort();
        if (this.interfacesCount == 0) {
            return this.interfacesCount;
        }
        this.interfaces = new int[this.interfacesCount];
        int n = 0;
        while (n < this.interfacesCount) {
            this.interfaces[n] = dataInputStream.readUnsignedShort();
            ++n;
        }
        return this.interfacesCount;
    }

    private int readFieldInfo(DataInputStream dataInputStream) throws IOException {
        this.fieldsCount = dataInputStream.readUnsignedShort();
        this.fieldInfo = new FieldInfo[this.fieldsCount];
        int n = 0;
        while (n < this.fieldsCount) {
            this.fieldInfo[n] = new FieldInfo(dataInputStream, this.constantPool);
            ++n;
        }
        return this.fieldsCount;
    }

    public MethodInfo lookUpMethodByLineNumber(int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.methodsCount) {
            if (this.methodInfo[n2].containsLine(n)) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl ? this.methodInfo[n2] : null;
    }

    private int readMethodInfo(DataInputStream dataInputStream) throws IOException {
        this.methodsCount = dataInputStream.readUnsignedShort();
        this.methodInfo = new MethodInfo[this.methodsCount];
        int n = 0;
        while (n < this.methodsCount) {
            this.methodInfo[n] = new MethodInfo(dataInputStream, this.constantPool);
            ++n;
        }
        return this.methodsCount;
    }

    private int readAttributes(DataInputStream dataInputStream) throws IOException {
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        int n = 0;
        while (n < this.attributesCount) {
            this.attributes[n] = new AttributeInfo(dataInputStream, this.constantPool);
            ++n;
        }
        return this.attributesCount;
    }

    public MethodInfo getMethodInfoByName(String string, String string2) {
        int n = 0;
        while (n < this.methodsCount) {
            if (this.methodInfo[n].getName().equals(string) && this.methodInfo[n].getSignatureRaw().equals(string2)) {
                return this.methodInfo[n];
            }
            ++n;
        }
        return null;
    }

    public MethodInfo getMethodInfoByIndex(int n) {
        if (n > this.methodInfo.length) {
            return null;
        }
        return this.methodInfo[n];
    }

    public List getAllMethodInfo() {
        Vector<MethodInfo> vector = new Vector<MethodInfo>();
        int n = 0;
        while (n < this.methodInfo.length) {
            vector.add(this.methodInfo[n]);
            ++n;
        }
        return vector;
    }

    public List getAllFieldInfo() {
        Vector<FieldInfo> vector = new Vector<FieldInfo>();
        int n = 0;
        while (n < this.fieldInfo.length) {
            vector.add(this.fieldInfo[n]);
            ++n;
        }
        return vector;
    }

    public List getAllInterfaces() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.interfacesCount) {
            int n2 = ((ConstantClassInfo)this.constantPool[this.interfaces[n]]).getNameIndex();
            ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[n2];
            Log.LOGN(3, "interface: " + constantUtf8Info.toString());
            vector.add(constantUtf8Info.toString());
            ++n;
        }
        return vector;
    }

    public String getSuperClass() {
        if (this.superClass == 0) {
            return "";
        }
        ConstantClassInfo constantClassInfo = (ConstantClassInfo)this.constantPool[this.superClass];
        int n = constantClassInfo.getNameIndex();
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[n];
        return constantUtf8Info.toString();
    }

    public void print(PrintStream printStream) {
        printStream.println(this.accessFlags);
        ConstantClassInfo constantClassInfo = (ConstantClassInfo)this.constantPool[this.thisClass];
        int n = constantClassInfo.getNameIndex();
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[n];
        printStream.println("This Class:\t\t" + StringParser.parseClassName(constantUtf8Info.toString()));
        String string = this.getSuperClass();
        printStream.print("Superclass: ");
        if (string.equals("")) {
            printStream.println("None");
        } else {
            printStream.println(string);
        }
        if (this.interfacesCount > 0) {
            int n2 = 0;
            while (n2 < this.interfacesCount) {
                constantClassInfo = (ConstantClassInfo)this.constantPool[this.interfaces[n2]];
                n = constantClassInfo.getNameIndex();
                constantUtf8Info = (ConstantUtf8Info)this.constantPool[n];
                printStream.println("Interfaces:\t\t" + StringParser.parseClassName(constantUtf8Info.toString()));
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < this.fieldsCount) {
            printStream.println(this.fieldInfo[n3].toString());
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.methodsCount) {
            printStream.println(this.methodInfo[n4].toString());
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.attributesCount) {
            printStream.println(this.attributes[n5].toString());
            ++n5;
        }
    }

    public List getVariableTableForMethodIndex(int n) {
        MethodInfo methodInfo = null;
        boolean bl = false;
        boolean bl2 = false;
        List list = null;
        methodInfo = this.getMethodInfoByIndex(n);
        if (methodInfo != null) {
            list = methodInfo.getLocalVariables();
        }
        return list;
    }

    public int getRawAccessFlags() {
        return this.accessFlags.getRawAccessFlags();
    }

    public SourceFileAttribute getSourceAttribute() {
        int n = 0;
        boolean bl = false;
        while (!bl && n < this.attributesCount) {
            if (this.attributes[n].getType() == 7) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            AttributeInfo attributeInfo = this.attributes[n];
            return (SourceFileAttribute)attributeInfo.getInfo();
        }
        return null;
    }
}

