/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import kdp.Log;
import kdp.classparser.ClassFile;
import kdp.classparser.FileReference;
import kdp.classparser.SearchPath;

public class ClassManager {
    List classes = new Vector();
    SearchPath path = null;
    public static Map classMap = new HashMap(128, 0.75f);

    public ClassManager() {
    }

    public ClassManager(SearchPath searchPath) {
        this();
        this.path = searchPath;
    }

    private ClassFile loadClass(String string, FileReference fileReference, byte by) {
        Log.LOGN(3, "loadclass: " + fileReference);
        ClassFile classFile = new ClassFile(fileReference, string, by);
        try {
            classFile.readClassFile();
            this.classes.add(classFile);
        }
        catch (Exception exception) {
            Log.LOGN(2, "Error loading: " + fileReference);
            classFile = null;
        }
        return classFile;
    }

    public List getAllClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    public ClassFile findClass(byte by, String string) {
        ClassFile classFile = null;
        Iterator iterator = this.classes.iterator();
        while (iterator.hasNext()) {
            classFile = (ClassFile)iterator.next();
            if (!classFile.equals(string)) continue;
            return classFile;
        }
        if (by == 3) {
            Log.LOGN(4, "findclass: Array class " + string);
            classFile = new ClassFile(null, string, by);
            this.classes.add(classFile);
            return classFile;
        }
        if (this.path != null) {
            Log.LOGN(4, "findclass: finding " + string);
            FileReference fileReference = this.path.resolve(string);
            if (fileReference != null) {
                return this.loadClass(string, fileReference, by);
            }
        }
        return null;
    }
}

