/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import kdp.Log;
import kdp.classparser.FileReference;

public class SearchPath {
    private String pathString;
    private String[] pathArray;

    public SearchPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.pathString = string;
        Log.LOGN(3, "!!!" + this.pathString);
        this.pathArray = arrayList.toArray(new String[arrayList.size()]);
        Log.LOGN(3, "Path array length is :" + this.pathArray.length);
        int n = 0;
        while (n < this.pathArray.length) {
            Log.LOGN(3, this.pathArray[n]);
            ++n;
        }
    }

    public boolean isEmpty() {
        return this.pathArray.length == 0;
    }

    public String asString() {
        return this.pathString;
    }

    public String[] asArray() {
        return (String[])this.pathArray.clone();
    }

    public int path_array_length() {
        return this.pathArray.length;
    }

    public FileReference resolve(String string) {
        Log.LOGN(4, "relative filename = " + string);
        Log.LOGN(4, "path array length in resolve is " + this.pathArray.length);
        if (!string.endsWith(".class")) {
            string = string + ".class";
        }
        Log.LOGN(4, "relative filename now = " + string);
        int n = 0;
        while (n < this.pathArray.length) {
            Log.LOGN(5, "pa=" + this.pathArray[n] + " " + "rfa=" + string);
            FileReference fileReference = FileReference.create(this.pathArray[n], string);
            if (fileReference.exists()) {
                Log.LOGN(4, "  exists");
                return fileReference;
            }
            ++n;
        }
        return null;
    }

    public String[] children(String string, FilenameFilter filenameFilter) {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < this.pathArray.length) {
            String[] stringArray;
            FileReference fileReference = FileReference.create(this.pathArray[n], string);
            if (fileReference.exists() && (stringArray = fileReference.list(filenameFilter)) != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (!treeSet.contains(stringArray[n2])) {
                        treeSet.add(stringArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

