/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.attributes.ExceptionTable;
import kdp.classparser.attributes.LineNumberTableAttribute;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class CodeAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int maxStack;
    private int maxLocals;
    private int codeLength;
    private byte[] code;
    private int exceptionTableLength;
    private ExceptionTable[] exceptionTable;
    private int attributesCount;
    private AttributeInfo[] attributes;

    public CodeAttribute(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray, int n, int n2) throws IOException {
        this.attributeNameIndex = n;
        this.attributeLength = n2;
        this.maxStack = dataInputStream.readUnsignedShort();
        this.maxLocals = dataInputStream.readUnsignedShort();
        this.codeLength = dataInputStream.readInt();
        this.code = new byte[this.codeLength];
        int n3 = 0;
        while (n3 < this.codeLength) {
            this.code[n3] = dataInputStream.readByte();
            ++n3;
        }
        this.exceptionTableLength = dataInputStream.readUnsignedShort();
        this.exceptionTable = new ExceptionTable[this.exceptionTableLength];
        int n4 = 0;
        while (n4 < this.exceptionTableLength) {
            this.exceptionTable[n4] = new ExceptionTable(dataInputStream);
            ++n4;
        }
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        int n5 = 0;
        while (n5 < this.attributesCount) {
            this.attributes[n5] = new AttributeInfo(dataInputStream, constantPoolInfoArray);
            ++n5;
        }
    }

    public LineNumberTableAttribute getLineNumberTable() {
        int n = 0;
        boolean bl = false;
        while (!bl && n < this.attributesCount) {
            if (this.attributes[n].getType() == 5) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            AttributeInfo attributeInfo = this.attributes[n];
            LineNumberTableAttribute lineNumberTableAttribute = (LineNumberTableAttribute)attributeInfo.getInfo();
            return lineNumberTableAttribute;
        }
        return null;
    }

    public boolean containsLine(int n) {
        LineNumberTableAttribute lineNumberTableAttribute = this.getLineNumberTable();
        if (lineNumberTableAttribute != null) {
            return lineNumberTableAttribute.containsLine(n);
        }
        return false;
    }

    public byte[] getByteCodes() {
        byte[] byArray = new byte[this.code.length];
        System.arraycopy(this.code, 0, byArray, 0, this.code.length);
        return byArray;
    }

    public String toString(ConstantPoolInfo[] constantPoolInfoArray) {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        string = string + constantUtf8Info.toString();
        int n = 0;
        while (n < this.attributesCount) {
            string = string + "\n\t\t" + this.attributes[n].toString();
            ++n;
        }
        return string;
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }
}

