/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.constantpoolclasses.ConstantClassInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class ExceptionsAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int numberOfExceptions;
    private int[] exceptionIndexTable;

    public ExceptionsAttribute(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.attributeNameIndex = n;
        this.attributeLength = n2;
        this.numberOfExceptions = dataInputStream.readUnsignedShort();
        this.exceptionIndexTable = new int[this.numberOfExceptions];
        int n3 = 0;
        while (n3 < this.numberOfExceptions) {
            this.exceptionIndexTable[n3] = dataInputStream.readUnsignedShort();
            ++n3;
        }
    }

    public String toString(ConstantPoolInfo[] constantPoolInfoArray) {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        string = string + constantUtf8Info.toString();
        int n = 0;
        while (n < this.numberOfExceptions) {
            int n2 = this.exceptionIndexTable[n];
            ConstantClassInfo constantClassInfo = (ConstantClassInfo)constantPoolInfoArray[n2];
            constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[constantClassInfo.getNameIndex()];
            string = string + "\n\t\t\tThrows\t";
            string = string + StringParser.parseClassName(constantUtf8Info.toString());
            ++n;
        }
        return string;
    }
}

