/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.InnerClassesTable;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class InnerClassesAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int numberOfClasses;
    private InnerClassesTable[] classes;

    public InnerClassesAttribute(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.attributeNameIndex = n;
        this.attributeLength = n2;
        this.numberOfClasses = dataInputStream.readUnsignedShort();
        this.classes = new InnerClassesTable[this.numberOfClasses];
        int n3 = 0;
        while (n3 < this.numberOfClasses) {
            this.classes[n3] = new InnerClassesTable(dataInputStream);
            ++n3;
        }
    }

    public String toString(ConstantPoolInfo[] constantPoolInfoArray) {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        string = string + "\t" + constantUtf8Info.toString() + "\tNot Done";
        int n = 0;
        while (n < this.numberOfClasses) {
            string = string + "\n\t\t\t" + this.classes[n];
            ++n;
        }
        return string;
    }
}

