/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.Log;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.LineNumberTable;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class LineNumberTableAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int lineNumberTableLength;
    private LineNumberTable[] lineNumberTable;

    public LineNumberTableAttribute(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.attributeNameIndex = n;
        this.attributeLength = n2;
        this.lineNumberTableLength = dataInputStream.readUnsignedShort();
        this.lineNumberTable = new LineNumberTable[this.lineNumberTableLength];
        int n3 = 0;
        while (n3 < this.lineNumberTableLength) {
            this.lineNumberTable[n3] = new LineNumberTable();
            this.lineNumberTable[n3].startPC = dataInputStream.readUnsignedShort();
            this.lineNumberTable[n3].lineNumber = dataInputStream.readUnsignedShort();
            ++n3;
        }
    }

    public int[][] getLineNumbersAndIndicesAsArray() {
        int[][] nArray = new int[this.lineNumberTableLength][2];
        int n = 0;
        while (n < this.lineNumberTableLength) {
            nArray[n][0] = this.lineNumberTable[n].lineNumber;
            nArray[n][1] = this.lineNumberTable[n].startPC;
            ++n;
        }
        return nArray;
    }

    public int getCodeIndexBySourceLineNumber(int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.lineNumberTableLength) {
            if (n == this.lineNumberTable[n2].lineNumber) {
                bl = true;
                continue;
            }
            ++n2;
        }
        if (bl) {
            return this.lineNumberTable[n2].startPC;
        }
        return -1;
    }

    public boolean containsLine(int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.lineNumberTableLength) {
            if (n == this.lineNumberTable[n2].lineNumber) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl;
    }

    private int getIndexThatContainsOpcode(long l) {
        int n = 0;
        while (n < this.lineNumberTableLength - 1) {
            if (l >= (long)this.lineNumberTable[n].startPC && l < (long)this.lineNumberTable[n + 1].startPC) {
                return n;
            }
            ++n;
        }
        if (l >= (long)this.lineNumberTable[this.lineNumberTableLength - 1].startPC) {
            return this.lineNumberTableLength - 1;
        }
        return -1;
    }

    public int getDupCurrentExecutableLineCodeIndex(long l) {
        int n = this.getNextExecutableLineCodeIndex(l, false);
        if (n == -1) {
            return -1;
        }
        return this.getOtherLineIndex(--n);
    }

    public long getOffsetofDupNextLine(int n) {
        if (n == -1 || n == this.lineNumberTableLength - 1) {
            return -1L;
        }
        return this.lineNumberTable[n + 1].startPC;
    }

    private int getOtherLineIndex(int n) {
        int n2 = 0;
        while (n2 < this.lineNumberTableLength) {
            if (n2 != n && this.lineNumberTable[n2].lineNumber == this.lineNumberTable[n].lineNumber) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getCurrentLineCodeIndex(long l) {
        int n = this.getIndexThatContainsOpcode(l);
        Log.LOGN(3, "getCurrent: index=" + n);
        return n;
    }

    public int getNextExecutableLineCodeIndex(long l) {
        return this.getNextExecutableLineCodeIndex(l, true);
    }

    private int getNextExecutableLineCodeIndex(long l, boolean bl) {
        int n;
        int n2 = this.getIndexThatContainsOpcode(l);
        if (bl) {
            Log.LOGN(3, "getNext: firstIndex=" + n2);
        }
        if ((n = this.getOtherLineIndex(n2)) != -1) {
            if (bl) {
                Log.LOGN(3, "getNext: otherIndex=" + n);
            }
            if (n < n2) {
                if (bl) {
                    Log.LOGN(3, "getNext: otherIndex < firstIndex");
                }
                return n + 1;
            }
            if (bl) {
                Log.LOGN(3, "getNext: otherIndex > firstIndex");
            }
            return n2 + 1;
        }
        if (n2 + 1 < this.lineNumberTableLength) {
            return n2 + 1;
        }
        return -1;
    }

    public long getStartPCFromIndex(int n) {
        if (n == -1) {
            return -1L;
        }
        return this.lineNumberTable[n].startPC;
    }

    public int getLineNumberFromIndex(int n) {
        if (n == -1 || n == this.lineNumberTableLength - 1) {
            return -1;
        }
        return this.lineNumberTable[n].lineNumber;
    }

    public String toString(ConstantPoolInfo[] constantPoolInfoArray) {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        string = string + "\t" + constantUtf8Info.toString();
        return string;
    }
}

