/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.constantpoolclasses;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;

public class ConstantDoubleInfo
extends ConstantPoolInfo {
    private int highBytes;
    private int lowBytes;

    public ConstantDoubleInfo(DataInputStream dataInputStream) throws IOException {
        this.tag = (byte)6;
        this.highBytes = dataInputStream.readInt();
        this.lowBytes = dataInputStream.readInt();
    }

    public String toString() {
        long l = ((long)this.highBytes << 32) + (long)this.lowBytes;
        if (l == 0x7FF0000000000000L) {
            return "CONSTANT_Double=\tPositive Infinity";
        }
        if (l == -4503599627370496L) {
            return "CONSTANT_Double=\tNegative Infinity";
        }
        if (l >= 9218868437227405313L && l <= Long.MAX_VALUE || l >= -4503599627370495L && l <= -1L) {
            return "CONSTANT_Double=\tNaN";
        }
        int n = l >> 63 == 0L ? 1 : -1;
        int n2 = (int)(l >> 52 & 0x7FFL);
        long l2 = n2 == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        double d = (long)n * l2 * (long)(2 ^ n2 - 1075);
        return "CONSTANT_Double=\t" + d;
    }
}

